/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.transform.bukkit;

import eu.cloudnetservice.wrapper.transform.ClassTransformer;
import java.lang.classfile.ClassFileElement;
import java.lang.classfile.ClassTransform;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.CodeElement;
import java.lang.classfile.CodeTransform;
import java.lang.classfile.Opcode;
import java.lang.classfile.instruction.ConstantInstruction;
import java.lang.classfile.instruction.FieldInstruction;
import java.lang.classfile.instruction.InvokeInstruction;
import java.lang.classfile.instruction.ReturnInstruction;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BukkitJavaVersionCheckTransformer
implements ClassTransformer {
    private static final String MN_MAIN = "main";
    private static final String CNI_CRAFT_BUKKIT_MAIN = "org/bukkit/craftbukkit/Main";
    private static final String CNI_SYSTEM = "java/lang/System";
    private static final String CNI_PRINT_STREAM = "java/io/PrintStream";
    private static final ClassDesc CD_PRINT_STREAM = ClassDesc.ofInternalName("java/io/PrintStream");

    @Override
    @NonNull
    public ClassTransform provideClassTransform() {
        CodeTransform codeTransform = CodeTransform.ofStateful(BukkitJavaVersionCheckRemoveCodeTransform::new);
        return ClassTransform.transformingMethodBodies(mm -> mm.methodName().equalsString(MN_MAIN), (CodeTransform)codeTransform);
    }

    @Override
    @NonNull
    public ClassTransformer.TransformWillingness classTransformWillingness(@NonNull String internalClassName) {
        if (internalClassName == null) {
            throw new NullPointerException("internalClassName is marked non-null but is null");
        }
        boolean isCraftBukkitMain = internalClassName.equals(CNI_CRAFT_BUKKIT_MAIN);
        return isCraftBukkitMain ? ClassTransformer.TransformWillingness.ACCEPT_ONCE : ClassTransformer.TransformWillingness.REJECT;
    }

    private static final class BukkitJavaVersionCheckRemoveCodeTransform
    implements CodeTransform {
        private static final byte DROP_STATE_IDLE = 0;
        private static final byte DROP_STATE_DROPPING = 1;
        private static final byte DROP_STATE_DISABLED = 2;
        private byte dropState = 0;
        private boolean preparingToPrint = false;

        private BukkitJavaVersionCheckRemoveCodeTransform() {
        }

        public void accept(@NonNull CodeBuilder builder, @NonNull CodeElement element) {
            ConstantInstruction.LoadConstantInstruction inst;
            ConstantDesc constantDesc;
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            if (element == null) {
                throw new NullPointerException("element is marked non-null but is null");
            }
            if (element instanceof ConstantInstruction.LoadConstantInstruction && (constantDesc = (inst = (ConstantInstruction.LoadConstantInstruction)element).constantValue()) instanceof String) {
                String value = (String)((Object)constantDesc);
                if (value.equals("java.class.version") && this.dropState == 0) {
                    this.dropState = 1;
                } else if (value.equals("nojline") || value.startsWith("Loading libraries")) {
                    this.dropState = (byte)2;
                }
            }
            if (this.preparingToPrint) {
                if (element instanceof InvokeInstruction && (inst = (InvokeInstruction)element).opcode() == Opcode.INVOKEVIRTUAL && inst.name().stringValue().startsWith("print") && inst.owner().asInternalName().equals(BukkitJavaVersionCheckTransformer.CNI_PRINT_STREAM)) {
                    this.preparingToPrint = false;
                }
                return;
            }
            if (element instanceof ReturnInstruction && this.dropState == 1) {
                return;
            }
            if (element instanceof FieldInstruction && (inst = (FieldInstruction)element).opcode() == Opcode.GETSTATIC && inst.owner().asInternalName().equals(BukkitJavaVersionCheckTransformer.CNI_SYSTEM) && inst.type().equalsString(CD_PRINT_STREAM.descriptorString()) && this.dropState == 1) {
                this.preparingToPrint = true;
                return;
            }
            builder.accept((ClassFileElement)element);
        }
    }
}

