/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.transform.bukkit;

import eu.cloudnetservice.wrapper.transform.ClassTransformer;
import java.lang.classfile.ClassTransform;
import java.lang.classfile.CodeTransform;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class WorldEditJava8DetectorTransformer
implements ClassTransformer {
    private static final String CN_JAVA_8_DETECTOR = "com/sk89q/worldedit/util/Java8Detector";
    private static final String MN_NOTIFY_IF_NOT_8 = "notifyIfNot8";

    @Override
    @NonNull
    public ClassTransform provideClassTransform() {
        CodeTransform codeTransform = (builder, codeElement) -> builder.return_();
        return ClassTransform.transformingMethodBodies(mm -> mm.methodName().equalsString(MN_NOTIFY_IF_NOT_8), (CodeTransform)codeTransform);
    }

    @Override
    @NonNull
    public ClassTransformer.TransformWillingness classTransformWillingness(@NonNull String internalClassName) {
        if (internalClassName == null) {
            throw new NullPointerException("internalClassName is marked non-null but is null");
        }
        boolean isJava8Detector = internalClassName.equals(CN_JAVA_8_DETECTOR);
        return isJava8Detector ? ClassTransformer.TransformWillingness.ACCEPT_ONCE : ClassTransformer.TransformWillingness.REJECT;
    }
}

