/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.transform.minestom;

import eu.cloudnetservice.wrapper.transform.ClassTransformer;
import java.lang.classfile.ClassFileElement;
import java.lang.classfile.ClassTransform;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.CodeElement;
import java.lang.classfile.CodeModel;
import java.lang.classfile.CodeTransform;
import java.lang.classfile.instruction.ReturnInstruction;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.SequencedCollection;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MinestomStopCleanlyTransformer
implements ClassTransformer {
    private static final String MN_SYSTEM_EXIT = "exit";
    private static final String MN_SERVER_PROCESS_STOP = "stop";
    private static final ClassDesc CD_SYSTEM = ClassDesc.of(System.class.getName());
    private static final String CNI_MINECRAFT_SERVER = "net/minestom/server/ServerProcessImpl";
    private static final MethodTypeDesc MTD_EXIT = MethodTypeDesc.of(ConstantDescs.CD_void, ConstantDescs.CD_int);

    public MinestomStopCleanlyTransformer() {
        boolean transformerDisabled = Boolean.getBoolean("cloudnet.wrapper.minestom-stop-transform-disabled");
        if (transformerDisabled) {
            throw new UnsupportedOperationException("transformer disabled via system property");
        }
    }

    @Override
    @NonNull
    public ClassTransform provideClassTransform() {
        CodeTransform codeTransform = CodeTransform.ofStateful(ServerProcessImplStopCodeTransform::new);
        return ClassTransform.transformingMethodBodies(mm -> mm.methodName().equalsString(MN_SERVER_PROCESS_STOP), (CodeTransform)codeTransform);
    }

    @Override
    @NonNull
    public ClassTransformer.TransformWillingness classTransformWillingness(@NonNull String internalClassName) {
        if (internalClassName == null) {
            throw new NullPointerException("internalClassName is marked non-null but is null");
        }
        boolean isServerProcessImpl = internalClassName.equals(CNI_MINECRAFT_SERVER);
        return isServerProcessImpl ? ClassTransformer.TransformWillingness.ACCEPT_ONCE : ClassTransformer.TransformWillingness.REJECT;
    }

    private static final class ServerProcessImplStopCodeTransform
    implements CodeTransform {
        private CodeElement lastReturnElement;

        private ServerProcessImplStopCodeTransform() {
        }

        public void atStart(@NonNull CodeBuilder builder) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            CodeModel codeModel = (CodeModel)builder.original().orElseThrow(() -> new IllegalStateException("original method code unknown"));
            SequencedCollection reversedElements = codeModel.elementList().reversed();
            for (CodeElement element : reversedElements) {
                if (!(element instanceof ReturnInstruction)) continue;
                this.lastReturnElement = element;
                return;
            }
        }

        public void accept(@NonNull CodeBuilder builder, @NonNull CodeElement element) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            if (element == null) {
                throw new NullPointerException("element is marked non-null but is null");
            }
            if (element == this.lastReturnElement) {
                builder.iconst_0().invokestatic(CD_SYSTEM, MinestomStopCleanlyTransformer.MN_SYSTEM_EXIT, MTD_EXIT);
            }
            builder.accept((ClassFileElement)element);
        }
    }
}

