/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.transform.spark;

import eu.cloudnetservice.common.util.StringUtil;
import eu.cloudnetservice.wrapper.transform.ClassTransformer;
import java.lang.classfile.ClassBuilder;
import java.lang.classfile.ClassElement;
import java.lang.classfile.ClassFileElement;
import java.lang.classfile.ClassModel;
import java.lang.classfile.ClassTransform;
import java.lang.classfile.MethodModel;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.AccessFlag;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class OldAsyncProfilerDisableTransformer
implements ClassTransformer {
    private static final String MN_LOAD = "load";
    private static final String MN_IS_LINUX_MUSL = "isLinuxMusl";
    private static final String CNI_ASYNC_PROFILER_ACC_PREFIX = "me/lucko/spark/";
    private static final String CNI_ASYNC_PROFILER_ACC_SUFFIX = "/common/sampler/async/AsyncProfilerAccess";
    private static final ClassDesc CD_UNSUPPORTED_OP_EX = ClassDesc.of(UnsupportedOperationException.class.getName());
    private static final MethodTypeDesc MTD_UNSUPPORTED_OP_EX_NEW = MethodTypeDesc.of(ConstantDescs.CD_void, ConstantDescs.CD_String);

    @Override
    @NonNull
    public ClassTransform provideClassTransform() {
        return new AsyncProfilerAccessClassTransform();
    }

    @Override
    @NonNull
    public ClassTransformer.TransformWillingness classTransformWillingness(@NonNull String internalClassName) {
        if (internalClassName == null) {
            throw new NullPointerException("internalClassName is marked non-null but is null");
        }
        boolean isAsyncProfilerAccessClass = internalClassName.startsWith(CNI_ASYNC_PROFILER_ACC_PREFIX) && internalClassName.endsWith(CNI_ASYNC_PROFILER_ACC_SUFFIX);
        return isAsyncProfilerAccessClass ? ClassTransformer.TransformWillingness.ACCEPT_ONCE : ClassTransformer.TransformWillingness.REJECT;
    }

    private static final class AsyncProfilerAccessClassTransform
    implements ClassTransform {
        private boolean isLinuxMuslExists = false;
        private boolean isLinuxAarch64 = false;

        private AsyncProfilerAccessClassTransform() {
        }

        public void atStart(@NonNull ClassBuilder builder) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            ClassModel classModel = (ClassModel)builder.original().orElseThrow(() -> new IllegalStateException("original not preset on remap"));
            this.isLinuxMuslExists = classModel.methods().stream().anyMatch(methodModel -> {
                boolean isStatic = methodModel.flags().has(AccessFlag.STATIC);
                return isStatic && methodModel.methodName().equalsString(OldAsyncProfilerDisableTransformer.MN_IS_LINUX_MUSL);
            });
            String arch = StringUtil.toLower((String)System.getProperty("os.arch"));
            String osName = StringUtil.toLower((String)System.getProperty("os.name"));
            this.isLinuxAarch64 = osName.equals("linux") && arch.equals("aarch64");
        }

        /*
         * Enabled aggressive block sorting
         */
        public void accept(@NonNull ClassBuilder builder, @NonNull ClassElement element) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            if (element == null) {
                throw new NullPointerException("element is marked non-null but is null");
            }
            if (element instanceof MethodModel) {
                MethodModel mm = (MethodModel)element;
                if (!this.isLinuxAarch64 && this.isLinuxMuslExists && mm.flags().has(AccessFlag.STATIC) && mm.methodName().equalsString(OldAsyncProfilerDisableTransformer.MN_LOAD)) {
                    builder.withMethodBody(mm.methodName(), mm.methodType(), mm.flags().flagsMask(), code -> code.new_(CD_UNSUPPORTED_OP_EX).dup().ldc((ConstantDesc)((Object)"this version of spark uses a version of async-profiler which does not support java 23+")).invokespecial(CD_UNSUPPORTED_OP_EX, "<init>", MTD_UNSUPPORTED_OP_EX_NEW).athrow());
                    return;
                }
            }
            builder.with((ClassFileElement)element);
        }
    }
}

