/**
 * This class file was automatically generated by jASN1 v1.11.2 (http://www.beanit.com)
 */

package eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.cltu.structures;

import java.io.IOException;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.io.Serializable;
import com.beanit.jasn1.ber.*;
import com.beanit.jasn1.ber.types.*;
import com.beanit.jasn1.ber.types.string.*;

import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.pdus.ReportingCycle;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.ConditionalTime;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.DeliveryMode;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.Diagnostics;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.Duration;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.ForwardDuStatus;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.IntPosLong;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.IntPosShort;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.IntUnsignedLong;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.IntUnsignedShort;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.ParameterName;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.SpaceLinkDataUnit;
import eu.dariolucia.ccsds.sle.generated.ccsds.sle.transfer.service.common.types.Time;

public class CltuLastProcessed implements BerType, Serializable {

	private static final long serialVersionUID = 1L;

	public byte[] code = null;
	public static class CltuProcessed implements BerType, Serializable {

		private static final long serialVersionUID = 1L;

		public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);

		public byte[] code = null;
		private CltuIdentification cltuIdentification = null;
		private ConditionalTime startRadiationTime = null;
		private CltuStatus cltuStatus = null;
		
		public CltuProcessed() {
		}

		public CltuProcessed(byte[] code) {
			this.code = code;
		}

		public void setCltuIdentification(CltuIdentification cltuIdentification) {
			this.cltuIdentification = cltuIdentification;
		}

		public CltuIdentification getCltuIdentification() {
			return cltuIdentification;
		}

		public void setStartRadiationTime(ConditionalTime startRadiationTime) {
			this.startRadiationTime = startRadiationTime;
		}

		public ConditionalTime getStartRadiationTime() {
			return startRadiationTime;
		}

		public void setCltuStatus(CltuStatus cltuStatus) {
			this.cltuStatus = cltuStatus;
		}

		public CltuStatus getCltuStatus() {
			return cltuStatus;
		}

		public int encode(OutputStream reverseOS) throws IOException {
			return encode(reverseOS, true);
		}

		public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

			if (code != null) {
				for (int i = code.length - 1; i >= 0; i--) {
					reverseOS.write(code[i]);
				}
				if (withTag) {
					return tag.encode(reverseOS) + code.length;
				}
				return code.length;
			}

			int codeLength = 0;
			codeLength += cltuStatus.encode(reverseOS, true);
			
			codeLength += startRadiationTime.encode(reverseOS);
			
			codeLength += cltuIdentification.encode(reverseOS, true);
			
			codeLength += BerLength.encodeLength(reverseOS, codeLength);

			if (withTag) {
				codeLength += tag.encode(reverseOS);
			}

			return codeLength;

		}

		public int decode(InputStream is) throws IOException {
			return decode(is, true);
		}

		public int decode(InputStream is, boolean withTag) throws IOException {
			int codeLength = 0;
			int subCodeLength = 0;
			BerTag berTag = new BerTag();

			if (withTag) {
				codeLength += tag.decodeAndCheck(is);
			}

			BerLength length = new BerLength();
			codeLength += length.decode(is);

			int totalLength = length.val;
			codeLength += totalLength;

			subCodeLength += berTag.decode(is);
			if (berTag.equals(CltuIdentification.tag)) {
				cltuIdentification = new CltuIdentification();
				subCodeLength += cltuIdentification.decode(is, false);
				subCodeLength += berTag.decode(is);
			}
			else {
				throw new IOException("Tag does not match the mandatory sequence element tag.");
			}
			
			startRadiationTime = new ConditionalTime();
			subCodeLength += startRadiationTime.decode(is, berTag);
			subCodeLength += berTag.decode(is);
			
			if (berTag.equals(CltuStatus.tag)) {
				cltuStatus = new CltuStatus();
				subCodeLength += cltuStatus.decode(is, false);
				if (subCodeLength == totalLength) {
					return codeLength;
				}
			}
			throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);

			
		}

		public void encodeAndSave(int encodingSizeGuess) throws IOException {
			ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
			encode(reverseOS, false);
			code = reverseOS.getArray();
		}

		public String toString() {
			StringBuilder sb = new StringBuilder();
			appendAsString(sb, 0);
			return sb.toString();
		}

		public void appendAsString(StringBuilder sb, int indentLevel) {

			sb.append("{");
			sb.append("\n");
			for (int i = 0; i < indentLevel + 1; i++) {
				sb.append("\t");
			}
			if (cltuIdentification != null) {
				sb.append("cltuIdentification: ").append(cltuIdentification);
			}
			else {
				sb.append("cltuIdentification: <empty-required-field>");
			}
			
			sb.append(",\n");
			for (int i = 0; i < indentLevel + 1; i++) {
				sb.append("\t");
			}
			if (startRadiationTime != null) {
				sb.append("startRadiationTime: ");
				startRadiationTime.appendAsString(sb, indentLevel + 1);
			}
			else {
				sb.append("startRadiationTime: <empty-required-field>");
			}
			
			sb.append(",\n");
			for (int i = 0; i < indentLevel + 1; i++) {
				sb.append("\t");
			}
			if (cltuStatus != null) {
				sb.append("cltuStatus: ").append(cltuStatus);
			}
			else {
				sb.append("cltuStatus: <empty-required-field>");
			}
			
			sb.append("\n");
			for (int i = 0; i < indentLevel; i++) {
				sb.append("\t");
			}
			sb.append("}");
		}

	}

	private BerNull noCltuProcessed = null;
	private CltuProcessed cltuProcessed = null;
	
	public CltuLastProcessed() {
	}

	public CltuLastProcessed(byte[] code) {
		this.code = code;
	}

	public void setNoCltuProcessed(BerNull noCltuProcessed) {
		this.noCltuProcessed = noCltuProcessed;
	}

	public BerNull getNoCltuProcessed() {
		return noCltuProcessed;
	}

	public void setCltuProcessed(CltuProcessed cltuProcessed) {
		this.cltuProcessed = cltuProcessed;
	}

	public CltuProcessed getCltuProcessed() {
		return cltuProcessed;
	}

	public int encode(OutputStream reverseOS) throws IOException {

		if (code != null) {
			for (int i = code.length - 1; i >= 0; i--) {
				reverseOS.write(code[i]);
			}
			return code.length;
		}

		int codeLength = 0;
		if (cltuProcessed != null) {
			codeLength += cltuProcessed.encode(reverseOS, false);
			// write tag: CONTEXT_CLASS, CONSTRUCTED, 1
			reverseOS.write(0xA1);
			codeLength += 1;
			return codeLength;
		}
		
		if (noCltuProcessed != null) {
			codeLength += noCltuProcessed.encode(reverseOS, false);
			// write tag: CONTEXT_CLASS, PRIMITIVE, 0
			reverseOS.write(0x80);
			codeLength += 1;
			return codeLength;
		}
		
		throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
	}

	public int decode(InputStream is) throws IOException {
		return decode(is, null);
	}

	public int decode(InputStream is, BerTag berTag) throws IOException {

		int codeLength = 0;
		BerTag passedTag = berTag;

		if (berTag == null) {
			berTag = new BerTag();
			codeLength += berTag.decode(is);
		}

		if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
			noCltuProcessed = new BerNull();
			codeLength += noCltuProcessed.decode(is, false);
			return codeLength;
		}

		if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 1)) {
			cltuProcessed = new CltuProcessed();
			codeLength += cltuProcessed.decode(is, false);
			return codeLength;
		}

		if (passedTag != null) {
			return 0;
		}

		throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
	}

	public void encodeAndSave(int encodingSizeGuess) throws IOException {
		ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
		encode(reverseOS);
		code = reverseOS.getArray();
	}

	public String toString() {
		StringBuilder sb = new StringBuilder();
		appendAsString(sb, 0);
		return sb.toString();
	}

	public void appendAsString(StringBuilder sb, int indentLevel) {

		if (noCltuProcessed != null) {
			sb.append("noCltuProcessed: ").append(noCltuProcessed);
			return;
		}

		if (cltuProcessed != null) {
			sb.append("cltuProcessed: ");
			cltuProcessed.appendAsString(sb, indentLevel + 1);
			return;
		}

		sb.append("<none>");
	}

}

