/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.batch.db;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import eu.eventstorm.batch.Batch;
import eu.eventstorm.batch.BatchExecutor;
import eu.eventstorm.batch.BatchJob;
import eu.eventstorm.batch.BatchStatus;
import eu.eventstorm.batch.db.DatabaseBatchJobContext;
import eu.eventstorm.batch.db.DatabaseExecution;
import eu.eventstorm.batch.db.DatabaseExecutionBuilder;
import eu.eventstorm.batch.db.DatabaseExecutionRepository;
import eu.eventstorm.core.Event;
import eu.eventstorm.core.EventCandidate;
import eu.eventstorm.core.UUID;
import eu.eventstorm.cqrs.batch.BatchJobCreated;
import eu.eventstorm.sql.Database;
import eu.eventstorm.sql.Transaction;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.concurrent.ListenableFutureCallback;

public final class DatabaseBatch
implements Batch {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseBatch.class);
    private final BatchExecutor batchExecutor;
    private final ApplicationContext applicationContext;
    private final Database database;
    private final DatabaseExecutionRepository repository;

    public DatabaseBatch(ApplicationContext applicationContext, BatchExecutor batchExecutor, Database database, DatabaseExecutionRepository repository) {
        this.applicationContext = applicationContext;
        this.batchExecutor = batchExecutor;
        this.database = database;
        this.repository = repository;
    }

    @Override
    public Event push(EventCandidate<BatchJobCreated> candidate) {
        java.util.UUID correlation = java.util.UUID.randomUUID();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("correlation id =[{}]", (Object)correlation);
        }
        BatchJob batchJob = (BatchJob)this.applicationContext.getBean(((BatchJobCreated)candidate.getMessage()).getName(), BatchJob.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BatchJob =[{}]", (Object)batchJob);
        }
        Event event = Event.newBuilder().setStreamId(candidate.getStreamId().toStringValue()).setStream(candidate.getStream()).setCorrelation(UUID.newBuilder().setLeastSigBits(correlation.getLeastSignificantBits()).setMostSigBits(correlation.getMostSignificantBits())).setRevision(1).setTimestamp(OffsetDateTime.now().toString()).setData(Any.pack((Message)candidate.getMessage(), (String)candidate.getStream())).build();
        DatabaseExecution batchExecution = new DatabaseExecutionBuilder().withName(candidate.getStream()).withStatus((byte)BatchStatus.STARTING.ordinal()).withResources(this.database.dialect().createJson((List)((BatchJobCreated)candidate.getMessage()).getUuidList())).withUuid(correlation.toString()).withStartedAt(Timestamp.from(Instant.now())).build();
        DatabaseBatchJobContext context = new DatabaseBatchJobContext(this.database, batchExecution);
        this.batchExecutor.submit(batchJob, context).addCallback(new DatabaseBatchListenableFutureCallback(context));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("submitted");
        }
        return event;
    }

    private class DatabaseBatchListenableFutureCallback<V>
    implements ListenableFutureCallback<V> {
        private final DatabaseBatchJobContext context;

        private DatabaseBatchListenableFutureCallback(DatabaseBatchJobContext context) {
            this.context = context;
        }

        public void onSuccess(V result) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("onSuccess()");
            }
            try (Transaction tx = DatabaseBatch.this.database.transactionManager().newTransactionReadWrite();){
                DatabaseBatch.this.repository.update(this.context.getDatabaseExecution());
            }
        }

        public void onFailure(Throwable ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("onFailure()", ex);
            }
            try (Transaction tx = DatabaseBatch.this.database.transactionManager().newTransactionReadWrite();){
                DatabaseBatch.this.repository.update(this.context.getDatabaseExecution());
            }
        }
    }
}

