/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.batch.file;

import eu.eventstorm.batch.config.ResourceProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class FileResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResource.class);
    private final ResourceProperties properties;

    public FileResource(ResourceProperties properties) {
        this.properties = properties;
        Path path = Paths.get(properties.getTemporaryDirectory(), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Path touch(String uuid) throws IOException {
        Path file = Paths.get(this.properties.getTemporaryDirectory(), uuid);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("touch({})", (Object)file);
        }
        return file;
    }

    public Path get(String uuid) {
        return Paths.get(this.properties.getTemporaryDirectory(), uuid);
    }

    public void delete(String uuid) throws IOException {
        Path file = Paths.get(this.properties.getTemporaryDirectory(), uuid);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("delete({})", (Object)file);
        }
        Files.delete(file);
    }
}

