/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.batch.rest;

import eu.eventstorm.batch.file.FileResource;
import eu.eventstorm.batch.rest.UploadResponse;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import org.reactivestreams.Publisher;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@ConditionalOnProperty(prefix="eu.eventstorm.batch", name={"type"}, havingValue="MEMORY")
@RestController
public final class FileResourceReactiveController {
    private final FileResource fileResource;

    public FileResourceReactiveController(FileResource fileResource) {
        this.fileResource = fileResource;
    }

    @PostMapping(path={"${eu.eventstorm.batch.resource.context-path:}/upload"})
    public Mono<UploadResponse> upload(ServerHttpRequest serverRequest) throws IOException {
        UUID uuid = UUID.randomUUID();
        FileChannel channel = FileChannel.open(this.fileResource.touch(uuid.toString()), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        return DataBufferUtils.write((Publisher)serverRequest.getBody(), (WritableByteChannel)channel).map(DataBufferUtils::release).reduce((l, r) -> l != false && r != false).doOnNext(t -> {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).map(result -> new UploadResponse(uuid.toString()));
    }

    @GetMapping(path={"${eu.eventstorm.batch.resource.context-path:}/download/{uuid}"})
    public Mono<Void> download(@PathVariable(value="uuid") String uuid, ServerHttpResponse response) throws IOException {
        if (response instanceof ZeroCopyHttpOutputMessage) {
            ZeroCopyHttpOutputMessage zeroCopyResponse = (ZeroCopyHttpOutputMessage)response;
            Path file = this.fileResource.get(uuid);
            return zeroCopyResponse.writeWith(file, 0L, Files.size(file));
        }
        return null;
    }
}

