/*
 * Decompiled with CFR 0.152.
 */
package eu.fraho.spring.securityJwt.dto;

import eu.fraho.spring.securityJwt.dto.ZonedDateTimeConverter;
import java.time.ZonedDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="jwt_refresh", uniqueConstraints={@UniqueConstraint(columnNames={"username", "deviceId"})})
public class RefreshTokenEntity {
    @Id
    @GeneratedValue
    private Long id = 0L;
    @NotNull
    @Column(updatable=false)
    @Convert(converter=ZonedDateTimeConverter.class)
    private ZonedDateTime created = ZonedDateTime.now();
    @NotNull
    private String username;
    @NotNull
    private String deviceId;
    @NotNull
    private String token;

    public RefreshTokenEntity(String username, String deviceId, String token) {
        this.username = username;
        this.deviceId = deviceId;
        this.token = token;
    }

    public Long getId() {
        return this.id;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getToken() {
        return this.token;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefreshTokenEntity)) {
            return false;
        }
        RefreshTokenEntity other = (RefreshTokenEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RefreshTokenEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "RefreshTokenEntity(id=" + this.getId() + ", username=" + this.getUsername() + ", deviceId=" + this.getDeviceId() + ")";
    }

    public RefreshTokenEntity() {
    }
}

