/*
 * Decompiled with CFR 0.152.
 */
package eu.fraho.spring.securityJwt.dto;

import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Optional;
import javax.persistence.AttributeConverter;

public class ZonedDateTimeConverter
implements AttributeConverter<ZonedDateTime, Timestamp> {
    public Timestamp convertToDatabaseColumn(ZonedDateTime zdt) {
        return Optional.ofNullable(zdt).map(ChronoZonedDateTime::toInstant).map(Timestamp::from).orElse(null);
    }

    public ZonedDateTime convertToEntityAttribute(Timestamp ts) {
        return Optional.ofNullable(ts).map(Timestamp::toInstant).map(v -> ZonedDateTime.ofInstant(v, ZoneOffset.UTC)).orElse(null);
    }
}

