/*
 * Decompiled with CFR 0.152.
 */
package eu.fraho.spring.securityJwt.service;

import eu.fraho.spring.securityJwt.config.JwtRefreshConfiguration;
import eu.fraho.spring.securityJwt.dto.RefreshToken;
import eu.fraho.spring.securityJwt.dto.RefreshTokenEntity;
import eu.fraho.spring.securityJwt.dto.TimeWithPeriod;
import eu.fraho.spring.securityJwt.service.RefreshTokenStore;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class HibernateTokenStore
implements RefreshTokenStore {
    private static final Logger log = LoggerFactory.getLogger(HibernateTokenStore.class);
    @NonNull
    private final JwtRefreshConfiguration refreshConfig;
    @PersistenceContext
    private EntityManager em = null;

    @Transactional
    public void saveToken(@NotNull String username, @NotNull String deviceId, @NotNull String token) {
        this.revokeToken(username, deviceId);
        RefreshTokenEntity entity = new RefreshTokenEntity(username, deviceId, token);
        this.exceptionWrapper("Could not persist refresh token", () -> {
            this.em.persist((Object)entity);
            return entity;
        });
    }

    @Transactional
    public boolean useToken(@NotNull String username, @NotNull String deviceId, @NotNull String token) {
        Query query = this.em.createQuery("DELETE FROM RefreshTokenEntity o WHERE o.username = :username AND o.deviceId = :deviceId AND o.token = :token AND o.created >= :expiration");
        query.setParameter("username", (Object)username);
        query.setParameter("deviceId", (Object)deviceId);
        query.setParameter("token", (Object)token);
        this.setExpiration(query);
        return (Integer)this.exceptionWrapper("Could not use refresh token", () -> ((Query)query).executeUpdate()) != 0;
    }

    @Transactional(readOnly=true)
    @NotNull
    public List<RefreshToken> listTokens(@NotNull String username) {
        TypedQuery query = this.em.createQuery("SELECT o FROM RefreshTokenEntity o WHERE o.username = :username AND o.created >= :expiration", RefreshTokenEntity.class);
        query.setParameter("username", (Object)username);
        this.setExpiration((Query)query);
        List result = (List)this.exceptionWrapper("Could not list refresh token", () -> ((TypedQuery)query).getResultList());
        return result.stream().map(e -> new RefreshToken(e.getToken(), this.calculateExpiration(e.getCreated()), e.getDeviceId())).collect(Collectors.toList());
    }

    private int calculateExpiration(@NotNull ZonedDateTime created) {
        return (int)ChronoUnit.SECONDS.between(created, ZonedDateTime.now());
    }

    private void setExpiration(@NotNull Query query) {
        ZonedDateTime expiration = ZonedDateTime.now().minusSeconds(this.refreshConfig.getExpiration().toSeconds());
        query.setParameter("expiration", (Object)expiration);
    }

    @Transactional(readOnly=true)
    @NotNull
    public Map<String, List<RefreshToken>> listTokens() {
        TypedQuery query = this.em.createQuery("SELECT o FROM RefreshTokenEntity o WHERE o.created >= :expiration", RefreshTokenEntity.class);
        this.setExpiration((Query)query);
        List tokens = (List)this.exceptionWrapper("Could not list refresh token", () -> ((TypedQuery)query).getResultList());
        HashMap<String, List> result = new HashMap<String, List>();
        tokens.forEach(e -> result.computeIfAbsent(e.getUsername(), s -> new ArrayList()).add(new RefreshToken(e.getToken(), this.calculateExpiration(e.getCreated()), e.getDeviceId())));
        result.replaceAll((s, t) -> Collections.unmodifiableList(t));
        return Collections.unmodifiableMap(result);
    }

    @Transactional
    public boolean revokeToken(@NotNull String username, @NotNull RefreshToken token) {
        return this.revokeToken(username, token.getDeviceId());
    }

    @Transactional
    public boolean revokeToken(@NotNull String username, @NotNull String deviceId) {
        Query query = this.em.createQuery("DELETE FROM RefreshTokenEntity o WHERE o.username = :username AND o.deviceId = :deviceId");
        query.setParameter("username", (Object)username);
        query.setParameter("deviceId", (Object)deviceId);
        return (Integer)this.exceptionWrapper("Could not revoke refresh token", () -> ((Query)query).executeUpdate()) != 0;
    }

    @Transactional
    public int revokeTokens(@NotNull String username) {
        Query query = this.em.createQuery("DELETE FROM RefreshTokenEntity o WHERE o.username = :username");
        query.setParameter("username", (Object)username);
        return (Integer)this.exceptionWrapper("Could not revoke refresh tokens", () -> ((Query)query).executeUpdate());
    }

    @Transactional
    public int revokeTokens() {
        Query query = this.em.createQuery("DELETE FROM RefreshTokenEntity o");
        return (Integer)this.exceptionWrapper("Could not revoke refresh tokens", () -> ((Query)query).executeUpdate());
    }

    public void afterPropertiesSet() {
        log.info("Using hibernate implementation to handle refresh tokens");
    }

    @Deprecated
    @NotNull
    public TimeWithPeriod getRefreshExpiration() {
        return this.refreshConfig.getExpiration();
    }

    @ConstructorProperties(value={"refreshConfig"})
    @Autowired
    public HibernateTokenStore(@NonNull JwtRefreshConfiguration refreshConfig) {
        if (refreshConfig == null) {
            throw new NullPointerException("refreshConfig");
        }
        this.refreshConfig = refreshConfig;
    }
}

