/*
 * Decompiled with CFR 0.152.
 */
package eu.fraho.spring.securityJwt.hibernate.service;

import eu.fraho.spring.securityJwt.base.config.RefreshProperties;
import eu.fraho.spring.securityJwt.base.dto.JwtUser;
import eu.fraho.spring.securityJwt.base.dto.RefreshToken;
import eu.fraho.spring.securityJwt.base.service.RefreshTokenStore;
import eu.fraho.spring.securityJwt.hibernate.dto.RefreshTokenEntity;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.transaction.annotation.Transactional;

public class HibernateTokenStore
implements RefreshTokenStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HibernateTokenStore.class);
    private RefreshProperties refreshProperties;
    private UserDetailsService userDetailsService;
    private EntityManager entityManager;

    @Transactional
    public <T extends JwtUser> Optional<T> useToken(String token) {
        ZonedDateTime expiration = ZonedDateTime.now().minusSeconds(this.refreshProperties.getExpiration().toSeconds());
        TypedQuery queryLoad = this.entityManager.createQuery("SELECT o FROM RefreshTokenEntity o WHERE o.token = :token AND o.created >= :expiration", RefreshTokenEntity.class);
        queryLoad.setParameter("token", (Object)token);
        queryLoad.setParameter("expiration", (Object)expiration);
        List loadResultList = queryLoad.getResultList();
        if (loadResultList.size() != 1) {
            return Optional.empty();
        }
        RefreshTokenEntity refreshToken = (RefreshTokenEntity)loadResultList.get(0);
        Optional<Object> resultUser = Optional.ofNullable((JwtUser)this.userDetailsService.loadUserByUsername(refreshToken.getUsername()));
        if (resultUser.isPresent()) {
            Query query = this.entityManager.createQuery("DELETE FROM RefreshTokenEntity o WHERE o.id = :id");
            query.setParameter("id", (Object)refreshToken.getId());
            if (query.executeUpdate() == 0) {
                resultUser = Optional.empty();
            }
        }
        return resultUser;
    }

    @Transactional(readOnly=true)
    public List<RefreshToken> listTokens(JwtUser user) {
        ZonedDateTime expiration = ZonedDateTime.now().minusSeconds(this.refreshProperties.getExpiration().toSeconds());
        TypedQuery query = this.entityManager.createQuery("SELECT o FROM RefreshTokenEntity o WHERE o.userId = :userId AND o.created >= :expiration", RefreshTokenEntity.class);
        query.setParameter("userId", (Object)user.getId());
        query.setParameter("expiration", (Object)expiration);
        List result = query.getResultList();
        return result.stream().map(e -> RefreshToken.builder().token(e.getToken()).expiresIn((long)this.calculateExpiration(e.getCreated())).build()).collect(Collectors.toList());
    }

    @Transactional
    public void saveToken(JwtUser user, String token) {
        this.entityManager.persist((Object)RefreshTokenEntity.builder().userId(user.getId()).username(user.getUsername()).token(token).build());
    }

    @Transactional(readOnly=true)
    public Map<Long, List<RefreshToken>> listTokens() {
        TypedQuery query = this.entityManager.createQuery("SELECT o FROM RefreshTokenEntity o WHERE o.created >= :expiration", RefreshTokenEntity.class);
        ZonedDateTime expiration = ZonedDateTime.now().minusSeconds(this.refreshProperties.getExpiration().toSeconds());
        query.setParameter("expiration", (Object)expiration);
        List tokens = query.getResultList();
        HashMap<Long, List> result = new HashMap<Long, List>();
        tokens.forEach(e -> result.computeIfAbsent(e.getUserId(), s -> new ArrayList()).add(RefreshToken.builder().token(e.getToken()).expiresIn((long)this.calculateExpiration(e.getCreated())).build()));
        result.replaceAll((s, t) -> Collections.unmodifiableList(t));
        return Collections.unmodifiableMap(result);
    }

    @Transactional
    public boolean revokeToken(String token) {
        Query query = this.entityManager.createQuery("DELETE FROM RefreshTokenEntity o WHERE o.token = :token ");
        query.setParameter("token", (Object)token);
        return query.executeUpdate() != 0;
    }

    @Transactional
    public int revokeTokens(JwtUser user) {
        Query query = this.entityManager.createQuery("DELETE FROM RefreshTokenEntity o WHERE o.userId = :userId");
        query.setParameter("userId", (Object)user.getId());
        return query.executeUpdate();
    }

    @Transactional
    public int revokeTokens() {
        Query query = this.entityManager.createQuery("DELETE FROM RefreshTokenEntity o");
        return query.executeUpdate();
    }

    @Autowired
    public void setRefreshProperties(@NonNull RefreshProperties refreshProperties) {
        if (refreshProperties == null) {
            throw new NullPointerException("refreshProperties is marked non-null but is null");
        }
        this.refreshProperties = refreshProperties;
    }

    @Autowired
    public void setUserDetailsService(@NonNull UserDetailsService userDetailsService) {
        if (userDetailsService == null) {
            throw new NullPointerException("userDetailsService is marked non-null but is null");
        }
        this.userDetailsService = userDetailsService;
    }

    @PersistenceContext
    public void setEntityManager(@NonNull EntityManager entityManager) {
        if (entityManager == null) {
            throw new NullPointerException("entityManager is marked non-null but is null");
        }
        this.entityManager = entityManager;
    }

    public void afterPropertiesSet() {
        log.info("Using hibernate implementation to handle refresh tokens");
    }

    protected int calculateExpiration(ZonedDateTime created) {
        return (int)ChronoUnit.SECONDS.between(created, ZonedDateTime.now());
    }

    @Generated
    public HibernateTokenStore() {
    }

    @Generated
    public HibernateTokenStore(RefreshProperties refreshProperties, UserDetailsService userDetailsService, EntityManager entityManager) {
        this.refreshProperties = refreshProperties;
        this.userDetailsService = userDetailsService;
        this.entityManager = entityManager;
    }
}

