/*
 * Decompiled with CFR 0.152.
 */
package eu.fraho.spring.securityJwt.hibernate.dto;

import eu.fraho.spring.securityJwt.hibernate.dto.ZonedDateTimeConverter;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.ZonedDateTime;

@Entity
@Table(name="jwt_refresh")
public class RefreshTokenEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id = 0L;
    @Column(updatable=false)
    @Convert(converter=ZonedDateTimeConverter.class)
    private ZonedDateTime created = ZonedDateTime.now();
    private Long userId;
    private String username;
    @Column(unique=true)
    private String token;

    private RefreshTokenEntity(Long userId, String username, String token) {
        this.userId = userId;
        this.username = username;
        this.token = token;
    }

    public static RefreshTokenEntityBuilder builder() {
        return new RefreshTokenEntityBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefreshTokenEntity)) {
            return false;
        }
        RefreshTokenEntity other = (RefreshTokenEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RefreshTokenEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "RefreshTokenEntity(id=" + this.getId() + ", userId=" + this.getUserId() + ", username=" + this.getUsername() + ", token=" + this.getToken() + ")";
    }

    public RefreshTokenEntity() {
    }

    public static class RefreshTokenEntityBuilder {
        private Long userId;
        private String username;
        private String token;

        RefreshTokenEntityBuilder() {
        }

        public RefreshTokenEntityBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public RefreshTokenEntityBuilder username(String username) {
            this.username = username;
            return this;
        }

        public RefreshTokenEntityBuilder token(String token) {
            this.token = token;
            return this;
        }

        public RefreshTokenEntity build() {
            return new RefreshTokenEntity(this.userId, this.username, this.token);
        }

        public String toString() {
            return "RefreshTokenEntity.RefreshTokenEntityBuilder(userId=" + this.userId + ", username=" + this.username + ", token=" + this.token + ")";
        }
    }
}

