/*
 * Decompiled with CFR 0.152.
 */
package eu.fraho.spring.securityJwt.service;

import eu.fraho.spring.securityJwt.dto.RefreshToken;
import eu.fraho.spring.securityJwt.dto.TimeWithPeriod;
import eu.fraho.spring.securityJwt.service.RefreshTokenStore;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class InternalTokenStore
implements RefreshTokenStore {
    private static final Logger log = LoggerFactory.getLogger(InternalTokenStore.class);
    @Value(value="${fraho.jwt.refresh.expiration:1 day}")
    private TimeWithPeriod refreshExpiration = new TimeWithPeriod("1 day");
    @Value(value="${fraho.jwt.refresh.cache.prefix:fraho-refresh}")
    private String refreshCachePrefix = "fraho-refresh";
    private ExpiringMap<String, String> refreshTokenMap = null;

    public void saveToken(String username, String deviceId, String token) {
        String key = String.format("%s:%s:%s", this.refreshCachePrefix, username, deviceId);
        this.refreshTokenMap.put((Object)key, (Object)token);
    }

    public boolean useToken(String username, String deviceId, String token) {
        byte[] toCheck;
        String key = String.format("%s:%s:%s", this.refreshCachePrefix, username, deviceId);
        byte[] stored = ((String)this.refreshTokenMap.getOrDefault((Object)key, (Object)String.format("%64s", "0"))).getBytes(StandardCharsets.UTF_8);
        return this.tokenEquals(stored, toCheck = token.getBytes(StandardCharsets.UTF_8)) && this.refreshTokenMap.remove((Object)key) != null;
    }

    public List<RefreshToken> listTokens(String username) {
        String filter = String.format("^%s:%s:[^:]+$", Pattern.quote(this.refreshCachePrefix), Pattern.quote(username));
        return this.listRefreshTokensByPrefix(filter).getOrDefault(username, Collections.emptyList());
    }

    public Map<String, List<RefreshToken>> listTokens() {
        String filter = String.format("^%s:[^:]+:[^:]+$", Pattern.quote(this.refreshCachePrefix));
        return this.listRefreshTokensByPrefix(filter);
    }

    private Map<String, List<RefreshToken>> listRefreshTokensByPrefix(String filter) {
        HashMap<String, List> result = new HashMap<String, List>();
        for (Map.Entry entry : this.refreshTokenMap.entrySet()) {
            if (!((String)entry.getKey()).matches(filter)) continue;
            String[] parts = ((String)entry.getKey()).split(":", 3);
            String username = parts[1];
            String deviceId = parts[2];
            String token = (String)entry.getValue();
            int expiresIn = (int)this.refreshTokenMap.getExpiration(entry.getKey());
            result.computeIfAbsent(username, s -> new ArrayList()).add(new RefreshToken(token, expiresIn, deviceId));
        }
        result.replaceAll((s, t) -> Collections.unmodifiableList(t));
        return Collections.unmodifiableMap(result);
    }

    public boolean revokeToken(String username, RefreshToken token) {
        return this.revokeTokens(Optional.of(username), Optional.of(token.getDeviceId())) != 0;
    }

    private int revokeTokens(Optional<String> username, Optional<String> deviceId) {
        if (!username.isPresent() && !deviceId.isPresent()) {
            int count = this.refreshTokenMap.size();
            this.refreshTokenMap.clear();
            return count;
        }
        String filter = String.format("%s:%s:%s", this.refreshCachePrefix, username.map(Pattern::quote).orElse("[^:]+"), deviceId.map(Pattern::quote).orElse("[^:]+"));
        int count = 0;
        Iterator iterator = this.refreshTokenMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!((String)entry.getKey()).matches(filter)) continue;
            iterator.remove();
            ++count;
        }
        return count;
    }

    public int revokeTokens(String username) {
        return this.revokeTokens(Optional.of(username), Optional.empty());
    }

    public boolean revokeToken(String username, String deviceId) {
        return this.revokeTokens(Optional.of(username), Optional.of(deviceId)) != 0;
    }

    public int revokeTokens() {
        return this.revokeTokens(Optional.empty(), Optional.empty());
    }

    public void afterPropertiesSet() throws Exception {
        log.debug("Creating in-memory expiring map");
        this.refreshTokenMap = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).expiration((long)this.refreshExpiration.getQuantity(), this.refreshExpiration.getTimeUnit()).build();
    }

    public TimeWithPeriod getRefreshExpiration() {
        return this.refreshExpiration;
    }

    public String getRefreshCachePrefix() {
        return this.refreshCachePrefix;
    }

    public ExpiringMap<String, String> getRefreshTokenMap() {
        return this.refreshTokenMap;
    }
}

