/*
 * Decompiled with CFR 0.152.
 */
package eu.fraho.spring.securityJwt.internal.service;

import eu.fraho.spring.securityJwt.base.config.RefreshProperties;
import eu.fraho.spring.securityJwt.base.dto.AbstractToken;
import eu.fraho.spring.securityJwt.base.dto.JwtUser;
import eu.fraho.spring.securityJwt.base.dto.RefreshToken;
import eu.fraho.spring.securityJwt.base.service.RefreshTokenStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetailsService;

public class InternalTokenStore
implements RefreshTokenStore {
    private static final Logger log = LoggerFactory.getLogger(InternalTokenStore.class);
    private RefreshProperties refreshProperties;
    private UserDetailsService userDetailsService;
    private ExpiringMap<String, JwtUser> refreshTokenMap;

    public synchronized void saveToken(JwtUser user, String token) {
        this.refreshTokenMap.put((Object)token, (Object)user);
    }

    public synchronized <T extends JwtUser> Optional<T> useToken(String token) {
        return Optional.ofNullable((JwtUser)this.refreshTokenMap.remove((Object)token)).map(JwtUser::getUsername).map(arg_0 -> ((UserDetailsService)this.userDetailsService).loadUserByUsername(arg_0)).map(e -> (JwtUser)e);
    }

    public synchronized List<RefreshToken> listTokens(JwtUser user) {
        return this.listTokens().getOrDefault(user.getId(), Collections.emptyList());
    }

    public synchronized Map<Long, List<RefreshToken>> listTokens() {
        HashMap<Long, List> result = new HashMap<Long, List>();
        for (Map.Entry entry : this.refreshTokenMap.entrySet()) {
            String token = (String)entry.getKey();
            int expiresIn = (int)this.refreshTokenMap.getExpiration((Object)((String)entry.getKey()));
            result.computeIfAbsent(((JwtUser)entry.getValue()).getId(), s -> new ArrayList()).add(RefreshToken.builder().token(token).expiresIn((long)expiresIn).build());
        }
        result.replaceAll((s, t) -> Collections.unmodifiableList(t));
        return Collections.unmodifiableMap(result);
    }

    public synchronized boolean revokeToken(String token) {
        return this.refreshTokenMap.remove((Object)token) != null;
    }

    public synchronized int revokeTokens(JwtUser user) {
        return (int)this.listTokens(user).stream().map(AbstractToken::getToken).map(arg_0 -> this.refreshTokenMap.remove(arg_0)).filter(Objects::nonNull).count();
    }

    public synchronized int revokeTokens() {
        int size = this.refreshTokenMap.size();
        this.refreshTokenMap.clear();
        return size;
    }

    public void afterPropertiesSet() {
        log.info("Using in-memory implementation to handle refresh tokens");
        this.refreshTokenMap = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).expiration((long)this.refreshProperties.getExpiration().getQuantity(), this.refreshProperties.getExpiration().getTimeUnit()).build();
    }

    @Autowired
    public void setRefreshProperties(@NonNull RefreshProperties refreshProperties) {
        if (refreshProperties == null) {
            throw new NullPointerException("refreshProperties is marked non-null but is null");
        }
        this.refreshProperties = refreshProperties;
    }

    @Autowired
    public void setUserDetailsService(@NonNull UserDetailsService userDetailsService) {
        if (userDetailsService == null) {
            throw new NullPointerException("userDetailsService is marked non-null but is null");
        }
        this.userDetailsService = userDetailsService;
    }

    protected ExpiringMap<String, JwtUser> getRefreshTokenMap() {
        return this.refreshTokenMap;
    }

    protected void setRefreshTokenMap(ExpiringMap<String, JwtUser> refreshTokenMap) {
        this.refreshTokenMap = refreshTokenMap;
    }
}

