/*
 * Copyright (c) 2017 by Gerrit Grunwald
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package eu.hansolo.tilesfx.chart;

/**
 * Created by hansolo on 24.03.17.
 */
public enum MatrixFont8x11 implements MatrixFont {
    INSTANCE;

    public static final int[][] ASCII_32_126 = {
        {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00000000,
            0b00100000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00101000,
            0b00101000,
            0b00101000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00101000,
            0b00101000,
            0b11111100,
            0b00101000,
            0b11111100,
            0b01010000,
            0b01010000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00010000,
            0b00111000,
            0b01010000,
            0b01010000,
            0b00111000,
            0b00010100,
            0b00100100,
            0b01111000,
            0b00100000,
            0b00000000,
            }, {
            0b00000000,
            0b11100100,
            0b10101000,
            0b11110000,
            0b00010000,
            0b00100000,
            0b01011100,
            0b01010100,
            0b10011100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b01110000,
            0b01010000,
            0b01010000,
            0b01100000,
            0b11101000,
            0b10011000,
            0b10001000,
            0b01111100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00001000,
            0b00010000,
            0b00010000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00010000,
            0b00010000,
            0b00001000,
            }, {
            0b00000000,
            0b01000000,
            0b00100000,
            0b00100000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00100000,
            0b00100000,
            0b01000000,
            }, {
            0b00000000,
            0b00010000,
            0b01010100,
            0b00111000,
            0b01010100,
            0b00010000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00010000,
            0b00010000,
            0b01111100,
            0b00010000,
            0b00010000,
            0b00000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b01100000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b01110000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00110000,
            0b00110000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000100,
            0b00001000,
            0b00001000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00100000,
            0b00100000,
            0b01000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01110000,
            0b10001000,
            0b10011000,
            0b10101000,
            0b11001000,
            0b10001000,
            0b01110000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00110000,
            0b01010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b01111100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00111000,
            0b01000100,
            0b00000100,
            0b00001000,
            0b00010000,
            0b00100000,
            0b01111100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01110000,
            0b00001000,
            0b00001000,
            0b00110000,
            0b00001000,
            0b00001000,
            0b01110000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00011000,
            0b00101000,
            0b01001000,
            0b10001000,
            0b11111100,
            0b00001000,
            0b00001000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b01000000,
            0b01000000,
            0b01110000,
            0b00001000,
            0b00001000,
            0b01110000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00111000,
            0b01100000,
            0b01000000,
            0b01111000,
            0b01000100,
            0b01000100,
            0b00111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111100,
            0b00000100,
            0b00001000,
            0b00001000,
            0b00010000,
            0b00010000,
            0b00100000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00111000,
            0b01000100,
            0b01100100,
            0b00111000,
            0b01001100,
            0b01000100,
            0b00111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00111000,
            0b01000100,
            0b01000100,
            0b00111100,
            0b00000100,
            0b00001000,
            0b01110000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00110000,
            0b00110000,
            0b00000000,
            0b00000000,
            0b00110000,
            0b00110000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00110000,
            0b00110000,
            0b00000000,
            0b00000000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b01100000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00001000,
            0b00010000,
            0b00100000,
            0b00100000,
            0b00010000,
            0b00001000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b01111100,
            0b00000000,
            0b01111100,
            0b00000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b01000000,
            0b00100000,
            0b00010000,
            0b00010000,
            0b00100000,
            0b01000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00110000,
            0b00011000,
            0b00001000,
            0b00001000,
            0b00110000,
            0b00100000,
            0b00000000,
            0b00100000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00111000,
            0b01001100,
            0b01000100,
            0b10010100,
            0b10110100,
            0b10110100,
            0b10111000,
            0b10000000,
            0b01000000,
            0b01111000,
            }, {
            0b00000000,
            0b00000000,
            0b00010000,
            0b00101000,
            0b00101000,
            0b00101000,
            0b01111100,
            0b01000100,
            0b01000100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b01000100,
            0b01000100,
            0b01111000,
            0b01000100,
            0b01000100,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00111000,
            0b01100000,
            0b01000000,
            0b01000000,
            0b01000000,
            0b01100000,
            0b00111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b01001100,
            0b01000100,
            0b01000100,
            0b01000100,
            0b01001100,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b01000000,
            0b01000000,
            0b01111000,
            0b01000000,
            0b01000000,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b01000000,
            0b01000000,
            0b01111000,
            0b01000000,
            0b01000000,
            0b01000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b01000000,
            0b10000000,
            0b10011000,
            0b10001000,
            0b11001000,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b01111000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111100,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b01111100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b00001000,
            0b00001000,
            0b00001000,
            0b00001000,
            0b00001000,
            0b01110000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01001000,
            0b01010000,
            0b01010000,
            0b01100000,
            0b01010000,
            0b01010000,
            0b01001000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01000000,
            0b01000000,
            0b01000000,
            0b01000000,
            0b01000000,
            0b01000000,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01001000,
            0b01001000,
            0b10110100,
            0b10110100,
            0b10000100,
            0b10000100,
            0b10000100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01001000,
            0b01101000,
            0b01101000,
            0b01101000,
            0b01011000,
            0b01011000,
            0b01001000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b11001100,
            0b10000100,
            0b10000100,
            0b10000100,
            0b11001100,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b01000100,
            0b01000100,
            0b01111000,
            0b01000000,
            0b01000000,
            0b01000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01110000,
            0b11001000,
            0b10001000,
            0b10001000,
            0b10001000,
            0b10011000,
            0b01110000,
            0b00100000,
            0b00011000,
            }, {
            0b00000000,
            0b00000000,
            0b01110000,
            0b01001000,
            0b01001000,
            0b01110000,
            0b01010000,
            0b01001000,
            0b01000100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00111100,
            0b01000000,
            0b01000000,
            0b00111000,
            0b00000100,
            0b00000100,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111100,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01000100,
            0b01000100,
            0b01000100,
            0b01000100,
            0b01000100,
            0b01000100,
            0b00111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01000100,
            0b01000100,
            0b01000100,
            0b00101000,
            0b00101000,
            0b00101000,
            0b00010000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b10000100,
            0b10000100,
            0b10000100,
            0b10110100,
            0b01111000,
            0b01011000,
            0b01001000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b10000100,
            0b01001000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b01001000,
            0b11001100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b10000010,
            0b01000100,
            0b00101000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b01111100,
            0b00001000,
            0b00001000,
            0b00010000,
            0b00100000,
            0b00100000,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00111000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00111000,
            }, {
            0b00000000,
            0b01000000,
            0b00100000,
            0b00100000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00001000,
            0b00001000,
            0b00000100,
            0b00000000,
            }, {
            0b00000000,
            0b01110000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b01110000,
            }, {
            0b00000000,
            0b00000000,
            0b00100000,
            0b01010000,
            0b01010000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b11111100,
            }, {
            0b01100000,
            0b00110000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00111000,
            0b00000100,
            0b00111100,
            0b01000100,
            0b01001100,
            0b00111100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b01000000,
            0b01000000,
            0b01111000,
            0b01100100,
            0b01000100,
            0b01000100,
            0b01000100,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00111000,
            0b01100000,
            0b01000000,
            0b01000000,
            0b01000000,
            0b00111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000100,
            0b00000100,
            0b00111100,
            0b01000100,
            0b01000100,
            0b01000100,
            0b01001100,
            0b00110100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00111000,
            0b01000100,
            0b01111100,
            0b01000000,
            0b01100000,
            0b00111100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00011100,
            0b00100000,
            0b00100000,
            0b11111000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00111110,
            0b01000100,
            0b01000100,
            0b01111000,
            0b01000000,
            0b01111100,
            0b01000100,
            0b01111000,
            }, {
            0b00000000,
            0b01000000,
            0b01000000,
            0b01111000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00011000,
            0b00000000,
            0b01110000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00011000,
            0b00000000,
            0b01111000,
            0b00001000,
            0b00001000,
            0b00001000,
            0b00001000,
            0b00001000,
            0b00001000,
            0b01110000,
            }, {
            0b00000000,
            0b01000000,
            0b01000000,
            0b01001000,
            0b01010000,
            0b01100000,
            0b01100000,
            0b01010000,
            0b01001000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b01110000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b01111100,
            0b01010100,
            0b01010100,
            0b01010100,
            0b01010100,
            0b01010100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b01111000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00111000,
            0b01000100,
            0b01000100,
            0b01000100,
            0b01000100,
            0b00111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b01111000,
            0b01100100,
            0b01000100,
            0b01000100,
            0b01000100,
            0b01111000,
            0b01000000,
            0b01000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00111100,
            0b01000100,
            0b01000100,
            0b01000100,
            0b01001100,
            0b00110100,
            0b00000100,
            0b00000100,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b01111000,
            0b01001000,
            0b01000000,
            0b01000000,
            0b01000000,
            0b01000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00111000,
            0b01000000,
            0b01100000,
            0b00011000,
            0b00001000,
            0b01110000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00100000,
            0b00100000,
            0b11111000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b01001000,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b01000100,
            0b01000100,
            0b01000100,
            0b00101000,
            0b00101000,
            0b00010000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b10000100,
            0b10101000,
            0b10101000,
            0b10111000,
            0b11011000,
            0b01001000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b11001100,
            0b01001000,
            0b00110000,
            0b00110000,
            0b01001000,
            0b11001100,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b01000100,
            0b01000100,
            0b01001000,
            0b00101000,
            0b00110000,
            0b00010000,
            0b00100000,
            0b11100000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b01111000,
            0b00010000,
            0b00010000,
            0b00100000,
            0b00100000,
            0b01111000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00110000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b11000000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00100000,
            0b00110000,
            }, {
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            }, {
            0b00000000,
            0b00110000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00001100,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00010000,
            0b00110000,
            }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b11101000,
            0b10111000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            }, {
            0b00000000,
            0b00110000,
            0b01001000,
            0b01001000,
            0b00110000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            }};

    @Override public int getCharacterWidth() { return 8; }
    @Override public int getCharacterHeight() { return 11; }

    @Override public int[] getCharacter(final char CHAR) {
        int ascii = (int) CHAR;
        if (ascii < 32 || ascii > 126) { return ASCII_32_126[0]; }
        return ASCII_32_126[ascii - 32];
    }
}
