/*
 * Copyright (c) 2017 by Gerrit Grunwald
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package eu.hansolo.tilesfx.chart;

/**
 * Created by hansolo on 19.03.17.
 */
public enum MatrixFont8x8 implements MatrixFont {
    INSTANCE;

    public static final int[][] ASCII_32_126 = {
        {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000
        }, {
            0b00011000,
            0b00111100,
            0b00111100,
            0b00011000,
            0b00011000,
            0b00000000,
            0b00011000,
            0b00000000
        }, {
            0b01101100,
            0b01101100,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000
        }, {
            0b01101100,
            0b01101100,
            0b11111110,
            0b01101100,
            0b11111110,
            0b01101100,
            0b01101100,
            0b00000000
        }, {
            0b00110000,
            0b01111100,
            0b11000000,
            0b01111000,
            0b00001100,
            0b11111000,
            0b00110000,
            0b00000000
        }, {
            0b00000000,
            0b11000110,
            0b11001100,
            0b00011000,
            0b00110000,
            0b01100110,
            0b11000110,
            0b00000000
        }, {
            0b00111000,
            0b01101100,
            0b00111000,
            0b01110110,
            0b11011100,
            0b11001100,
            0b01110110,
            0b00000000
        }, {
            0b01100000,
            0b01100000,
            0b11000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000
        }, {
            0b00011000,
            0b00110000,
            0b01100000,
            0b01100000,
            0b01100000,
            0b00110000,
            0b00011000,
            0b00000000
        }, {
            0b01100000,
            0b00110000,
            0b00011000,
            0b00011000,
            0b00011000,
            0b00110000,
            0b01100000,
            0b00000000
        }, {
            0b00000000,
            0b01100110,
            0b00111100,
            0b11111111,
            0b00111100,
            0b01100110,
            0b00000000,
            0b00000000
        }, {
            0b00000000,
            0b00110000,
            0b00110000,
            0b11111100,
            0b00110000,
            0b00110000,
            0b00000000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00110000,
            0b00110000,
            0b01100000
        }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b11111100,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00110000,
            0b00110000,
            0b00000000
        }, {
            0b00000110,
            0b00001100,
            0b00011000,
            0b00110000,
            0b01100000,
            0b11000000,
            0b10000000,
            0b00000000
        }, {
            0b01111100,
            0b11000110,
            0b11001110,
            0b11011110,
            0b11110110,
            0b11100110,
            0b01111100,
            0b00000000
        }, {
            0b00110000,
            0b01110000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b11111100,
            0b00000000
        }, {
            0b01111000,
            0b11001100,
            0b00001100,
            0b00111000,
            0b01100000,
            0b11001100,
            0b11111100,
            0b00000000
        }, {
            0b01111000,
            0b11001100,
            0b00001100,
            0b00111000,
            0b00001100,
            0b11001100,
            0b01111000,
            0b00000000
        }, {
            0b00011100,
            0b00111100,
            0b01101100,
            0b11001100,
            0b11111110,
            0b00001100,
            0b00011110,
            0b00000000
        }, {
            0b11111100,
            0b11000000,
            0b11111000,
            0b00001100,
            0b00001100,
            0b11001100,
            0b01111000,
            0b00000000
        }, {
            0b00111000,
            0b01100000,
            0b11000000,
            0b11111000,
            0b11001100,
            0b11001100,
            0b01111000,
            0b00000000
        }, {
            0b11111100,
            0b11001100,
            0b00001100,
            0b00011000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b00000000
        }, {
            0b01111000,
            0b11001100,
            0b11001100,
            0b01111000,
            0b11001100,
            0b11001100,
            0b01111000,
            0b00000000
        }, {
            0b01111000,
            0b11001100,
            0b11001100,
            0b01111100,
            0b00001100,
            0b00011000,
            0b01110000,
            0b00000000
        }, {
            0b00000000,
            0b00110000,
            0b00110000,
            0b00000000,
            0b00000000,
            0b00110000,
            0b00110000,
            0b00000000
        }, {
            0b00000000,
            0b00110000,
            0b00110000,
            0b00000000,
            0b00000000,
            0b00110000,
            0b00110000,
            0b01100000
        }, {
            0b00011000,
            0b00110000,
            0b01100000,
            0b11000000,
            0b01100000,
            0b00110000,
            0b00011000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b11111100,
            0b00000000,
            0b00000000,
            0b11111100,
            0b00000000,
            0b00000000
        }, {
            0b01100000,
            0b00110000,
            0b00011000,
            0b00001100,
            0b00011000,
            0b00110000,
            0b01100000,
            0b00000000
        }, {
            0b01111000,
            0b11001100,
            0b00001100,
            0b00011000,
            0b00110000,
            0b00000000,
            0b00110000,
            0b00000000
        }, {
            0b01111100,
            0b11000110,
            0b11011110,
            0b11011110,
            0b11011110,
            0b11000000,
            0b01111000,
            0b00000000
        }, {
            0b00110000,
            0b01111000,
            0b11001100,
            0b11001100,
            0b11111100,
            0b11001100,
            0b11001100,
            0b00000000
        }, {
            0b11111100,
            0b01100110,
            0b01100110,
            0b01111100,
            0b01100110,
            0b01100110,
            0b11111100,
            0b00000000
        }, {
            0b00111100,
            0b01100110,
            0b11000000,
            0b11000000,
            0b11000000,
            0b01100110,
            0b00111100,
            0b00000000
        }, {
            0b11111000,
            0b01101100,
            0b01100110,
            0b01100110,
            0b01100110,
            0b01101100,
            0b11111000,
            0b00000000
        }, {
            0b11111110,
            0b01100010,
            0b01101000,
            0b01111000,
            0b01101000,
            0b01100010,
            0b11111110,
            0b00000000
        }, {
            0b11111110,
            0b01100010,
            0b01101000,
            0b01111000,
            0b01101000,
            0b01100000,
            0b11110000,
            0b00000000
        }, {
            0b00111100,
            0b01100110,
            0b11000000,
            0b11000000,
            0b11001110,
            0b01100110,
            0b00111110,
            0b00000000
        }, {
            0b11001100,
            0b11001100,
            0b11001100,
            0b11111100,
            0b11001100,
            0b11001100,
            0b11001100,
            0b00000000
        }, {
            0b01111000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b01111000,
            0b00000000
        }, {
            0b00011110,
            0b00001100,
            0b00001100,
            0b00001100,
            0b11001100,
            0b11001100,
            0b01111000,
            0b00000000
        }, {
            0b11100110,
            0b01100110,
            0b01101100,
            0b01111000,
            0b01101100,
            0b01100110,
            0b11100110,
            0b00000000
        }, {
            0b11110000,
            0b01100000,
            0b01100000,
            0b01100000,
            0b01100010,
            0b01100110,
            0b11111110,
            0b00000000
        }, {
            0b11000110,
            0b11101110,
            0b11111110,
            0b11111110,
            0b11010110,
            0b11000110,
            0b11000110,
            0b00000000
        }, {
            0b11000110,
            0b11100110,
            0b11110110,
            0b11011110,
            0b11001110,
            0b11000110,
            0b11000110,
            0b00000000
        }, {
            0b00111000,
            0b01101100,
            0b11000110,
            0b11000110,
            0b11000110,
            0b01101100,
            0b00111000,
            0b00000000
        }, {
            0b11111100,
            0b01100110,
            0b01100110,
            0b01111100,
            0b01100000,
            0b01100000,
            0b11110000,
            0b00000000
        }, {
            0b01111000,
            0b11001100,
            0b11001100,
            0b11001100,
            0b11011100,
            0b01111000,
            0b00011100,
            0b00000000
        }, {
            0b11111100,
            0b01100110,
            0b01100110,
            0b01111100,
            0b01101100,
            0b01100110,
            0b11100110,
            0b00000000
        }, {
            0b01111000,
            0b11001100,
            0b11100000,
            0b01110000,
            0b00011100,
            0b11001100,
            0b01111000,
            0b00000000
        }, {
            0b11111100,
            0b10110100,
            0b00110000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b01111000,
            0b00000000
        }, {
            0b11001100,
            0b11001100,
            0b11001100,
            0b11001100,
            0b11001100,
            0b11001100,
            0b11111100,
            0b00000000
        }, {
            0b11001100,
            0b11001100,
            0b11001100,
            0b11001100,
            0b11001100,
            0b01111000,
            0b00110000,
            0b00000000
        }, {
            0b11000110,
            0b11000110,
            0b11000110,
            0b11010110,
            0b11111110,
            0b11101110,
            0b11000110,
            0b00000000
        }, {
            0b11000110,
            0b11000110,
            0b01101100,
            0b00111000,
            0b00111000,
            0b01101100,
            0b11000110,
            0b00000000
        }, {
            0b11001100,
            0b11001100,
            0b11001100,
            0b01111000,
            0b00110000,
            0b00110000,
            0b01111000,
            0b00000000
        }, {
            0b11111110,
            0b11000110,
            0b10001100,
            0b00011000,
            0b00110010,
            0b01100110,
            0b11111110,
            0b00000000
        }, {
            0b01111000,
            0b01100000,
            0b01100000,
            0b01100000,
            0b01100000,
            0b01100000,
            0b01111000,
            0b00000000
        }, {
            0b11000000,
            0b01100000,
            0b00110000,
            0b00011000,
            0b00001100,
            0b00000110,
            0b00000010,
            0b00000000
        }, {
            0b01111000,
            0b00011000,
            0b00011000,
            0b00011000,
            0b00011000,
            0b00011000,
            0b01111000,
            0b00000000
        }, {
            0b00010000,
            0b00111000,
            0b01101100,
            0b11000110,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b11111111
        }, {
            0b00110000,
            0b00110000,
            0b00011000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b00001100,
            0b01111100,
            0b11001100,
            0b01110110,
            0b00000000
        }, {
            0b11100000,
            0b01100000,
            0b01100000,
            0b01111100,
            0b01100110,
            0b01100110,
            0b11011100,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b11001100,
            0b11000000,
            0b11001100,
            0b01111000,
            0b00000000
        }, {
            0b00011100,
            0b00001100,
            0b00001100,
            0b01111100,
            0b11001100,
            0b11001100,
            0b01110110,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b11001100,
            0b11111100,
            0b11000000,
            0b01111000,
            0b00000000
        }, {
            0b00111000,
            0b01101100,
            0b01100000,
            0b11110000,
            0b01100000,
            0b01100000,
            0b11110000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b01110110,
            0b11001100,
            0b11001100,
            0b01111100,
            0b00001100,
            0b11111000
        }, {
            0b11100000,
            0b01100000,
            0b01101100,
            0b01110110,
            0b01100110,
            0b01100110,
            0b11100110,
            0b00000000
        }, {
            0b00110000,
            0b00000000,
            0b01110000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b01111000,
            0b00000000
        }, {
            0b00001100,
            0b00000000,
            0b00001100,
            0b00001100,
            0b00001100,
            0b11001100,
            0b11001100,
            0b01111000
        }, {
            0b11100000,
            0b01100000,
            0b01100110,
            0b01101100,
            0b01111000,
            0b01101100,
            0b11100110,
            0b00000000
        }, {
            0b01110000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b00110000,
            0b01111000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b11001100,
            0b11111110,
            0b11111110,
            0b11010110,
            0b11000110,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b11111000,
            0b11001100,
            0b11001100,
            0b11001100,
            0b11001100,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b01111000,
            0b11001100,
            0b11001100,
            0b11001100,
            0b01111000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b11011100,
            0b01100110,
            0b01100110,
            0b01111100,
            0b01100000,
            0b11110000
        }, {
            0b00000000,
            0b00000000,
            0b01110110,
            0b11001100,
            0b11001100,
            0b01111100,
            0b00001100,
            0b00011110
        }, {
            0b00000000,
            0b00000000,
            0b11011100,
            0b01110110,
            0b01100110,
            0b01100000,
            0b11110000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b01111100,
            0b11000000,
            0b01111000,
            0b00001100,
            0b11111000,
            0b00000000
        }, {
            0b00010000,
            0b00110000,
            0b01111100,
            0b00110000,
            0b00110000,
            0b00110100,
            0b00011000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b11001100,
            0b11001100,
            0b11001100,
            0b11001100,
            0b01110110,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b11001100,
            0b11001100,
            0b11001100,
            0b01111000,
            0b00110000,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b11000110,
            0b11010110,
            0b11111110,
            0b11111110,
            0b01101100,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b11000110,
            0b01101100,
            0b00111000,
            0b01101100,
            0b11000110,
            0b00000000
        }, {
            0b00000000,
            0b00000000,
            0b11001100,
            0b11001100,
            0b11001100,
            0b01111100,
            0b00001100,
            0b11111000
        }, {
            0b00000000,
            0b00000000,
            0b11111100,
            0b10011000,
            0b00110000,
            0b01100100,
            0b11111100,
            0b00000000
        }, {
            0b00011100,
            0b00110000,
            0b00110000,
            0b11100000,
            0b00110000,
            0b00110000,
            0b00011100,
            0b00000000
        }, {
            0b00011000,
            0b00011000,
            0b00011000,
            0b00000000,
            0b00011000,
            0b00011000,
            0b00011000,
            0b00000000
        }, {
            0b11100000,
            0b00110000,
            0b00110000,
            0b00011100,
            0b00110000,
            0b00110000,
            0b11100000,
            0b00000000
        }, {
            0b01110110,
            0b11011100,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000,
            0b00000000
        }};

    @Override public int getCharacterWidth() { return 8; }
    @Override public int getCharacterHeight() { return 8; }

    @Override public int[] getCharacter(final char CHAR) {
        int ascii = (int) CHAR;
        if (ascii < 32 || ascii > 126) { return ASCII_32_126[0]; }
        return ASCII_32_126[ascii - 32];
    }
}
