/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.dekker.Match;
import eu.interedition.collatex.needlemanwunsch.NeedlemanWunschAlgorithm;
import eu.interedition.collatex.needlemanwunsch.NeedlemanWunschScorer;
import eu.interedition.collatex.util.VertexMatch;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface CollationAlgorithm {
    public void collate(VariantGraph var1, Iterable<Token> var2);

    public void collate(VariantGraph var1, Iterable<Token> ... var2);

    public void collate(VariantGraph var1, List<? extends Iterable<Token>> var2);

    public static class MatchPhraseAlignmentScorer
    implements NeedlemanWunschScorer<SortedSet<VertexMatch.WithTokenIndex>, SortedSet<VertexMatch.WithTokenIndex>> {
        private final int maxWitnessLength;

        public MatchPhraseAlignmentScorer(int maxWitnessLength) {
            this.maxWitnessLength = maxWitnessLength;
        }

        @Override
        public float score(SortedSet<VertexMatch.WithTokenIndex> a, SortedSet<VertexMatch.WithTokenIndex> b) {
            return a.equals(b) ? 1 : -this.maxWitnessLength;
        }

        @Override
        public float gap() {
            return -(1.0f / ((float)this.maxWitnessLength * 1.0f));
        }
    }

    public static abstract class Base
    implements CollationAlgorithm {
        protected final Logger LOG = Logger.getLogger(this.getClass().getName());
        protected Map<Token, VariantGraph.Vertex> witnessTokenVertices;

        @Override
        public void collate(VariantGraph against, Iterable<Token> ... witnesses) {
            this.collate(against, Arrays.asList(witnesses));
        }

        @Override
        public void collate(VariantGraph against, List<? extends Iterable<Token>> witnesses) {
            for (Iterable<Token> iterable : witnesses) {
                if (this.LOG.isLoggable(Level.FINE)) {
                    this.LOG.log(Level.FINE, "heap space: {0}/{1}", new Object[]{Runtime.getRuntime().totalMemory(), Runtime.getRuntime().maxMemory()});
                }
                this.collate(against, iterable);
            }
        }

        protected void merge(VariantGraph into, Iterable<Token> witnessTokens, Map<Token, VariantGraph.Vertex> alignments) {
            Witness witness = StreamSupport.stream(witnessTokens.spliterator(), false).findFirst().map(Token::getWitness).orElseThrow(() -> new IllegalArgumentException("Empty witness"));
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "{0} + {1}: Merge comparand into graph", new Object[]{into, witness});
            }
            this.witnessTokenVertices = new HashMap<Token, VariantGraph.Vertex>();
            VariantGraph.Vertex last = into.getStart();
            Set<Witness> witnessSet = Collections.singleton(witness);
            for (Token token : witnessTokens) {
                VariantGraph.Vertex matchingVertex = alignments.get(token);
                if (matchingVertex == null) {
                    matchingVertex = into.add(token);
                } else {
                    if (this.LOG.isLoggable(Level.FINE)) {
                        this.LOG.log(Level.FINE, "Match: {0} to {1}", new Object[]{matchingVertex, token});
                    }
                    matchingVertex.add(Collections.singleton(token));
                }
                this.witnessTokenVertices.put(token, matchingVertex);
                into.connect(last, matchingVertex, witnessSet);
                last = matchingVertex;
            }
            into.connect(last, into.getEnd(), witnessSet);
        }

        protected void mergeTranspositions(VariantGraph into, Iterable<SortedSet<VertexMatch.WithToken>> transpositions) {
            for (SortedSet<VertexMatch.WithToken> transposedPhrase : transpositions) {
                if (this.LOG.isLoggable(Level.FINE)) {
                    this.LOG.log(Level.FINE, "Transposition: {0}", transposedPhrase);
                }
                HashSet<VariantGraph.Vertex> transposed = new HashSet<VariantGraph.Vertex>();
                for (VertexMatch.WithToken match : transposedPhrase) {
                    transposed.add(this.witnessTokenVertices.get(match.token));
                    transposed.add(match.vertex);
                }
                into.transpose(transposed);
            }
        }

        protected void mergeTranspositions(VariantGraph into, List<List<Match>> transpositions) {
            for (List<Match> transposedPhrase : transpositions) {
                if (this.LOG.isLoggable(Level.FINE)) {
                    this.LOG.log(Level.FINE, "Transposition: {0}", transposedPhrase);
                }
                HashSet<VariantGraph.Vertex> transposed = new HashSet<VariantGraph.Vertex>();
                for (Match match : transposedPhrase) {
                    transposed.add(this.witnessTokenVertices.get(match.token));
                    transposed.add(match.vertex);
                }
                into.transpose(transposed);
            }
        }

        protected void merge(VariantGraph graph, VariantGraph.Vertex[][] vertices, Token[] tokens, SortedSet<SortedSet<VertexMatch.WithTokenIndex>> matches) {
            SortedSet[] matchesVertexOrder = matches.toArray(new SortedSet[matches.size()]);
            SortedSet[] matchesTokenOrder = Arrays.copyOf(matchesVertexOrder, matchesVertexOrder.length);
            Arrays.sort(matchesTokenOrder, Comparator.comparing(m -> ((VertexMatch.WithTokenIndex)m.first()).token));
            Set<SortedSet<VertexMatch.WithTokenIndex>> alignedMatches = NeedlemanWunschAlgorithm.align(matchesVertexOrder, matchesTokenOrder, new MatchPhraseAlignmentScorer(Math.max(tokens.length, vertices.length))).keySet();
            Map<Token, VariantGraph.Vertex> alignments = matches.stream().filter(alignedMatches::contains).flatMap(Collection::stream).collect(Collectors.toMap(m -> tokens[m.token], m -> m.vertex));
            List<SortedSet<VertexMatch.WithToken>> transpositions = matches.stream().filter(m -> !alignedMatches.contains(m)).map(t -> t.stream().map(m -> new VertexMatch.WithToken(m.vertex, m.vertexRank, tokens[m.token])).collect(Collectors.toCollection(TreeSet::new))).collect(Collectors.toList());
            this.merge(graph, Arrays.asList(tokens), alignments);
            this.mergeTranspositions(graph, (Iterable<SortedSet<VertexMatch.WithToken>>)transpositions);
        }
    }
}

