/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.util.VariantGraphTraversal;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class VariantGraph {
    final Vertex start;
    final Vertex end;
    final Map<Vertex, Set<Set<Vertex>>> transpositionIndex = new HashMap<Vertex, Set<Set<Vertex>>>();
    public static final Function<VariantGraph, VariantGraph> JOIN = graph -> {
        HashSet<Vertex> processed = new HashSet<Vertex>();
        ArrayDeque queue = new ArrayDeque(graph.start.outgoing.keySet());
        while (!queue.isEmpty()) {
            Vertex vertex = (Vertex)queue.pop();
            HashSet<Set<Vertex>> transpositions = new HashSet<Set<Vertex>>(vertex.transpositions());
            if (vertex.outgoing.size() == 1) {
                boolean canJoin;
                Vertex joinCandidateVertex = (Vertex)vertex.outgoing.keySet().iterator().next();
                HashSet<Set<Vertex>> joinCandidateTranspositions = new HashSet<Set<Vertex>>(joinCandidateVertex.transpositions());
                boolean bl = canJoin = !graph.end.equals(joinCandidateVertex) && joinCandidateVertex.incoming.size() == 1 && transpositions.equals(joinCandidateTranspositions);
                if (canJoin) {
                    vertex.add(joinCandidateVertex.tokens());
                    for (Set<Vertex> t : new HashSet<Set<Vertex>>(joinCandidateVertex.transpositions())) {
                        HashSet<Vertex> transposed = new HashSet<Vertex>(t);
                        transposed.remove(joinCandidateVertex);
                        transposed.add(vertex);
                        for (Vertex tv : t) {
                            graph.transpositionIndex.getOrDefault(tv, Collections.emptySet()).remove(t);
                        }
                        graph.transpose(transposed);
                    }
                    vertex.outgoing.clear();
                    vertex.outgoing.putAll(joinCandidateVertex.outgoing);
                    vertex.outgoing.keySet().forEach(v -> {
                        Set cfr_ignored_0 = (Set)((Vertex)v).incoming.put(vertex, ((Vertex)v).incoming.remove(joinCandidateVertex));
                    });
                    queue.push(vertex);
                    continue;
                }
            }
            processed.add(vertex);
            vertex.outgoing.keySet().stream().filter(v -> !processed.contains(v)).forEach(queue::push);
        }
        return graph;
    };

    public VariantGraph() {
        this.start = new Vertex(this);
        this.end = new Vertex(this);
        this.start.outgoing.put(this.end, Collections.emptySet());
        this.end.incoming.put(this.start, Collections.emptySet());
    }

    public Vertex getStart() {
        return this.start;
    }

    public Vertex getEnd() {
        return this.end;
    }

    public Set<Set<Vertex>> transpositions() {
        return this.transpositionIndex.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Iterable<Vertex> vertices() {
        return VariantGraphTraversal.of(this);
    }

    public Vertex add(Token token) {
        Vertex vertex = new Vertex(this);
        vertex.tokens.add(token);
        return vertex;
    }

    public void connect(Vertex from, Vertex to, Set<Witness> witnesses) {
        if (from.equals(to)) {
            throw new IllegalArgumentException();
        }
        witnesses = new HashSet<Witness>(witnesses);
        Optional.ofNullable(from.outgoing.remove(to)).ifPresent(witnesses::addAll);
        from.outgoing.put(to, witnesses);
        to.incoming.put(from, witnesses);
        this.start.outgoing.remove(this.end);
        this.end.incoming.remove(this.start);
    }

    public Set<Vertex> transpose(Set<Vertex> vertices) {
        if (vertices.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (Set<Vertex> transposition : vertices.iterator().next().transpositions()) {
            if (!transposition.equals(vertices)) continue;
            return transposition;
        }
        HashSet<Vertex> t = new HashSet<Vertex>(vertices);
        for (Vertex vertex : t) {
            this.transpositionIndex.computeIfAbsent(vertex, v -> new HashSet()).add(t);
        }
        return t;
    }

    public Set<Witness> witnesses() {
        return this.start.outgoing().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public String toString() {
        return this.witnesses().toString();
    }

    public static class Vertex {
        private final VariantGraph graph;
        private final Set<Token> tokens = new HashSet<Token>();
        private final Map<Vertex, Set<Witness>> outgoing = new HashMap<Vertex, Set<Witness>>();
        private final Map<Vertex, Set<Witness>> incoming = new HashMap<Vertex, Set<Witness>>();

        public Vertex(VariantGraph graph) {
            this.graph = graph;
        }

        public Map<Vertex, Set<Witness>> incoming() {
            return this.incoming;
        }

        public Map<Vertex, Set<Witness>> outgoing() {
            return this.outgoing;
        }

        public Set<Set<Vertex>> transpositions() {
            return this.graph.transpositionIndex.getOrDefault(this, Collections.emptySet());
        }

        public Set<Token> tokens() {
            return this.tokens;
        }

        public Set<Witness> witnesses() {
            return this.incoming().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }

        public void add(Iterable<Token> tokens) {
            tokens.forEach(this.tokens::add);
        }

        public VariantGraph graph() {
            return this.graph;
        }

        public String toString() {
            return this.tokens.toString();
        }
    }
}

