/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker;

import eu.interedition.collatex.CollationAlgorithm;
import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.dekker.Match;
import eu.interedition.collatex.dekker.PhraseMatchDetector;
import eu.interedition.collatex.dekker.TokenLinker;
import eu.interedition.collatex.dekker.TranspositionDetector;
import eu.interedition.collatex.dekker.matrix.MatchTableLinker;
import eu.interedition.collatex.util.VariantGraphRanking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DekkerAlgorithm
extends CollationAlgorithm.Base {
    private final Comparator<Token> comparator;
    private final TokenLinker tokenLinker;
    private final PhraseMatchDetector phraseMatchDetector;
    private final TranspositionDetector transpositionDetector;
    private Map<Token, VariantGraph.Vertex> tokenLinks;
    private List<List<Match>> phraseMatches;
    private List<List<Match>> transpositions;
    private Map<Token, VariantGraph.Vertex> alignments;
    private boolean mergeTranspositions = false;

    public DekkerAlgorithm(Comparator<Token> comparator) {
        this(comparator, new MatchTableLinker());
    }

    public DekkerAlgorithm(Comparator<Token> comparator, TokenLinker tokenLinker) {
        this.comparator = comparator;
        this.tokenLinker = tokenLinker;
        this.phraseMatchDetector = new PhraseMatchDetector();
        this.transpositionDetector = new TranspositionDetector();
    }

    @Override
    public void collate(VariantGraph graph, Iterable<Token> tokens) {
        Witness witness = StreamSupport.stream(tokens.spliterator(), false).findFirst().map(Token::getWitness).orElseThrow(() -> new IllegalArgumentException("Empty witness"));
        if (this.LOG.isLoggable(Level.FINER)) {
            this.LOG.log(Level.FINER, "{0} + {1}: {2} vs. {3}", new Object[]{graph, witness, graph.vertices(), tokens});
        }
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.log(Level.FINE, "{0} + {1}: Match and link tokens", new Object[]{graph, witness});
        }
        this.tokenLinks = this.tokenLinker.link(graph, tokens, this.comparator);
        if (this.LOG.isLoggable(Level.FINER)) {
            for (Map.Entry<Token, VariantGraph.Vertex> entry : this.tokenLinks.entrySet()) {
                this.LOG.log(Level.FINER, "{0} + {1}: Token match: {2} = {3}", new Object[]{graph, witness, entry.getValue(), entry.getKey()});
            }
        }
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.log(Level.FINE, "{0} + {1}: Detect phrase matches", new Object[]{graph, witness});
        }
        this.phraseMatches = this.phraseMatchDetector.detect(this.tokenLinks, graph, tokens);
        if (this.LOG.isLoggable(Level.FINER)) {
            for (List list : this.phraseMatches) {
                this.LOG.log(Level.FINER, "{0} + {1}: Phrase match: {2}", new Object[]{graph, witness, list});
            }
        }
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.log(Level.FINE, "{0} + {1}: Detect transpositions", new Object[]{graph, witness});
        }
        this.transpositions = this.transpositionDetector.detect(this.phraseMatches, graph);
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.log(Level.FINE, "transpositions:{0}", this.transpositions);
        }
        if (this.LOG.isLoggable(Level.FINER)) {
            for (List list : this.transpositions) {
                this.LOG.log(Level.FINER, "{0} + {1}: Transposition: {2}", new Object[]{graph, witness, list});
            }
        }
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.log(Level.FINE, "{0} + {1}: Determine aligned tokens by filtering transpositions", new Object[]{graph, witness});
        }
        this.alignments = new HashMap<Token, VariantGraph.Vertex>();
        for (List list : this.phraseMatches) {
            for (Match match : list) {
                this.alignments.put(match.token, match.vertex);
            }
        }
        for (List list : this.transpositions) {
            for (Match match : list) {
                this.alignments.remove(match.token);
            }
        }
        if (this.LOG.isLoggable(Level.FINER)) {
            for (Map.Entry entry : this.alignments.entrySet()) {
                this.LOG.log(Level.FINER, "{0} + {1}: Alignment: {2} = {3}", new Object[]{graph, witness, entry.getValue(), entry.getKey()});
            }
        }
        this.merge(graph, tokens, this.alignments);
        ArrayList<List> falseTranspositions = new ArrayList<List>();
        VariantGraphRanking variantGraphRanking = VariantGraphRanking.of(graph);
        for (List list : this.transpositions) {
            Match match = (Match)list.get(0);
            VariantGraph.Vertex v1 = (VariantGraph.Vertex)this.witnessTokenVertices.get(match.token);
            VariantGraph.Vertex v2 = match.vertex;
            int distance = Math.abs(variantGraphRanking.apply(v1) - variantGraphRanking.apply(v2)) - 1;
            if (distance <= list.size() * 3) continue;
            falseTranspositions.add(list);
        }
        for (List list : falseTranspositions) {
            this.transpositions.remove(list);
        }
        if (this.mergeTranspositions) {
            this.mergeTranspositions(graph, this.transpositions);
        }
        if (this.LOG.isLoggable(Level.FINER)) {
            this.LOG.log(Level.FINER, "!{0}: {1}", new Object[]{graph, StreamSupport.stream(graph.vertices().spliterator(), false).map(Object::toString).collect(Collectors.joining(", "))});
        }
    }

    public Map<Token, VariantGraph.Vertex> getTokenLinks() {
        return this.tokenLinks;
    }

    public List<List<Match>> getPhraseMatches() {
        return Collections.unmodifiableList(this.phraseMatches);
    }

    public List<List<Match>> getTranspositions() {
        return Collections.unmodifiableList(this.transpositions);
    }

    public Map<Token, VariantGraph.Vertex> getAlignments() {
        return Collections.unmodifiableMap(this.alignments);
    }

    public void setMergeTranspositions(boolean b) {
        this.mergeTranspositions = b;
    }
}

