/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Match {
    public final VariantGraph.Vertex vertex;
    public final Token token;
    public static final Function<List<Match>, List<Token>> PHRASE_MATCH_TO_TOKENS = input -> input.stream().map(m -> m.token).collect(Collectors.toList());

    public Match(VariantGraph.Vertex vertex, Token token) {
        this.vertex = vertex;
        this.token = token;
    }

    public int hashCode() {
        return Objects.hash(this.vertex, this.token);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Match) {
            Match other = (Match)obj;
            return this.vertex.equals(other.vertex) && this.token.equals(other.token);
        }
        return super.equals(obj);
    }

    public String toString() {
        return "{" + this.vertex + "; " + this.token + "}";
    }

    public static List<Match> createPhraseMatch(List<VariantGraph.Vertex> vertices, List<Token> tokens) {
        ArrayList<Match> phraseMatch = new ArrayList<Match>(vertices.size());
        Iterator<VariantGraph.Vertex> vertexIt = vertices.iterator();
        Iterator<Token> tokenIt = tokens.iterator();
        while (vertexIt.hasNext() && tokenIt.hasNext()) {
            phraseMatch.add(new Match(vertexIt.next(), tokenIt.next()));
        }
        return phraseMatch;
    }

    public static Predicate<Match> createNoBoundaryMatchPredicate(VariantGraph graph) {
        return input -> !input.vertex.equals(graph.getStart()) && !input.vertex.equals(graph.getEnd());
    }
}

