/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.matrix;

import eu.interedition.collatex.dekker.matrix.Coordinate;
import eu.interedition.collatex.dekker.matrix.Island;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class Archipelago {
    Logger LOG = Logger.getLogger(Archipelago.class.getName());
    private final List<Island> islands;
    private final Set<Integer> islandvectors;

    public Archipelago() {
        this.islands = new ArrayList<Island>();
        this.islandvectors = new HashSet<Integer>();
    }

    public Archipelago(Archipelago orig) {
        this.islands = new ArrayList<Island>(orig.islands);
        this.islandvectors = new HashSet<Integer>(orig.islandvectors);
    }

    public Archipelago(Island isl) {
        this();
        this.islands.add(isl);
    }

    public void add(Island island) {
        this.islands.add(island);
        Coordinate leftEnd = island.getLeftEnd();
        this.islandvectors.add(leftEnd.row - leftEnd.column);
    }

    public int size() {
        return this.islands.size();
    }

    public Island get(int i) {
        return this.islands.get(i);
    }

    public boolean containsCoordinate(int row, int column) {
        return Objects.equals(this.getCoordinatesMap().get(row), column);
    }

    public List<Island> getIslands() {
        return this.islands;
    }

    protected void remove(int i) {
        this.islands.remove(i);
    }

    public String toString() {
        String result = "";
        for (Island island : this.getIslands()) {
            if (result.isEmpty()) {
                result = "[ " + island;
                continue;
            }
            result = result + ", " + island;
        }
        result = result + " ]";
        return result;
    }

    public int hashCode() {
        return Objects.hashCode(this.islands);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (((Archipelago)object).size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((Archipelago)object).get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }

    private Map<Integer, Integer> getCoordinatesMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Island isl : this.islands) {
            for (Coordinate c : isl) {
                map.put(c.getRow(), c.getColumn());
            }
        }
        return map;
    }

    private double distance(Island isl1, Island isl2) {
        double result = 0.0;
        int isl1_L_x = isl1.getLeftEnd().column;
        int isl1_L_y = isl1.getLeftEnd().row;
        int isl1_R_x = isl1.getRightEnd().column;
        int isl1_R_y = isl1.getRightEnd().row;
        int isl2_L_x = isl2.getLeftEnd().column;
        int isl2_L_y = isl2.getLeftEnd().row;
        int isl2_R_x = isl2.getRightEnd().column;
        int isl2_R_y = isl2.getRightEnd().row;
        result = this.distance(isl1_L_x, isl1_L_y, isl2_L_x, isl2_L_y);
        double d = this.distance(isl1_L_x, isl1_L_y, isl2_R_x, isl2_R_y);
        if (d < result) {
            result = d;
        }
        if ((d = this.distance(isl1_R_x, isl1_R_y, isl2_L_x, isl2_L_y)) < result) {
            result = d;
        }
        if ((d = this.distance(isl1_R_x, isl1_R_y, isl2_R_x, isl2_R_y)) < result) {
            result = d;
        }
        return result;
    }

    private double distance(int a_x, int a_y, int b_x, int b_y) {
        double result = 0.0;
        result = Math.sqrt((a_x - b_x) * (a_x - b_x) + (a_y - b_y) * (a_y - b_y));
        return result;
    }

    public Set<Integer> getIslandVectors() {
        return this.islandvectors;
    }

    public double smallestDistance(Island isl) {
        double minimum = 10000.0;
        for (Island fixedIsland : this.getIslands()) {
            minimum = Math.min(minimum, this.distance(isl, fixedIsland));
        }
        return minimum;
    }

    public double smallestDistanceToIdealLine(Island isl) {
        double minimum = 10000.0;
        Island closestIsland = null;
        Iterator<Island> iterator = this.getIslands().iterator();
        while (iterator.hasNext()) {
            double prev = minimum;
            Island fixedIsland = iterator.next();
            if (!(prev > (minimum = Math.min(minimum, this.distance(isl, fixedIsland))))) continue;
            closestIsland = fixedIsland;
        }
        if (closestIsland == null) {
            return minimum;
        }
        Coordinate leftEnd = isl.getLeftEnd();
        int islandVector = leftEnd.row - leftEnd.column;
        Coordinate leftEnd0 = closestIsland.getLeftEnd();
        int closestIslandVector = leftEnd0.row - leftEnd0.column;
        return Math.abs(islandVector - closestIslandVector);
    }
}

