/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.matrix;

import eu.interedition.collatex.dekker.matrix.Coordinate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Island
implements Iterable<Coordinate>,
Comparable<Island> {
    private int direction = 0;
    private final List<Coordinate> islandCoordinates = new ArrayList<Coordinate>();

    public Island() {
    }

    public Island(Island other) {
        for (Coordinate c : other.islandCoordinates) {
            this.add(new Coordinate(c));
        }
    }

    public Island(Coordinate first, Coordinate last) {
        this.add(first);
        Coordinate newCoordinate = first;
        while (!newCoordinate.equals(last)) {
            newCoordinate = new Coordinate(newCoordinate.getRow() + 1, newCoordinate.getColumn() + 1);
            this.add(newCoordinate);
        }
    }

    public boolean add(Coordinate coordinate) {
        boolean result = false;
        if (this.islandCoordinates.isEmpty()) {
            result = this.islandCoordinates.add(coordinate);
        } else if (!this.contains(coordinate) && this.neighbour(coordinate)) {
            if (this.direction == 0) {
                Coordinate existing = this.islandCoordinates.get(0);
                this.direction = (existing.row - coordinate.row) / (existing.column - coordinate.column);
                result = this.islandCoordinates.add(coordinate);
            } else {
                int new_direction;
                Coordinate existing = this.islandCoordinates.get(0);
                if (existing.column != coordinate.column && (new_direction = (existing.row - coordinate.row) / (existing.column - coordinate.column)) == this.direction) {
                    result = this.islandCoordinates.add(coordinate);
                }
            }
        }
        return result;
    }

    public int direction() {
        return this.direction;
    }

    public Island removePoints(Island di) {
        Island result = new Island(this);
        for (Coordinate c : di) {
            result.removeSameColOrRow(c);
        }
        return result;
    }

    public void removeCoordinate(Coordinate c) {
        this.islandCoordinates.remove(c);
    }

    public Coordinate getCoorOnRow(int row) {
        for (Coordinate coor : this.islandCoordinates) {
            if (coor.getRow() != row) continue;
            return coor;
        }
        return null;
    }

    public Coordinate getCoorOnCol(int col) {
        for (Coordinate coor : this.islandCoordinates) {
            if (coor.getColumn() != col) continue;
            return coor;
        }
        return null;
    }

    public void merge(Island di) {
        for (Coordinate c : di) {
            this.add(c);
        }
    }

    public boolean isCompetitor(Island isl) {
        for (Coordinate c : isl) {
            for (Coordinate d : this.islandCoordinates) {
                if (!c.sameColumn(d) && !c.sameRow(d)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Coordinate c) {
        return this.islandCoordinates.contains(c);
    }

    public boolean neighbour(Coordinate c) {
        if (this.contains(c)) {
            return false;
        }
        for (Coordinate islC : this.islandCoordinates) {
            if (!c.bordersOn(islC)) continue;
            return true;
        }
        return false;
    }

    public Coordinate getLeftEnd() {
        Coordinate coor = this.islandCoordinates.get(0);
        for (Coordinate c : this.islandCoordinates) {
            if (c.column >= coor.column) continue;
            coor = c;
        }
        return coor;
    }

    public Coordinate getRightEnd() {
        Coordinate coor = this.islandCoordinates.get(0);
        for (Coordinate c : this.islandCoordinates) {
            if (c.column <= coor.column) continue;
            coor = c;
        }
        return coor;
    }

    public boolean overlap(Island isl) {
        for (Coordinate c : isl) {
            if (!this.contains(c) && !this.neighbour(c)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.islandCoordinates.size();
    }

    public void clear() {
        this.islandCoordinates.clear();
    }

    public int value() {
        int size = this.size();
        return size < 2 ? size : this.direction + size * size;
    }

    protected boolean removeSameColOrRow(Coordinate c) {
        ArrayList<Coordinate> remove = new ArrayList<Coordinate>();
        for (Coordinate coor : this.islandCoordinates) {
            if (!coor.sameColumn(c) && !coor.sameRow(c)) continue;
            remove.add(coor);
        }
        if (remove.isEmpty()) {
            return false;
        }
        for (Coordinate coor : remove) {
            this.islandCoordinates.remove(coor);
        }
        return true;
    }

    @Override
    public Iterator<Coordinate> iterator() {
        return Collections.unmodifiableList(this.islandCoordinates).iterator();
    }

    public int hashCode() {
        return this.islandCoordinates.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(Island.class)) {
            return false;
        }
        Island isl = (Island)obj;
        if (isl.size() != this.size()) {
            return false;
        }
        boolean result = true;
        for (Coordinate c : isl) {
            result &= this.contains(c);
        }
        return result;
    }

    public String toString() {
        if (this.islandCoordinates.isEmpty()) {
            throw new RuntimeException("Unexpected situation: island coordinates empty!");
        }
        return MessageFormat.format("Island ({0}-{1}) size: {2} direction: {3}", this.islandCoordinates.get(0), this.islandCoordinates.get(this.islandCoordinates.size() - 1), this.size(), this.direction());
    }

    @Override
    public int compareTo(Island i) {
        return this.getLeftEnd().compareTo(i.getLeftEnd());
    }
}

