/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.matrix;

import eu.interedition.collatex.dekker.matrix.Coordinate;
import eu.interedition.collatex.dekker.matrix.Island;
import eu.interedition.collatex.dekker.matrix.IslandCompetition;
import eu.interedition.collatex.dekker.matrix.MatchTable;
import eu.interedition.collatex.dekker.matrix.MatchTableSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class IslandConflictResolver {
    Logger LOG = Logger.getLogger(IslandConflictResolver.class.getName());
    private final MatchTableSelection selection;

    public IslandConflictResolver(MatchTable table) {
        this.selection = new MatchTableSelection(table);
    }

    public MatchTableSelection createNonConflictingVersion() {
        List<Island> possibleIslands;
        do {
            if ((possibleIslands = this.selection.getPossibleIslands()).size() == 1) {
                this.selection.addIsland(possibleIslands.get(0));
                continue;
            }
            if (possibleIslands.size() <= 1) continue;
            Map<IslandCompetition, List<Island>> analysis = this.analyzeConflictsBetweenPossibleIslands(possibleIslands);
            this.resolveConflictsBySelectingPreferredIslands(this.selection, analysis);
        } while (!possibleIslands.isEmpty());
        return this.selection;
    }

    public Map<IslandCompetition, List<Island>> analyzeConflictsBetweenPossibleIslands(List<Island> possibleIslands) {
        HashMap<IslandCompetition, List<Island>> conflictMap = new HashMap<IslandCompetition, List<Island>>();
        Set<Island> competingIslands = this.getCompetingIslands(possibleIslands);
        for (Island island : competingIslands) {
            if (this.selection.doesCandidateLayOnVectorOfCommittedIsland(island)) {
                conflictMap.computeIfAbsent(IslandCompetition.CompetingIslandAndOnIdealIine, c -> new ArrayList()).add(island);
                continue;
            }
            conflictMap.computeIfAbsent(IslandCompetition.CompetingIsland, c -> new ArrayList()).add(island);
        }
        for (Island island : this.getNonCompetingIslands(possibleIslands, competingIslands)) {
            conflictMap.computeIfAbsent(IslandCompetition.NonCompetingIsland, c -> new ArrayList()).add(island);
        }
        return conflictMap;
    }

    private void resolveConflictsBySelectingPreferredIslands(MatchTableSelection selection, Map<IslandCompetition, List<Island>> islandConflictMap) {
        this.LOG.fine("addBestOfCompeting with competingIslandsOnIdealLine");
        this.makeDistanceMap(islandConflictMap.getOrDefault((Object)IslandCompetition.CompetingIslandAndOnIdealIine, Collections.emptyList())).values().stream().flatMap(Collection::stream).filter(ci1 -> selection.isIslandPossibleCandidate((Island)ci1)).forEach(selection::addIsland);
        this.LOG.fine("addBestOfCompeting with otherCompetingIslands");
        this.makeDistanceMap(islandConflictMap.getOrDefault((Object)IslandCompetition.CompetingIsland, Collections.emptyList())).values().stream().flatMap(Collection::stream).filter(ci -> selection.isIslandPossibleCandidate((Island)ci)).forEach(selection::addIsland);
        this.LOG.fine("add non competing islands");
        islandConflictMap.getOrDefault((Object)IslandCompetition.NonCompetingIsland, Collections.emptyList()).forEach(selection::addIsland);
    }

    private SortedMap<Double, List<Island>> makeDistanceMap(Collection<Island> competingIslands) {
        TreeMap<Double, List<Island>> distanceMap = new TreeMap<Double, List<Island>>();
        for (Island isl : competingIslands) {
            Coordinate leftEnd = isl.getLeftEnd();
            double ratio = (double)(leftEnd.column + 1) / (double)(leftEnd.row + 1);
            double b2 = Math.log(ratio) / Math.log(2.0);
            double distanceToIdealLine = Math.abs(b2);
            distanceMap.computeIfAbsent(distanceToIdealLine, d -> new ArrayList()).add(isl);
        }
        return distanceMap;
    }

    private Set<Island> getNonCompetingIslands(List<Island> islands, Set<Island> competingIslands) {
        HashSet<Island> nonCompetingIslands = new HashSet<Island>(islands);
        nonCompetingIslands.removeAll(competingIslands);
        return nonCompetingIslands;
    }

    private Set<Island> getCompetingIslands(List<Island> islands) {
        HashSet<Island> competingIslands = new HashSet<Island>();
        for (int i = 0; i < islands.size(); ++i) {
            Island i1 = islands.get(i);
            for (int j = 1; j < islands.size() - i; ++j) {
                Island i2 = islands.get(i + j);
                if (!i1.isCompetitor(i2)) continue;
                competingIslands.add(i1);
                competingIslands.add(i2);
            }
        }
        return competingIslands;
    }
}

