/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.matrix;

import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.dekker.matrix.Archipelago;
import eu.interedition.collatex.dekker.matrix.Coordinate;
import eu.interedition.collatex.dekker.matrix.Island;
import eu.interedition.collatex.dekker.matrix.MatchTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MatchTableSelection {
    Logger LOG = Logger.getLogger(MatchTableSelection.class.getName());
    private final Map<Integer, List<Island>> islandMultimap;
    private final Archipelago fixedIslands;
    private final Set<Integer> fixedRows;
    private final Set<VariantGraph.Vertex> fixedVertices;
    private final MatchTable table;

    public MatchTableSelection(MatchTable table) {
        this.fixedRows = new HashSet<Integer>();
        this.fixedVertices = new HashSet<VariantGraph.Vertex>();
        this.table = table;
        this.fixedIslands = new Archipelago();
        this.islandMultimap = new HashMap<Integer, List<Island>>();
        for (Island isl : table.getIslands()) {
            this.islandMultimap.computeIfAbsent(isl.size(), s -> new ArrayList()).add(isl);
        }
    }

    public MatchTableSelection(MatchTableSelection orig) {
        this.islandMultimap = orig.islandMultimap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue())));
        this.fixedIslands = new Archipelago(orig.fixedIslands);
        this.fixedRows = new HashSet<Integer>(orig.fixedRows);
        this.fixedVertices = new HashSet<VariantGraph.Vertex>(orig.fixedVertices);
        this.table = orig.table;
    }

    public boolean doesCoordinateOverlapWithCommittedCoordinate(Coordinate coordinate) {
        return this.fixedRows.contains(coordinate.row) || this.fixedVertices.contains(this.table.vertexAt(coordinate.row, coordinate.column));
    }

    public boolean isIslandPossibleCandidate(Island island) {
        for (Coordinate coordinate : island) {
            if (!this.doesCoordinateOverlapWithCommittedCoordinate(coordinate)) continue;
            return false;
        }
        return true;
    }

    public void addIsland(Island isl) {
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.log(Level.FINE, "adding island: '{0}'", isl);
        }
        for (Coordinate coordinate : isl) {
            this.fixedRows.add(coordinate.row);
            this.fixedVertices.add(this.table.vertexAt(coordinate.row, coordinate.column));
        }
        this.fixedIslands.add(isl);
        this.islandMultimap.computeIfPresent(isl.size(), (s, i) -> {
            i.remove(isl);
            return i.isEmpty() ? null : i;
        });
    }

    public boolean doesCandidateLayOnVectorOfCommittedIsland(Island island) {
        Coordinate leftEnd = island.getLeftEnd();
        return this.fixedIslands.getIslandVectors().contains(leftEnd.row - leftEnd.column);
    }

    public int size() {
        return this.fixedIslands.size();
    }

    public List<Island> getIslands() {
        return this.fixedIslands.getIslands();
    }

    public boolean containsCoordinate(int row, int column) {
        return this.fixedIslands.containsCoordinate(row, column);
    }

    public void removeOrSplitImpossibleIslands(Integer islandSize, Map<Integer, List<Island>> islandMultimap) {
        ArrayList islandsToCheck = new ArrayList(islandMultimap.getOrDefault(islandSize, Collections.emptyList()));
        for (Island island : islandsToCheck) {
            if (this.isIslandPossibleCandidate(island)) continue;
            islandMultimap.computeIfPresent(islandSize, (s, i) -> {
                i.remove(island);
                return i.isEmpty() ? null : i;
            });
            this.removeConflictingEndCoordinates(island);
            if (island.size() <= 0) continue;
            islandMultimap.computeIfAbsent(island.size(), s -> new ArrayList()).add(island);
        }
    }

    private void removeConflictingEndCoordinates(Island island) {
        boolean goOn = true;
        while (goOn) {
            Coordinate leftEnd = island.getLeftEnd();
            if (this.doesCoordinateOverlapWithCommittedCoordinate(leftEnd)) {
                island.removeCoordinate(leftEnd);
                if (island.size() != 0) continue;
                return;
            }
            goOn = false;
        }
        goOn = true;
        while (goOn) {
            Coordinate rightEnd = island.getRightEnd();
            if (this.doesCoordinateOverlapWithCommittedCoordinate(rightEnd)) {
                island.removeCoordinate(rightEnd);
                if (island.size() != 0) continue;
                return;
            }
            goOn = false;
        }
    }

    public List<Island> getPossibleIslands() {
        ArrayList<Island> possibleIslands = new ArrayList<Island>();
        while (possibleIslands.isEmpty() && !this.islandMultimap.isEmpty()) {
            Integer max = Collections.max(this.islandMultimap.keySet());
            this.LOG.fine("Checking islands of size: " + max);
            this.removeOrSplitImpossibleIslands(max, this.islandMultimap);
            possibleIslands = new ArrayList(this.islandMultimap.getOrDefault(max, Collections.emptyList()));
        }
        return possibleIslands;
    }
}

