/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.medite;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.medite.SuffixTree;
import eu.interedition.collatex.util.VertexMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Matches
extends ArrayList<SortedSet<VertexMatch.WithTokenIndex>> {
    public Matches(int initialCapacity) {
        super(initialCapacity);
    }

    public static Matches between(VariantGraph.Vertex[][] vertices, SuffixTree<Token> suffixTree, Function<SortedSet<VertexMatch.WithTokenIndex>, Integer> matchEvaluator) {
        HashMap<Integer, List> matchThreads = new HashMap<Integer, List>();
        for (int rank = 0; rank < vertices.length; ++rank) {
            for (VariantGraph.Vertex vertex : vertices[rank]) {
                MatchThreadElement matchThreadElement2 = new MatchThreadElement(suffixTree).advance(vertex, rank);
                if (matchThreadElement2 == null) continue;
                matchThreads.computeIfAbsent(rank, r -> new LinkedList()).add(matchThreadElement2);
            }
            for (MatchThreadElement matchThreadElement3 : matchThreads.getOrDefault(rank - 1, Collections.emptyList())) {
                for (VariantGraph.Vertex vertex : vertices[rank]) {
                    MatchThreadElement advanced = matchThreadElement3.advance(vertex, rank);
                    if (advanced == null) continue;
                    matchThreads.computeIfAbsent(rank, r -> new LinkedList()).add(advanced);
                }
            }
        }
        Matches matches = new Matches(matchThreads.size());
        matchThreads.values().stream().flatMap(Collection::stream).forEach((? super T matchThreadElement) -> {
            ArrayList threadPhrases = new ArrayList();
            boolean firstElement = true;
            for (MatchThreadElement threadElement : matchThreadElement.thread()) {
                SuffixTree.EquivalenceClass equivalenceClass = threadElement.cursor.matchedClass();
                for (int mc = 0; mc < equivalenceClass.length; ++mc) {
                    int tokenCandidate = equivalenceClass.members[mc];
                    if (firstElement) {
                        TreeSet<VertexMatch.WithTokenIndex> phrase = new TreeSet<VertexMatch.WithTokenIndex>();
                        phrase.add(new VertexMatch.WithTokenIndex(threadElement.vertex, threadElement.vertexRank, tokenCandidate));
                        threadPhrases.add(phrase);
                        continue;
                    }
                    for (SortedSet sortedSet : threadPhrases) {
                        if (((VertexMatch.WithTokenIndex)sortedSet.last()).token + 1 != tokenCandidate) continue;
                        sortedSet.add(new VertexMatch.WithTokenIndex(threadElement.vertex, threadElement.vertexRank, tokenCandidate));
                    }
                }
                firstElement = false;
            }
            matches.addAll(threadPhrases);
        });
        Collections.sort(matches, Matches.maximalUniqueMatchOrdering(matchEvaluator));
        return matches;
    }

    private static Comparator<SortedSet<VertexMatch.WithTokenIndex>> maximalUniqueMatchOrdering(final Function<SortedSet<VertexMatch.WithTokenIndex>, Integer> matchEvaluator) {
        return new Comparator<SortedSet<VertexMatch.WithTokenIndex>>(){

            @Override
            public int compare(SortedSet<VertexMatch.WithTokenIndex> o1, SortedSet<VertexMatch.WithTokenIndex> o2) {
                int result = (Integer)matchEvaluator.apply(o2) - (Integer)matchEvaluator.apply(o1);
                if (result != 0) {
                    return result;
                }
                VertexMatch.WithTokenIndex firstMatch1 = o1.first();
                VertexMatch.WithTokenIndex firstMatch2 = o2.first();
                result = Math.abs(firstMatch1.token - firstMatch1.vertexRank) - Math.abs(firstMatch2.token - firstMatch2.vertexRank);
                if (result != 0) {
                    return result;
                }
                result = firstMatch1.vertexRank - firstMatch2.vertexRank;
                if (result != 0) {
                    return result;
                }
                return firstMatch1.token - firstMatch2.token;
            }
        };
    }

    public SortedSet<SortedSet<VertexMatch.WithTokenIndex>> findMaximalUniqueMatches() {
        ArrayList<SortedSet<VertexMatch.WithTokenIndex>> allMatches = new ArrayList<SortedSet<VertexMatch.WithTokenIndex>>(this);
        TreeSet<SortedSet<VertexMatch.WithTokenIndex>> maximalUniqueMatches = new TreeSet<SortedSet<VertexMatch.WithTokenIndex>>(VertexMatch.setComparator());
        while (true) {
            Set nextMum = null;
            Set candidate = null;
            for (SortedSet sortedSet : allMatches) {
                if (candidate == null) continue;
                if (candidate.size() > sortedSet.size() || ((VertexMatch.WithTokenIndex)candidate.first()).token == ((VertexMatch.WithTokenIndex)sortedSet.first()).token) {
                    nextMum = candidate;
                    break;
                }
                candidate = sortedSet;
            }
            if (nextMum == null) {
                nextMum = allMatches.stream().findFirst().orElse(null);
            }
            if (nextMum == null) break;
            if (!maximalUniqueMatches.add((SortedSet<VertexMatch.WithTokenIndex>)nextMum)) {
                throw new IllegalStateException("Duplicate MUM");
            }
            BitSet rankFilter = new BitSet();
            BitSet bitSet = new BitSet();
            rankFilter.set(((VertexMatch.WithTokenIndex)nextMum.first()).vertexRank, ((VertexMatch.WithTokenIndex)nextMum.last()).vertexRank + 1);
            bitSet.set(((VertexMatch.WithTokenIndex)nextMum.first()).token, ((VertexMatch.WithTokenIndex)nextMum.last()).token + 1);
            allMatches.removeIf(VertexMatch.filter(rankFilter, bitSet));
        }
        return maximalUniqueMatches;
    }

    static class MatchThreadElement {
        final MatchThreadElement previous;
        final VariantGraph.Vertex vertex;
        final int vertexRank;
        final SuffixTree.Cursor cursor;

        MatchThreadElement(SuffixTree<Token> suffixTree) {
            this(null, null, -1, suffixTree.cursor());
        }

        MatchThreadElement(MatchThreadElement previous, VariantGraph.Vertex vertex, int vertexRank, SuffixTree.Cursor cursor) {
            this.previous = previous;
            this.vertex = vertex;
            this.vertexRank = vertexRank;
            this.cursor = cursor;
        }

        MatchThreadElement advance(VariantGraph.Vertex vertex, int vertexRank) {
            SuffixTree.Cursor next;
            Set<Token> tokens = vertex.tokens();
            if (!tokens.isEmpty() && (next = this.cursor.move(tokens.stream().findFirst().get())) != null) {
                return new MatchThreadElement(this, vertex, vertexRank, next);
            }
            return null;
        }

        List<MatchThreadElement> thread() {
            LinkedList<MatchThreadElement> thread = new LinkedList<MatchThreadElement>();
            MatchThreadElement current = this;
            while (current.vertex != null) {
                thread.addFirst(current);
                current = current.previous;
            }
            return thread;
        }

        public String toString() {
            return "[" + Arrays.asList(this.vertexRank, this.vertex, this.cursor.matchedClass()).stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
        }
    }
}

