/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.needlemanwunsch;

import eu.interedition.collatex.CollationAlgorithm;
import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.needlemanwunsch.NeedlemanWunschScorer;
import eu.interedition.collatex.util.VariantGraphRanking;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;

public class NeedlemanWunschAlgorithm
extends CollationAlgorithm.Base {
    private final Comparator<Token> comparator;
    private final NeedlemanWunschScorer<VariantGraph.Vertex[], Token> scorer = new NeedlemanWunschScorer<VariantGraph.Vertex[], Token>(){

        @Override
        public float score(VariantGraph.Vertex[] a, Token b) {
            return Arrays.stream(a).map(VariantGraph.Vertex::tokens).flatMap(Collection::stream).anyMatch(t -> NeedlemanWunschAlgorithm.this.comparator.compare(t, b) == 0) ? 1.0f : -1.0f;
        }

        @Override
        public float gap() {
            return -1.0f;
        }
    };

    public NeedlemanWunschAlgorithm(Comparator<Token> comparator) {
        this.comparator = comparator;
    }

    @Override
    public void collate(VariantGraph against, Iterable<Token> witness) {
        VariantGraph.Vertex[][] ranks = VariantGraphRanking.of(against).asArray();
        Token[] tokens = (Token[])StreamSupport.stream(witness.spliterator(), false).toArray(Token[]::new);
        HashMap<Token, VariantGraph.Vertex> alignments = new HashMap<Token, VariantGraph.Vertex>();
        block0: for (Map.Entry<VariantGraph.Vertex[], Token> alignment : NeedlemanWunschAlgorithm.align(ranks, tokens, this.scorer).entrySet()) {
            boolean aligned = false;
            Token token = alignment.getValue();
            for (VariantGraph.Vertex vertex : alignment.getKey()) {
                for (Token vertexToken : vertex.tokens()) {
                    if (this.comparator.compare(vertexToken, token) != 0) continue;
                    alignments.put(token, vertex);
                    aligned = true;
                    break;
                }
                if (aligned) continue block0;
            }
        }
        this.merge(against, witness, alignments);
    }

    public static <A, B> Map<A, B> align(A[] a, B[] b, NeedlemanWunschScorer<A, B> scorer) {
        HashMap<A, B> alignments = new HashMap<A, B>();
        float[][] matrix = new float[a.length + 1][b.length + 1];
        int ac = 0;
        int bc = 0;
        while (ac < a.length) {
            matrix[ac++][0] = scorer.gap() * (float)ac;
        }
        while (bc < b.length) {
            matrix[0][bc++] = scorer.gap() * (float)bc;
        }
        ac = 1;
        for (A aElement : a) {
            bc = 1;
            for (B bElement : b) {
                float k = matrix[ac - 1][bc - 1] + scorer.score(aElement, bElement);
                float l = matrix[ac - 1][bc] + scorer.gap();
                float m = matrix[ac][bc - 1] + scorer.gap();
                matrix[ac][bc++] = Math.max(Math.max(k, l), m);
            }
            ++ac;
        }
        ac = a.length;
        bc = b.length;
        while (ac > 0 && bc > 0) {
            float score = matrix[ac][bc];
            float scoreDiag = matrix[ac - 1][bc - 1];
            float scoreUp = matrix[ac][bc - 1];
            float scoreLeft = matrix[ac - 1][bc];
            if (score == scoreDiag + scorer.score(a[ac - 1], b[bc - 1])) {
                alignments.put(a[ac - 1], b[bc - 1]);
                --ac;
                --bc;
                continue;
            }
            if (score == scoreLeft + scorer.gap()) {
                --ac;
                continue;
            }
            if (score != scoreUp + scorer.gap()) continue;
            --bc;
        }
        return alignments;
    }
}

