/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.simple;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.simple.SimpleWitness;
import eu.interedition.collatex.util.VertexMatch;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class SimpleToken
implements Token,
Comparable<SimpleToken> {
    private final SimpleWitness witness;
    private final String content;
    private final String normalized;
    public static final Function<SortedSet<VertexMatch.WithToken>, Integer> TOKEN_MATCH_EVALUATOR = input -> {
        int value = 0;
        for (VertexMatch.WithToken match : input) {
            value += ((SimpleToken)match.token).getContent().length();
        }
        return value;
    };

    public SimpleToken(SimpleWitness witness, String content, String normalized) {
        this.witness = witness;
        this.content = content;
        this.normalized = normalized;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public Witness getWitness() {
        return this.witness;
    }

    public String getNormalized() {
        return this.normalized;
    }

    public String toString() {
        return this.witness.toString() + ":" + this.witness.getTokens().indexOf(this) + ":'" + this.normalized + "'";
    }

    public static String toString(Iterable<? extends Token> tokens) {
        return StreamSupport.stream(tokens.spliterator(), false).filter(t -> SimpleToken.class.isAssignableFrom(t.getClass())).map(t -> (SimpleToken)t).map(SimpleToken::getContent).collect(Collectors.joining()).trim();
    }

    @Override
    public int compareTo(SimpleToken o) {
        return this.witness.compare(this, o);
    }
}

