/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.simple;

import java.util.function.Function;

public class SimpleTokenNormalizers {
    public static final Function<String, String> LOWER_CASE = String::toLowerCase;
    public static final Function<String, String> TRIM_WS = String::trim;
    public static final Function<String, String> TRIM_WS_PUNCT = input -> {
        int start;
        int end = input.length() - 1;
        for (start = 0; start <= end && SimpleTokenNormalizers.isWhitespaceOrPunctuation(input.charAt(start)); ++start) {
        }
        while (end >= start && SimpleTokenNormalizers.isWhitespaceOrPunctuation(input.charAt(end))) {
            --end;
        }
        return input.substring(start, end + 1);
    };
    public static final Function<String, String> LC_TRIM_WS_PUNCT = LOWER_CASE.andThen(TRIM_WS_PUNCT);
    public static final Function<String, String> LC_TRIM_WS = LOWER_CASE.andThen(TRIM_WS);

    public static boolean isWhitespaceOrPunctuation(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        switch (Character.getType(c)) {
            case 21: 
            case 22: 
            case 24: {
                return true;
            }
        }
        return false;
    }
}

