/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.simple;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.dekker.Tuple;
import eu.interedition.collatex.simple.SimpleToken;
import eu.interedition.collatex.util.ParallelSegmentationApparatus;
import eu.interedition.collatex.util.VariantGraphRanking;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SimpleVariantGraphSerializer {
    protected static final String COLLATEX_NS = "http://interedition.eu/collatex/ns/1.0";
    protected static final String TEI_NS = "http://www.tei-c.org/ns/1.0";
    private final VariantGraph graph;
    private final Function<Iterable<Token>, String> tokensToString;
    private final Map<VariantGraph.Vertex, Integer> vertexIds = new HashMap<VariantGraph.Vertex, Integer>();
    private VariantGraphRanking ranking;
    static final Pattern CSV_SPECIAL_CHARS = Pattern.compile("[\r\n\",]");
    private static final String NODE_TAG = "node";
    private static final String TARGET_ATT = "target";
    private static final String SOURCE_ATT = "source";
    private static final String EDGE_TAG = "edge";
    private static final String EDGE_TYPE_PATH = "path";
    private static final String EDGE_TYPE_TRANSPOSITION = "transposition";
    private static final String EDGEDEFAULT_DEFAULT_VALUE = "directed";
    private static final String EDGEDEFAULT_ATT = "edgedefault";
    private static final String GRAPH_ID = "g0";
    private static final String GRAPH_TAG = "graph";
    private static final String GRAPHML_NS = "http://graphml.graphdrawing.org/xmlns";
    private static final String GRAPHML_TAG = "graphml";
    private static final String XMLNSXSI_ATT = "xmlns:xsi";
    private static final String XSISL_ATT = "xsi:schemaLocation";
    private static final String GRAPHML_XMLNSXSI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String GRAPHML_XSISL = "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd";
    private static final String PARSENODEIDS_ATT = "parse.nodeids";
    private static final String PARSENODEIDS_DEFAULT_VALUE = "canonical";
    private static final String PARSEEDGEIDS_ATT = "parse.edgeids";
    private static final String PARSEEDGEIDS_DEFAULT_VALUE = "canonical";
    private static final String PARSEORDER_ATT = "parse.order";
    private static final String PARSEORDER_DEFAULT_VALUE = "nodesfirst";
    private static final String ATTR_TYPE_ATT = "attr.type";
    private static final String ATTR_NAME_ATT = "attr.name";
    private static final String FOR_ATT = "for";
    private static final String ID_ATT = "id";
    private static final String KEY_TAG = "key";
    private static final String DATA_TAG = "data";
    final Function<VariantGraph.Vertex, String> vertexToString = new Function<VariantGraph.Vertex, String>(){

        @Override
        public String apply(VariantGraph.Vertex input) {
            return input.witnesses().stream().findFirst().map(witness -> (String)SimpleVariantGraphSerializer.this.tokensToString.apply(Arrays.asList(input.tokens().stream().filter(t -> witness.equals(t.getWitness())).toArray(Token[]::new)))).orElse("");
        }
    };
    static final Function<Iterable<Token>, String> SIMPLE_TOKEN_TO_STRING = input -> StreamSupport.stream(input.spliterator(), false).filter(t -> SimpleToken.class.isAssignableFrom(t.getClass())).map(t -> (SimpleToken)t).sorted().map(SimpleToken::getContent).collect(Collectors.joining());

    public SimpleVariantGraphSerializer(VariantGraph graph) {
        this(graph, SIMPLE_TOKEN_TO_STRING);
    }

    public SimpleVariantGraphSerializer(VariantGraph graph, Function<Iterable<Token>, String> tokensToString) {
        this.graph = graph;
        this.tokensToString = tokensToString;
    }

    public void toTEI(final XMLStreamWriter xml) throws XMLStreamException {
        try {
            ParallelSegmentationApparatus.generate(this.ranking(), new ParallelSegmentationApparatus.GeneratorCallback(){

                @Override
                public void start() {
                    try {
                        xml.writeStartElement("cx", "apparatus", SimpleVariantGraphSerializer.COLLATEX_NS);
                        xml.writeNamespace("cx", SimpleVariantGraphSerializer.COLLATEX_NS);
                        xml.writeNamespace("", SimpleVariantGraphSerializer.TEI_NS);
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void segment(SortedMap<Witness, Iterable<Token>> contents) {
                    LinkedHashMap segments = new LinkedHashMap();
                    contents.forEach((witness, tokens) -> segments.computeIfAbsent(((String)SimpleVariantGraphSerializer.this.tokensToString.apply(tokens)).trim(), k -> new HashSet()).add(witness));
                    Set segmentContents = segments.keySet();
                    try {
                        if (segmentContents.size() == 1) {
                            xml.writeCharacters((String)segmentContents.stream().findFirst().get());
                        } else {
                            xml.writeStartElement("", "app", SimpleVariantGraphSerializer.TEI_NS);
                            for (String segment : segmentContents) {
                                StringBuilder witnesses = new StringBuilder();
                                for (Witness witness2 : (Set)segments.get(segment)) {
                                    witnesses.append(witness2.getSigil()).append(" ");
                                }
                                if (segment.length() == 0) {
                                    xml.writeEmptyElement("", "rdg", SimpleVariantGraphSerializer.TEI_NS);
                                } else {
                                    xml.writeStartElement("", "rdg", SimpleVariantGraphSerializer.TEI_NS);
                                }
                                xml.writeAttribute("wit", witnesses.toString().trim());
                                if (segment.length() <= 0) continue;
                                xml.writeCharacters(segment);
                                xml.writeEndElement();
                            }
                            xml.writeEndElement();
                        }
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void end() {
                    try {
                        xml.writeEndElement();
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException re) {
            RuntimeException rootCause = re;
            for (Throwable cause = re; cause != null; cause = cause.getCause()) {
                rootCause = cause;
            }
            if (rootCause instanceof XMLStreamException) {
                throw (XMLStreamException)((Object)rootCause);
            }
            throw re;
        }
    }

    public void toCsv(final Writer out) throws IOException {
        try {
            ParallelSegmentationApparatus.generate(this.ranking(), new ParallelSegmentationApparatus.GeneratorCallback(){

                @Override
                public void start() {
                    try {
                        Iterator it = SimpleVariantGraphSerializer.this.graph.witnesses().stream().sorted(Witness.SIGIL_COMPARATOR).iterator();
                        while (it.hasNext()) {
                            out.write(SimpleVariantGraphSerializer.escapeCsvField(((Witness)it.next()).getSigil()));
                            if (!it.hasNext()) continue;
                            out.write(",");
                        }
                        out.write("\r\n");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void segment(SortedMap<Witness, Iterable<Token>> contents) {
                    try {
                        Iterator<Witness> witnessIt = contents.keySet().iterator();
                        while (witnessIt.hasNext()) {
                            out.write(SimpleVariantGraphSerializer.escapeCsvField((String)SimpleVariantGraphSerializer.this.tokensToString.apply(contents.getOrDefault(witnessIt.next(), Collections.emptySet()))));
                            if (!witnessIt.hasNext()) continue;
                            out.write(",");
                        }
                        out.write("\r\n");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void end() {
                }
            });
        }
        catch (Throwable t) {
            for (Throwable cause = t; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof IOException)) continue;
                throw (IOException)cause;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    static String escapeCsvField(String content) {
        return CSV_SPECIAL_CHARS.matcher(content).find() ? "\"" + content.replaceAll("\"", "\"\"") + "\"" : content;
    }

    public void toDot(Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        String indent = "  ";
        String connector = " -> ";
        out.println("digraph G {");
        for (VariantGraph.Vertex vertex : this.graph.vertices()) {
            out.print("  " + this.id(vertex));
            out.print(" [label = \"" + this.toDotLabel(vertex) + "\"]");
            out.println(";");
        }
        for (VariantGraph.Vertex vertex : this.graph.vertices()) {
            for (Map.Entry<VariantGraph.Vertex, Set<Witness>> e : vertex.outgoing().entrySet()) {
                out.print("  " + this.id(vertex) + " -> " + this.id(e.getKey()));
                out.print(" [label = \"" + this.toDotLabel(e.getValue()) + "\"]");
                out.println(";");
            }
        }
        for (Tuple tuple : this.transposedTuples()) {
            String leftId = this.id((VariantGraph.Vertex)tuple.left);
            String rightId = this.id((VariantGraph.Vertex)tuple.right);
            out.print("  " + leftId + " -> " + rightId);
            out.print(" [ color = \"lightgray\", style = \"dashed\" arrowhead = \"none\", arrowtail = \"none\" ]");
            out.println(";");
        }
        out.print("  " + this.id(this.graph.getStart()) + " -> " + this.id(this.graph.getEnd()));
        out.print(" [color =  \"white\"]");
        out.println(";");
        out.println("}");
        out.flush();
    }

    private String id(VariantGraph.Vertex vertex) {
        return "v" + this.numericId(vertex);
    }

    private int numericId(VariantGraph.Vertex vertex) {
        Integer id = this.vertexIds.get(vertex);
        if (id == null) {
            id = this.vertexIds.size();
            this.vertexIds.put(vertex, id);
        }
        return id;
    }

    String toDotLabel(Set<Witness> e) {
        return SimpleVariantGraphSerializer.escapeDotLabel(e.stream().map(Witness::getSigil).distinct().sorted().collect(Collectors.joining(", ")));
    }

    String toDotLabel(VariantGraph.Vertex v) {
        return SimpleVariantGraphSerializer.escapeDotLabel(this.vertexToString.apply(v));
    }

    static String escapeDotLabel(String string) {
        return string.replaceAll("\"", "\\\\\"").replaceAll("[\n\r]+", "\u00b6");
    }

    VariantGraphRanking ranking() {
        if (this.ranking == null) {
            this.ranking = VariantGraphRanking.of(this.graph);
        }
        return this.ranking;
    }

    Set<Tuple<VariantGraph.Vertex>> transposedTuples() {
        HashSet<Tuple<VariantGraph.Vertex>> tuples = new HashSet<Tuple<VariantGraph.Vertex>>();
        Comparator<VariantGraph.Vertex> vertexOrdering = this.ranking().comparator();
        for (Set<VariantGraph.Vertex> transposition : this.graph.transpositions()) {
            TreeMap<Witness, SortedSet> verticesByWitness = new TreeMap<Witness, SortedSet>(Witness.SIGIL_COMPARATOR);
            for (VariantGraph.Vertex vertex : transposition) {
                for (Witness witness : vertex.witnesses()) {
                    verticesByWitness.computeIfAbsent(witness, w -> new TreeSet(vertexOrdering)).add(vertex);
                }
            }
            Witness prev = null;
            for (Witness witness : verticesByWitness.keySet()) {
                if (prev != null) {
                    Iterator prevIt = ((SortedSet)verticesByWitness.get(prev)).iterator();
                    Iterator nextIt = ((SortedSet)verticesByWitness.get(witness)).iterator();
                    while (prevIt.hasNext() && nextIt.hasNext()) {
                        VariantGraph.Vertex nextVertex;
                        VariantGraph.Vertex prevVertex = (VariantGraph.Vertex)prevIt.next();
                        if (prevVertex.equals(nextVertex = (VariantGraph.Vertex)nextIt.next())) continue;
                        tuples.add(new Tuple<VariantGraph.Vertex>(prevVertex, nextVertex));
                    }
                }
                prev = witness;
            }
        }
        return tuples;
    }

    public void toGraphML(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeStartElement("", GRAPHML_TAG, GRAPHML_NS);
        xml.writeNamespace("", GRAPHML_NS);
        xml.writeAttribute(XMLNSXSI_ATT, GRAPHML_XMLNSXSI);
        xml.writeAttribute(XSISL_ATT, GRAPHML_XSISL);
        for (GraphMLProperty graphMLProperty : GraphMLProperty.values()) {
            graphMLProperty.declare(xml);
        }
        xml.writeStartElement(GRAPHML_NS, GRAPH_TAG);
        xml.writeAttribute(ID_ATT, GRAPH_ID);
        xml.writeAttribute(EDGEDEFAULT_ATT, EDGEDEFAULT_DEFAULT_VALUE);
        xml.writeAttribute(PARSENODEIDS_ATT, "canonical");
        xml.writeAttribute(PARSEEDGEIDS_ATT, "canonical");
        xml.writeAttribute(PARSEORDER_ATT, PARSEORDER_DEFAULT_VALUE);
        VariantGraphRanking ranking = this.ranking();
        for (VariantGraph.Vertex vertex : this.graph.vertices()) {
            int n = this.numericId(vertex);
            xml.writeStartElement(GRAPHML_NS, NODE_TAG);
            xml.writeAttribute(ID_ATT, "n" + n);
            GraphMLProperty.NODE_NUMBER.write(Integer.toString(n), xml);
            GraphMLProperty.NODE_RANK.write(Integer.toString(ranking.apply(vertex)), xml);
            GraphMLProperty.NODE_TOKEN.write(this.vertexToString.apply(vertex), xml);
            xml.writeEndElement();
        }
        int edgeNumber = 0;
        for (VariantGraph.Vertex vertex : this.graph.vertices()) {
            for (Map.Entry<VariantGraph.Vertex, Set<Witness>> edge : vertex.outgoing().entrySet()) {
                xml.writeStartElement(GRAPHML_NS, EDGE_TAG);
                xml.writeAttribute(ID_ATT, "e" + edgeNumber);
                xml.writeAttribute(SOURCE_ATT, "n" + this.numericId(vertex));
                xml.writeAttribute(TARGET_ATT, "n" + this.numericId(edge.getKey()));
                GraphMLProperty.EDGE_NUMBER.write(Integer.toString(edgeNumber++), xml);
                GraphMLProperty.EDGE_TYPE.write(EDGE_TYPE_PATH, xml);
                GraphMLProperty.EDGE_WITNESSES.write(edge.getValue().stream().map(Witness::getSigil).distinct().sorted().collect(Collectors.joining(", ")), xml);
                xml.writeEndElement();
            }
        }
        for (Tuple tuple : this.transposedTuples()) {
            xml.writeStartElement(GRAPHML_NS, EDGE_TAG);
            xml.writeAttribute(ID_ATT, "e" + edgeNumber);
            xml.writeAttribute(SOURCE_ATT, "n" + this.numericId((VariantGraph.Vertex)tuple.left));
            xml.writeAttribute(TARGET_ATT, "n" + this.numericId((VariantGraph.Vertex)tuple.right));
            GraphMLProperty.EDGE_NUMBER.write(Integer.toString(edgeNumber++), xml);
            GraphMLProperty.EDGE_TYPE.write(EDGE_TYPE_TRANSPOSITION, xml);
            xml.writeEndElement();
        }
        xml.writeEndElement();
        xml.writeEndElement();
    }

    private static enum GraphMLProperty {
        NODE_NUMBER("node", "number", "int"),
        NODE_TOKEN("node", "tokens", "string"),
        NODE_RANK("node", "rank", "int"),
        EDGE_NUMBER("edge", "number", "int"),
        EDGE_TYPE("edge", "type", "string"),
        EDGE_WITNESSES("edge", "witnesses", "string");

        private String name;
        private String forElement;
        private String type;

        private GraphMLProperty(String forElement, String name, String type) {
            this.name = name;
            this.forElement = forElement;
            this.type = type;
        }

        public void write(String data, XMLStreamWriter xml) throws XMLStreamException {
            xml.writeStartElement(SimpleVariantGraphSerializer.GRAPHML_NS, SimpleVariantGraphSerializer.DATA_TAG);
            xml.writeAttribute(SimpleVariantGraphSerializer.KEY_TAG, "d" + this.ordinal());
            xml.writeCharacters(data);
            xml.writeEndElement();
        }

        public void declare(XMLStreamWriter xml) throws XMLStreamException {
            xml.writeEmptyElement(SimpleVariantGraphSerializer.GRAPHML_NS, SimpleVariantGraphSerializer.KEY_TAG);
            xml.writeAttribute(SimpleVariantGraphSerializer.ID_ATT, "d" + this.ordinal());
            xml.writeAttribute(SimpleVariantGraphSerializer.FOR_ATT, this.forElement);
            xml.writeAttribute(SimpleVariantGraphSerializer.ATTR_NAME_ATT, this.name);
            xml.writeAttribute(SimpleVariantGraphSerializer.ATTR_TYPE_ATT, this.type);
        }
    }
}

