/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixarray;

import eu.interedition.collatex.suffixarray.ISuffixArrayBuilder;
import eu.interedition.collatex.suffixarray.MinMax;
import eu.interedition.collatex.suffixarray.Tools;

public final class DivSufSort
implements ISuffixArrayBuilder {
    private static final int DEFAULT_ALPHABET_SIZE = 256;
    private static final int SS_INSERTIONSORT_THRESHOLD = 8;
    private static final int SS_BLOCKSIZE = 1024;
    private static final int SS_MISORT_STACKSIZE = 16;
    private static final int SS_SMERGE_STACKSIZE = 32;
    private static final int TR_STACKSIZE = 64;
    private static final int TR_INSERTIONSORT_THRESHOLD = 8;
    private static final int[] sqq_table = new int[]{0, 16, 22, 27, 32, 35, 39, 42, 45, 48, 50, 53, 55, 57, 59, 61, 64, 65, 67, 69, 71, 73, 75, 76, 78, 80, 81, 83, 84, 86, 87, 89, 90, 91, 93, 94, 96, 97, 98, 99, 101, 102, 103, 104, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153, 154, 155, 155, 156, 157, 158, 159, 160, 160, 161, 162, 163, 163, 164, 165, 166, 167, 167, 168, 169, 170, 170, 171, 172, 173, 173, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181, 181, 182, 183, 183, 184, 185, 185, 186, 187, 187, 188, 189, 189, 190, 191, 192, 192, 193, 193, 194, 195, 195, 196, 197, 197, 198, 199, 199, 200, 201, 201, 202, 203, 203, 204, 204, 205, 206, 206, 207, 208, 208, 209, 209, 210, 211, 211, 212, 212, 213, 214, 214, 215, 215, 216, 217, 217, 218, 218, 219, 219, 220, 221, 221, 222, 222, 223, 224, 224, 225, 225, 226, 226, 227, 227, 228, 229, 229, 230, 230, 231, 231, 232, 232, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 255};
    private static final int[] lg_table = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private final int ALPHABET_SIZE;
    private final int BUCKET_A_SIZE;
    private final int BUCKET_B_SIZE;
    private int[] SA;
    private int[] T;
    private int start;

    public DivSufSort() {
        this.BUCKET_A_SIZE = this.ALPHABET_SIZE = 256;
        this.BUCKET_B_SIZE = this.ALPHABET_SIZE * this.ALPHABET_SIZE;
    }

    public DivSufSort(int alphabetSize) {
        this.BUCKET_A_SIZE = this.ALPHABET_SIZE = alphabetSize;
        this.BUCKET_B_SIZE = this.ALPHABET_SIZE * this.ALPHABET_SIZE;
    }

    @Override
    public final int[] buildSuffixArray(int[] input, int start, int length) {
        Tools.assertAlways(input != null, "input must not be null");
        Tools.assertAlways(length >= 2, "input length must be >= 2");
        MinMax mm = Tools.minmax(input, start, length);
        Tools.assertAlways(mm.min >= 0, "input must not be negative");
        Tools.assertAlways(mm.max < this.ALPHABET_SIZE, "max alphabet size is " + this.ALPHABET_SIZE);
        int[] ret = new int[length];
        this.SA = ret;
        this.T = input;
        int[] bucket_A = new int[this.BUCKET_A_SIZE];
        int[] bucket_B = new int[this.BUCKET_B_SIZE];
        this.start = start;
        int m = this.sortTypeBstar(bucket_A, bucket_B, length);
        this.constructSuffixArray(bucket_A, bucket_B, length, m);
        return ret;
    }

    private final void constructSuffixArray(int[] bucket_A, int[] bucket_B, int n, int m) {
        int c0;
        int s;
        int j;
        int c2;
        int k;
        int i;
        if (0 < m) {
            for (int c1 = this.ALPHABET_SIZE - 2; 0 <= c1; --c1) {
                i = bucket_B[c1 * this.ALPHABET_SIZE + (c1 + 1)];
                k = 0;
                c2 = -1;
                for (j = bucket_A[c1 + 1] - 1; i <= j; --j) {
                    s = this.SA[j];
                    if (0 < s) {
                        this.SA[j] = ~s;
                        c0 = this.T[this.start + --s];
                        if (0 < s && this.T[this.start + s - 1] > c0) {
                            s ^= 0xFFFFFFFF;
                        }
                        if (c0 != c2) {
                            if (0 <= c2) {
                                bucket_B[c1 * this.ALPHABET_SIZE + c2] = k;
                            }
                            c2 = c0;
                            k = bucket_B[c1 * this.ALPHABET_SIZE + c2];
                        }
                        this.SA[k--] = s;
                        continue;
                    }
                    this.SA[j] = ~s;
                }
            }
        }
        c2 = this.T[this.start + n - 1];
        k = bucket_A[c2];
        this.SA[k++] = this.T[this.start + n - 2] < c2 ? ~(n - 1) : n - 1;
        j = n;
        for (i = 0; i < j; ++i) {
            s = this.SA[i];
            if (0 < s) {
                c0 = this.T[this.start + --s];
                if (s == 0 || this.T[this.start + s - 1] < c0) {
                    s ^= 0xFFFFFFFF;
                }
                if (c0 != c2) {
                    bucket_A[c2] = k;
                    c2 = c0;
                    k = bucket_A[c2];
                }
                this.SA[k++] = s;
                continue;
            }
            this.SA[i] = ~s;
        }
    }

    private final int sortTypeBstar(int[] bucket_A, int[] bucket_B, int n) {
        int t;
        int c1 = 0;
        int i = n - 1;
        int m = n;
        int c0 = this.T[this.start + n - 1];
        while (0 <= i) {
            do {
                c1 = c0;
                bucket_A[c1] = bucket_A[c1] + 1;
            } while (0 <= --i && (c0 = this.T[this.start + i]) >= c1);
            if (0 > i) continue;
            int n2 = c0 * this.ALPHABET_SIZE + c1;
            bucket_B[n2] = bucket_B[n2] + 1;
            this.SA[--m] = i--;
            c1 = c0;
            while (0 <= i && (c0 = this.T[this.start + i]) <= c1) {
                int n3 = c1 * this.ALPHABET_SIZE + c0;
                bucket_B[n3] = bucket_B[n3] + 1;
                --i;
                c1 = c0;
            }
        }
        m = n - m;
        i = 0;
        int j = 0;
        for (c0 = 0; c0 < this.ALPHABET_SIZE; ++c0) {
            t = i + bucket_A[c0];
            bucket_A[c0] = i + j;
            i = t + bucket_B[c0 * this.ALPHABET_SIZE + c0];
            for (c1 = c0 + 1; c1 < this.ALPHABET_SIZE; ++c1) {
                bucket_B[c0 * this.ALPHABET_SIZE + c1] = j += bucket_B[c0 * this.ALPHABET_SIZE + c1];
                i += bucket_B[c1 * this.ALPHABET_SIZE + c0];
            }
        }
        if (0 < m) {
            int PAb = n - m;
            int ISAb = m;
            i = m - 2;
            while (0 <= i) {
                t = this.SA[PAb + i];
                c0 = this.T[this.start + t];
                c1 = this.T[this.start + t + 1];
                int n4 = c0 * this.ALPHABET_SIZE + c1;
                int n5 = bucket_B[n4] - 1;
                bucket_B[n4] = n5;
                this.SA[n5] = i--;
            }
            t = this.SA[PAb + m - 1];
            c0 = this.T[this.start + t];
            c1 = this.T[this.start + t + 1];
            int n6 = c0 * this.ALPHABET_SIZE + c1;
            int n7 = bucket_B[n6] - 1;
            bucket_B[n6] = n7;
            this.SA[n7] = m - 1;
            int buf = m;
            int bufsize = n - 2 * m;
            c0 = this.ALPHABET_SIZE - 2;
            j = m;
            while (0 < j) {
                for (c1 = this.ALPHABET_SIZE - 1; c0 < c1; --c1) {
                    i = bucket_B[c0 * this.ALPHABET_SIZE + c1];
                    if (1 < j - i) {
                        this.ssSort(PAb, i, j, buf, bufsize, 2, n, this.SA[i] == m - 1);
                    }
                    j = i;
                }
                --c0;
            }
            for (i = m - 1; 0 <= i; --i) {
                if (0 <= this.SA[i]) {
                    j = i;
                    do {
                        this.SA[ISAb + this.SA[i]] = i;
                    } while (0 <= --i && 0 <= this.SA[i]);
                    this.SA[i + 1] = i - j;
                    if (i <= 0) break;
                }
                j = i;
                do {
                    this.SA[i] = ~this.SA[i];
                    this.SA[ISAb + this.SA[i]] = j;
                } while (this.SA[--i] < 0);
                this.SA[ISAb + this.SA[i]] = j;
            }
            this.trSort(ISAb, m, 1);
            i = n - 1;
            j = m;
            c0 = this.T[this.start + n - 1];
            while (0 <= i) {
                --i;
                c1 = c0;
                while (0 <= i && (c0 = this.T[this.start + i]) >= c1) {
                    --i;
                    c1 = c0;
                }
                if (0 > i) continue;
                t = i--;
                c1 = c0;
                while (0 <= i && (c0 = this.T[this.start + i]) <= c1) {
                    --i;
                    c1 = c0;
                }
                this.SA[this.SA[ISAb + --j]] = t == 0 || 1 < t - i ? t : ~t;
            }
            bucket_B[(this.ALPHABET_SIZE - 1) * this.ALPHABET_SIZE + (this.ALPHABET_SIZE - 1)] = n;
            int k = m - 1;
            for (c0 = this.ALPHABET_SIZE - 2; 0 <= c0; --c0) {
                i = bucket_A[c0 + 1] - 1;
                for (c1 = this.ALPHABET_SIZE - 1; c0 < c1; --c1) {
                    t = i - bucket_B[c1 * this.ALPHABET_SIZE + c0];
                    bucket_B[c1 * this.ALPHABET_SIZE + c0] = i;
                    i = t;
                    j = bucket_B[c0 * this.ALPHABET_SIZE + c1];
                    while (j <= k) {
                        this.SA[i] = this.SA[k];
                        --i;
                        --k;
                    }
                }
                bucket_B[c0 * this.ALPHABET_SIZE + (c0 + 1)] = i - bucket_B[c0 * this.ALPHABET_SIZE + c0] + 1;
                bucket_B[c0 * this.ALPHABET_SIZE + c0] = i;
            }
        }
        return m;
    }

    private final void ssSort(int PA, int first, int last, int buf, int bufsize, int depth, int n, boolean lastsuffix) {
        int k;
        int middle;
        int limit;
        if (lastsuffix) {
            ++first;
        }
        if (bufsize < 1024 && bufsize < last - first && bufsize < (limit = DivSufSort.ssIsqrt(last - first))) {
            if (1024 < limit) {
                limit = 1024;
            }
            buf = middle = last - limit;
            bufsize = limit;
        } else {
            middle = last;
            limit = 0;
        }
        int a = first;
        int i = 0;
        while (1024 < middle - a) {
            this.ssMintroSort(PA, a, a + 1024, depth);
            int curbufsize = last - (a + 1024);
            int curbuf = a + 1024;
            if (curbufsize <= bufsize) {
                curbufsize = bufsize;
                curbuf = buf;
            }
            int b = a;
            k = 1024;
            int j = i;
            while ((j & 1) != 0) {
                this.ssSwapMerge(PA, b - k, b, b + k, curbuf, curbufsize, depth);
                b -= k;
                k <<= 1;
                j >>= 1;
            }
            a += 1024;
            ++i;
        }
        this.ssMintroSort(PA, a, middle, depth);
        k = 1024;
        while (i != 0) {
            if (i & true) {
                this.ssSwapMerge(PA, a - k, a, middle, buf, bufsize, depth);
                a -= k;
            }
            k <<= 1;
            i >>= 1;
        }
        if (limit != 0) {
            this.ssMintroSort(PA, middle, last, depth);
            this.ssInplaceMerge(PA, first, middle, last, depth);
        }
        if (lastsuffix) {
            int p1 = this.SA[PA + this.SA[first - 1]];
            int p11 = n - 2;
            i = this.SA[first - 1];
            for (a = first; a < last && (this.SA[a] < 0 || 0 < this.ssCompare(p1, p11, PA + this.SA[a], depth)); ++a) {
                this.SA[a - 1] = this.SA[a];
            }
            this.SA[a - 1] = i;
        }
    }

    private final int ssCompare(int pa, int pb, int p2, int depth) {
        int U2;
        int U1 = depth + pa;
        int U1n = pb + 2;
        int U2n = this.SA[p2 + 1] + 2;
        for (U2 = depth + this.SA[p2]; U1 < U1n && U2 < U2n && this.T[this.start + U1] == this.T[this.start + U2]; ++U1, ++U2) {
        }
        return U1 < U1n ? (U2 < U2n ? this.T[this.start + U1] - this.T[this.start + U2] : 1) : (U2 < U2n ? -1 : 0);
    }

    private final int ssCompare(int p1, int p2, int depth) {
        int U2;
        int U1 = depth + this.SA[p1];
        int U1n = this.SA[p1 + 1] + 2;
        int U2n = this.SA[p2 + 1] + 2;
        for (U2 = depth + this.SA[p2]; U1 < U1n && U2 < U2n && this.T[this.start + U1] == this.T[this.start + U2]; ++U1, ++U2) {
        }
        return U1 < U1n ? (U2 < U2n ? this.T[this.start + U1] - this.T[this.start + U2] : 1) : (U2 < U2n ? -1 : 0);
    }

    private final void ssInplaceMerge(int PA, int first, int middle, int last, int depth) {
        do {
            int p;
            boolean x;
            if (this.SA[last - 1] < 0) {
                x = true;
                p = PA + ~this.SA[last - 1];
            } else {
                x = false;
                p = PA + this.SA[last - 1];
            }
            int a = first;
            int len = middle - first;
            int half = len >> 1;
            int r = -1;
            while (0 < len) {
                int b = a + half;
                int q = this.ssCompare(PA + (0 <= this.SA[b] ? this.SA[b] : ~this.SA[b]), p, depth);
                if (q < 0) {
                    a = b + 1;
                    half -= len & 1 ^ 1;
                } else {
                    r = q;
                }
                len = half;
                half >>= 1;
            }
            if (a < middle) {
                if (r == 0) {
                    this.SA[a] = ~this.SA[a];
                }
                this.ssRotate(a, middle, last);
                last -= middle - a;
                middle = a;
                if (first == middle) break;
            }
            --last;
            if (!x) continue;
            while (this.SA[--last] < 0) {
            }
        } while (middle != last);
    }

    private final void ssRotate(int first, int middle, int last) {
        int l = middle - first;
        int r = last - middle;
        block0: while (0 < l && 0 < r) {
            int t;
            int b;
            int a;
            if (l == r) {
                this.ssBlockSwap(first, middle, l);
                break;
            }
            if (l < r) {
                a = last - 1;
                b = middle - 1;
                t = this.SA[a];
                while (true) {
                    this.SA[a--] = this.SA[b];
                    this.SA[b--] = this.SA[a];
                    if (b >= first) continue;
                    this.SA[a] = t;
                    last = a--;
                    if ((r -= l + 1) <= l) continue block0;
                    b = middle - 1;
                    t = this.SA[a];
                }
            }
            a = first;
            b = middle;
            t = this.SA[a];
            while (true) {
                this.SA[a++] = this.SA[b];
                this.SA[b++] = this.SA[a];
                if (last > b) continue;
                this.SA[a] = t;
                first = a + 1;
                if ((l -= r + 1) <= r) continue block0;
                b = middle;
                t = this.SA[++a];
            }
        }
    }

    private final void ssBlockSwap(int a, int b, int n) {
        while (0 < n) {
            int t = this.SA[a];
            this.SA[a] = this.SA[b];
            this.SA[b] = t;
            --n;
            ++a;
            ++b;
        }
    }

    private static final int getIDX(int a) {
        return 0 <= a ? a : ~a;
    }

    private static final int min(int a, int b) {
        return a < b ? a : b;
    }

    private final void ssSwapMerge(int PA, int first, int middle, int last, int buf, int bufsize, int depth) {
        int STACK_SIZE = 32;
        StackElement[] stack = new StackElement[32];
        int check = 0;
        int ssize = 0;
        while (true) {
            StackElement se;
            if (last - middle <= bufsize) {
                if (first < middle && middle < last) {
                    this.ssMergeBackward(PA, first, middle, last, buf, depth);
                }
                if (check & true || (check & 2) != 0 && this.ssCompare(PA + DivSufSort.getIDX(this.SA[first - 1]), PA + this.SA[first], depth) == 0) {
                    this.SA[first] = ~this.SA[first];
                }
                if ((check & 4) != 0 && this.ssCompare(PA + DivSufSort.getIDX(this.SA[last - 1]), PA + this.SA[last], depth) == 0) {
                    this.SA[last] = ~this.SA[last];
                }
                if (ssize > 0) {
                    se = stack[--ssize];
                    first = se.a;
                    middle = se.b;
                    last = se.c;
                    check = se.d;
                    continue;
                }
                return;
            }
            if (middle - first <= bufsize) {
                if (first < middle) {
                    this.ssMergeForward(PA, first, middle, last, buf, depth);
                }
                if ((check & 1) != 0 || (check & 2) != 0 && this.ssCompare(PA + DivSufSort.getIDX(this.SA[first - 1]), PA + this.SA[first], depth) == 0) {
                    this.SA[first] = ~this.SA[first];
                }
                if ((check & 4) != 0 && this.ssCompare(PA + DivSufSort.getIDX(this.SA[last - 1]), PA + this.SA[last], depth) == 0) {
                    this.SA[last] = ~this.SA[last];
                }
                if (ssize > 0) {
                    se = stack[--ssize];
                    first = se.a;
                    middle = se.b;
                    last = se.c;
                    check = se.d;
                    continue;
                }
                return;
            }
            int m = 0;
            int len = DivSufSort.min(middle - first, last - middle);
            int half = len >> 1;
            while (0 < len) {
                if (this.ssCompare(PA + DivSufSort.getIDX(this.SA[middle + m + half]), PA + DivSufSort.getIDX(this.SA[middle - m - half - 1]), depth) < 0) {
                    m += half + 1;
                    half -= len & 1 ^ 1;
                }
                len = half;
                half >>= 1;
            }
            if (0 < m) {
                int r;
                int lm = middle - m;
                int rm = middle + m;
                this.ssBlockSwap(lm, middle, m);
                int l = r = middle;
                int next = 0;
                if (rm < last) {
                    if (this.SA[rm] < 0) {
                        this.SA[rm] = ~this.SA[rm];
                        if (first < lm) {
                            while (this.SA[--l] < 0) {
                            }
                            next |= 4;
                        }
                        next |= 1;
                    } else if (first < lm) {
                        while (this.SA[r] < 0) {
                            ++r;
                        }
                        next |= 2;
                    }
                }
                if (l - first <= last - r) {
                    stack[ssize++] = new StackElement(r, rm, last, next & 3 | check & 4);
                    middle = lm;
                    last = l;
                    check = check & 3 | next & 4;
                    continue;
                }
                if ((next & 2) != 0 && r == middle) {
                    next ^= 6;
                }
                stack[ssize++] = new StackElement(first, lm, l, check & 3 | next & 4);
                first = r;
                middle = rm;
                check = next & 3 | check & 4;
                continue;
            }
            if (this.ssCompare(PA + DivSufSort.getIDX(this.SA[middle - 1]), PA + this.SA[middle], depth) == 0) {
                this.SA[middle] = ~this.SA[middle];
            }
            if ((check & 1) != 0 || (check & 2) != 0 && this.ssCompare(PA + DivSufSort.getIDX(this.SA[first - 1]), PA + this.SA[first], depth) == 0) {
                this.SA[first] = ~this.SA[first];
            }
            if ((check & 4) != 0 && this.ssCompare(PA + DivSufSort.getIDX(this.SA[last - 1]), PA + this.SA[last], depth) == 0) {
                this.SA[last] = ~this.SA[last];
            }
            if (ssize <= 0) break;
            se = stack[--ssize];
            first = se.a;
            middle = se.b;
            last = se.c;
            check = se.d;
        }
    }

    private final void ssMergeForward(int PA, int first, int middle, int last, int buf, int depth) {
        int bufend = buf + (middle - first) - 1;
        this.ssBlockSwap(buf, first, middle - first);
        int a = first;
        int t = this.SA[a];
        int b = buf;
        int c = middle;
        while (true) {
            int r;
            if ((r = this.ssCompare(PA + this.SA[b], PA + this.SA[c], depth)) < 0) {
                do {
                    this.SA[a++] = this.SA[b];
                    if (bufend <= b) {
                        this.SA[bufend] = t;
                        return;
                    }
                    this.SA[b++] = this.SA[a];
                } while (this.SA[b] < 0);
                continue;
            }
            if (r > 0) {
                do {
                    this.SA[a++] = this.SA[c];
                    this.SA[c++] = this.SA[a];
                    if (last > c) continue;
                    while (b < bufend) {
                        this.SA[a++] = this.SA[b];
                        this.SA[b++] = this.SA[a];
                    }
                    this.SA[a] = this.SA[b];
                    this.SA[b] = t;
                    return;
                } while (this.SA[c] < 0);
                continue;
            }
            this.SA[c] = ~this.SA[c];
            do {
                this.SA[a++] = this.SA[b];
                if (bufend <= b) {
                    this.SA[bufend] = t;
                    return;
                }
                this.SA[b++] = this.SA[a];
            } while (this.SA[b] < 0);
            do {
                this.SA[a++] = this.SA[c];
                this.SA[c++] = this.SA[a];
                if (last > c) continue;
                while (b < bufend) {
                    this.SA[a++] = this.SA[b];
                    this.SA[b++] = this.SA[a];
                }
                this.SA[a] = this.SA[b];
                this.SA[b] = t;
                return;
            } while (this.SA[c] < 0);
        }
    }

    private final void ssMergeBackward(int PA, int first, int middle, int last, int buf, int depth) {
        int p2;
        int p1;
        int bufend = buf + (last - middle) - 1;
        this.ssBlockSwap(buf, middle, last - middle);
        int x = 0;
        if (this.SA[bufend] < 0) {
            p1 = PA + ~this.SA[bufend];
            x |= 1;
        } else {
            p1 = PA + this.SA[bufend];
        }
        if (this.SA[middle - 1] < 0) {
            p2 = PA + ~this.SA[middle - 1];
            x |= 2;
        } else {
            p2 = PA + this.SA[middle - 1];
        }
        int a = last - 1;
        int t = this.SA[a];
        int b = bufend;
        int c = middle - 1;
        while (true) {
            int r;
            if (0 < (r = this.ssCompare(p1, p2, depth))) {
                if ((x & 1) != 0) {
                    do {
                        this.SA[a--] = this.SA[b];
                        this.SA[b--] = this.SA[a];
                    } while (this.SA[b] < 0);
                    x ^= 1;
                }
                this.SA[a--] = this.SA[b];
                if (b <= buf) {
                    this.SA[buf] = t;
                    break;
                }
                this.SA[b--] = this.SA[a];
                if (this.SA[b] < 0) {
                    p1 = PA + ~this.SA[b];
                    x |= 1;
                    continue;
                }
                p1 = PA + this.SA[b];
                continue;
            }
            if (r < 0) {
                if ((x & 2) != 0) {
                    do {
                        this.SA[a--] = this.SA[c];
                        this.SA[c--] = this.SA[a];
                    } while (this.SA[c] < 0);
                    x ^= 2;
                }
                this.SA[a--] = this.SA[c];
                this.SA[c--] = this.SA[a];
                if (c < first) {
                    while (buf < b) {
                        this.SA[a--] = this.SA[b];
                        this.SA[b--] = this.SA[a];
                    }
                    this.SA[a] = this.SA[b];
                    this.SA[b] = t;
                    break;
                }
                if (this.SA[c] < 0) {
                    p2 = PA + ~this.SA[c];
                    x |= 2;
                    continue;
                }
                p2 = PA + this.SA[c];
                continue;
            }
            if ((x & 1) != 0) {
                do {
                    this.SA[a--] = this.SA[b];
                    this.SA[b--] = this.SA[a];
                } while (this.SA[b] < 0);
                x ^= 1;
            }
            this.SA[a--] = ~this.SA[b];
            if (b <= buf) {
                this.SA[buf] = t;
                break;
            }
            this.SA[b--] = this.SA[a];
            if ((x & 2) != 0) {
                do {
                    this.SA[a--] = this.SA[c];
                    this.SA[c--] = this.SA[a];
                } while (this.SA[c] < 0);
                x ^= 2;
            }
            this.SA[a--] = this.SA[c];
            this.SA[c--] = this.SA[a];
            if (c < first) {
                while (buf < b) {
                    this.SA[a--] = this.SA[b];
                    this.SA[b--] = this.SA[a];
                }
                this.SA[a] = this.SA[b];
                this.SA[b] = t;
                break;
            }
            if (this.SA[b] < 0) {
                p1 = PA + ~this.SA[b];
                x |= 1;
            } else {
                p1 = PA + this.SA[b];
            }
            if (this.SA[c] < 0) {
                p2 = PA + ~this.SA[c];
                x |= 2;
                continue;
            }
            p2 = PA + this.SA[c];
        }
    }

    private final void ssInsertionSort(int PA, int first, int last, int depth) {
        for (int i = last - 2; first <= i; --i) {
            int r;
            int t = this.SA[i];
            int j = i + 1;
            while (0 < (r = this.ssCompare(PA + t, PA + this.SA[j], depth))) {
                do {
                    this.SA[j - 1] = this.SA[j];
                } while (++j < last && this.SA[j] < 0);
                if (last > j) continue;
            }
            if (r == 0) {
                this.SA[j] = ~this.SA[j];
            }
            this.SA[j - 1] = t;
        }
    }

    private static final int ssIsqrt(int x) {
        int y;
        int e;
        if (x >= 0x100000) {
            return 1024;
        }
        int n = (x & 0xFFFF0000) != 0 ? ((x & 0xFF000000) != 0 ? 24 + lg_table[x >> 24 & 0xFF] : 16 + lg_table[x >> 16 & 0xFF]) : (e = (x & 0xFF00) != 0 ? 8 + lg_table[x >> 8 & 0xFF] : 0 + lg_table[x >> 0 & 0xFF]);
        if (e >= 16) {
            y = sqq_table[x >> e - 6 - (e & 1)] << (e >> 1) - 7;
            if (e >= 24) {
                y = y + 1 + x / y >> 1;
            }
            y = y + 1 + x / y >> 1;
        } else if (e >= 8) {
            y = (sqq_table[x >> e - 6 - (e & 1)] >> 7 - (e >> 1)) + 1;
        } else {
            return sqq_table[x] >> 4;
        }
        return x < y * y ? y - 1 : y;
    }

    private final void ssMintroSort(int PA, int first, int last, int depth) {
        int STACK_SIZE = 16;
        StackElement[] stack = new StackElement[16];
        int x = 0;
        int ssize = 0;
        int limit = DivSufSort.ssIlg(last - first);
        while (true) {
            int a;
            int v;
            if (last - first <= 8) {
                if (1 < last - first) {
                    this.ssInsertionSort(PA, first, last, depth);
                }
                if (ssize > 0) {
                    StackElement se = stack[--ssize];
                    first = se.a;
                    last = se.b;
                    depth = se.c;
                    limit = se.d;
                    continue;
                }
                return;
            }
            int Td = depth;
            if (limit-- == 0) {
                this.ssHeapSort(Td, PA, first, last - first);
            }
            if (limit < 0) {
                v = this.T[this.start + Td + this.SA[PA + this.SA[first]]];
                for (a = first + 1; a < last; ++a) {
                    x = this.T[this.start + Td + this.SA[PA + this.SA[a]]];
                    if (x == v) continue;
                    if (1 < a - first) break;
                    v = x;
                    first = a;
                }
                if (this.T[this.start + Td + this.SA[PA + this.SA[first]] - 1] < v) {
                    first = this.ssPartition(PA, first, a, depth);
                }
                if (a - first <= last - a) {
                    if (1 < a - first) {
                        stack[ssize++] = new StackElement(a, last, depth, -1);
                        last = a;
                        ++depth;
                        limit = DivSufSort.ssIlg(a - first);
                        continue;
                    }
                    first = a;
                    limit = -1;
                    continue;
                }
                if (1 < last - a) {
                    stack[ssize++] = new StackElement(first, a, depth + 1, DivSufSort.ssIlg(a - first));
                    first = a;
                    limit = -1;
                    continue;
                }
                last = a;
                ++depth;
                limit = DivSufSort.ssIlg(a - first);
                continue;
            }
            a = this.ssPivot(Td, PA, first, last);
            v = this.T[this.start + Td + this.SA[PA + this.SA[a]]];
            this.swapInSA(first, a);
            int b = first;
            while (++b < last && (x = this.T[this.start + Td + this.SA[PA + this.SA[b]]]) == v) {
            }
            a = b;
            if (a < last && x < v) {
                while (++b < last && (x = this.T[this.start + Td + this.SA[PA + this.SA[b]]]) <= v) {
                    if (x != v) continue;
                    this.swapInSA(b, a);
                    ++a;
                }
            }
            int c = last;
            while (b < --c && (x = this.T[this.start + Td + this.SA[PA + this.SA[c]]]) == v) {
            }
            int d = c;
            if (b < d && x > v) {
                while (b < --c && (x = this.T[this.start + Td + this.SA[PA + this.SA[c]]]) >= v) {
                    if (x != v) continue;
                    this.swapInSA(c, d);
                    --d;
                }
            }
            while (b < c) {
                this.swapInSA(b, c);
                while (++b < c && (x = this.T[this.start + Td + this.SA[PA + this.SA[b]]]) <= v) {
                    if (x != v) continue;
                    this.swapInSA(b, a);
                    ++a;
                }
                while (b < --c && (x = this.T[this.start + Td + this.SA[PA + this.SA[c]]]) >= v) {
                    if (x != v) continue;
                    this.swapInSA(c, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                int s = a - first;
                int t = b - a;
                if (s > t) {
                    s = t;
                }
                int e = first;
                int f = b - s;
                while (0 < s) {
                    this.swapInSA(e, f);
                    --s;
                    ++e;
                    ++f;
                }
                s = d - c;
                t = last - d - 1;
                if (s > t) {
                    s = t;
                }
                e = b;
                f = last - s;
                while (0 < s) {
                    this.swapInSA(e, f);
                    --s;
                    ++e;
                    ++f;
                }
                a = first + (b - a);
                c = last - (d - c);
                int n = b = v <= this.T[this.start + Td + this.SA[PA + this.SA[a]] - 1] ? a : this.ssPartition(PA, a, c, depth);
                if (a - first <= last - c) {
                    if (last - c <= c - b) {
                        stack[ssize++] = new StackElement(b, c, depth + 1, DivSufSort.ssIlg(c - b));
                        stack[ssize++] = new StackElement(c, last, depth, limit);
                        last = a;
                        continue;
                    }
                    if (a - first <= c - b) {
                        stack[ssize++] = new StackElement(c, last, depth, limit);
                        stack[ssize++] = new StackElement(b, c, depth + 1, DivSufSort.ssIlg(c - b));
                        last = a;
                        continue;
                    }
                    stack[ssize++] = new StackElement(c, last, depth, limit);
                    stack[ssize++] = new StackElement(first, a, depth, limit);
                    first = b;
                    last = c;
                    ++depth;
                    limit = DivSufSort.ssIlg(c - b);
                    continue;
                }
                if (a - first <= c - b) {
                    stack[ssize++] = new StackElement(b, c, depth + 1, DivSufSort.ssIlg(c - b));
                    stack[ssize++] = new StackElement(first, a, depth, limit);
                    first = c;
                    continue;
                }
                if (last - c <= c - b) {
                    stack[ssize++] = new StackElement(first, a, depth, limit);
                    stack[ssize++] = new StackElement(b, c, depth + 1, DivSufSort.ssIlg(c - b));
                    first = c;
                    continue;
                }
                stack[ssize++] = new StackElement(first, a, depth, limit);
                stack[ssize++] = new StackElement(c, last, depth, limit);
                first = b;
                last = c;
                ++depth;
                limit = DivSufSort.ssIlg(c - b);
                continue;
            }
            ++limit;
            if (this.T[this.start + Td + this.SA[PA + this.SA[first]] - 1] < v) {
                first = this.ssPartition(PA, first, last, depth);
                limit = DivSufSort.ssIlg(last - first);
            }
            ++depth;
        }
    }

    private final int ssPivot(int Td, int PA, int first, int last) {
        int t = last - first;
        int middle = first + t / 2;
        if (t <= 512) {
            if (t <= 32) {
                return this.ssMedian3(Td, PA, first, middle, last - 1);
            }
            return this.ssMedian5(Td, PA, first, first + (t >>= 2), middle, last - 1 - t, last - 1);
        }
        first = this.ssMedian3(Td, PA, first, first + (t >>= 3), first + (t << 1));
        middle = this.ssMedian3(Td, PA, middle - t, middle, middle + t);
        last = this.ssMedian3(Td, PA, last - 1 - (t << 1), last - 1 - t, last - 1);
        return this.ssMedian3(Td, PA, first, middle, last);
    }

    private final int ssMedian5(int Td, int PA, int v1, int v2, int v3, int v4, int v5) {
        int t;
        if (this.T[this.start + Td + this.SA[PA + this.SA[v2]]] > this.T[this.start + Td + this.SA[PA + this.SA[v3]]]) {
            t = v2;
            v2 = v3;
            v3 = t;
        }
        if (this.T[this.start + Td + this.SA[PA + this.SA[v4]]] > this.T[this.start + Td + this.SA[PA + this.SA[v5]]]) {
            t = v4;
            v4 = v5;
            v5 = t;
        }
        if (this.T[this.start + Td + this.SA[PA + this.SA[v2]]] > this.T[this.start + Td + this.SA[PA + this.SA[v4]]]) {
            t = v2;
            v2 = v4;
            v4 = t;
            t = v3;
            v3 = v5;
            v5 = t;
        }
        if (this.T[this.start + Td + this.SA[PA + this.SA[v1]]] > this.T[this.start + Td + this.SA[PA + this.SA[v3]]]) {
            t = v1;
            v1 = v3;
            v3 = t;
        }
        if (this.T[this.start + Td + this.SA[PA + this.SA[v1]]] > this.T[this.start + Td + this.SA[PA + this.SA[v4]]]) {
            t = v1;
            v1 = v4;
            v4 = t;
            t = v3;
            v3 = v5;
            v5 = t;
        }
        if (this.T[this.start + Td + this.SA[PA + this.SA[v3]]] > this.T[this.start + Td + this.SA[PA + this.SA[v4]]]) {
            return v4;
        }
        return v3;
    }

    private final int ssMedian3(int Td, int PA, int v1, int v2, int v3) {
        if (this.T[this.start + Td + this.SA[PA + this.SA[v1]]] > this.T[this.start + Td + this.SA[PA + this.SA[v2]]]) {
            int t = v1;
            v1 = v2;
            v2 = t;
        }
        if (this.T[this.start + Td + this.SA[PA + this.SA[v2]]] > this.T[this.start + Td + this.SA[PA + this.SA[v3]]]) {
            if (this.T[this.start + Td + this.SA[PA + this.SA[v1]]] > this.T[this.start + Td + this.SA[PA + this.SA[v3]]]) {
                return v1;
            }
            return v3;
        }
        return v2;
    }

    private final int ssPartition(int PA, int first, int last, int depth) {
        int a = first - 1;
        int b = last;
        while (true) {
            if (++a < b && this.SA[PA + this.SA[a]] + depth >= this.SA[PA + this.SA[a] + 1] + 1) {
                this.SA[a] = ~this.SA[a];
                continue;
            }
            while (a < --b && this.SA[PA + this.SA[b]] + depth < this.SA[PA + this.SA[b] + 1] + 1) {
            }
            if (b <= a) break;
            int t = ~this.SA[b];
            this.SA[b] = this.SA[a];
            this.SA[a] = t;
        }
        if (first < a) {
            this.SA[first] = ~this.SA[first];
        }
        return a;
    }

    private final void ssHeapSort(int Td, int PA, int sa, int size) {
        int i;
        int m = size;
        if (size % 2 == 0 && this.T[this.start + Td + this.SA[PA + this.SA[sa + --m / 2]]] < this.T[this.start + Td + this.SA[PA + this.SA[sa + m]]]) {
            this.swapInSA(sa + m, sa + m / 2);
        }
        for (i = m / 2 - 1; 0 <= i; --i) {
            this.ssFixDown(Td, PA, sa, i, m);
        }
        if (size % 2 == 0) {
            this.swapInSA(sa, sa + m);
            this.ssFixDown(Td, PA, sa, 0, m);
        }
        for (i = m - 1; 0 < i; --i) {
            int t = this.SA[sa];
            this.SA[sa] = this.SA[sa + i];
            this.ssFixDown(Td, PA, sa, 0, i);
            this.SA[sa + i] = t;
        }
    }

    private final void ssFixDown(int Td, int PA, int sa, int i, int size) {
        int j;
        int v = this.SA[sa + i];
        int c = this.T[this.start + Td + this.SA[PA + v]];
        while ((j = 2 * i + 1) < size) {
            int e;
            int k;
            int d;
            if ((d = this.T[this.start + Td + this.SA[PA + this.SA[sa + (k = j++)]]]) < (e = this.T[this.start + Td + this.SA[PA + this.SA[sa + j]]])) {
                k = j;
                d = e;
            }
            if (d <= c) break;
            this.SA[sa + i] = this.SA[sa + k];
            i = k;
        }
        this.SA[i + sa] = v;
    }

    private static final int ssIlg(int n) {
        return (n & 0xFF00) != 0 ? 8 + lg_table[n >> 8 & 0xFF] : 0 + lg_table[n >> 0 & 0xFF];
    }

    private final void swapInSA(int a, int b) {
        int tmp = this.SA[a];
        this.SA[a] = this.SA[b];
        this.SA[b] = tmp;
    }

    private final void trSort(int ISA, int n, int depth) {
        TRBudget budget = new TRBudget(DivSufSort.trIlg(n) * 2 / 3, n);
        int ISAd = ISA + depth;
        while (-n < this.SA[0]) {
            int first = 0;
            int skip = 0;
            int unsorted = 0;
            do {
                int last;
                int t;
                if ((t = this.SA[first]) < 0) {
                    first -= t;
                    skip += t;
                    continue;
                }
                if (skip != 0) {
                    this.SA[first + skip] = skip;
                    skip = 0;
                }
                if (1 < (last = this.SA[ISA + t] + 1) - first) {
                    budget.count = 0;
                    this.trIntroSort(ISA, ISAd, first, last, budget);
                    if (budget.count != 0) {
                        unsorted += budget.count;
                    } else {
                        skip = first - last;
                    }
                } else if (last - first == 1) {
                    skip = -1;
                }
                first = last;
            } while (first < n);
            if (skip != 0) {
                this.SA[first + skip] = skip;
            }
            if (unsorted == 0) break;
            ISAd += ISAd - ISA;
        }
    }

    private final TRPartitionResult trPartition(int ISAd, int first, int middle, int last, int pa, int pb, int v) {
        int x = 0;
        int b = middle - 1;
        while (++b < last && (x = this.SA[ISAd + this.SA[b]]) == v) {
        }
        int a = b;
        if (a < last && x < v) {
            while (++b < last && (x = this.SA[ISAd + this.SA[b]]) <= v) {
                if (x != v) continue;
                this.swapInSA(a, b);
                ++a;
            }
        }
        int c = last;
        while (b < --c && (x = this.SA[ISAd + this.SA[c]]) == v) {
        }
        int d = c;
        if (b < d && x > v) {
            while (b < --c && (x = this.SA[ISAd + this.SA[c]]) >= v) {
                if (x != v) continue;
                this.swapInSA(c, d);
                --d;
            }
        }
        while (b < c) {
            this.swapInSA(c, b);
            while (++b < c && (x = this.SA[ISAd + this.SA[b]]) <= v) {
                if (x != v) continue;
                this.swapInSA(a, b);
                ++a;
            }
            while (b < --c && (x = this.SA[ISAd + this.SA[c]]) >= v) {
                if (x != v) continue;
                this.swapInSA(c, d);
                --d;
            }
        }
        if (a <= d) {
            c = b - 1;
            int s = a - first;
            int t = b - a;
            if (s > t) {
                s = t;
            }
            int e = first;
            int f = b - s;
            while (0 < s) {
                this.swapInSA(e, f);
                --s;
                ++e;
                ++f;
            }
            s = d - c;
            t = last - d - 1;
            if (s > t) {
                s = t;
            }
            e = b;
            f = last - s;
            while (0 < s) {
                this.swapInSA(e, f);
                --s;
                ++e;
                ++f;
            }
            first += b - a;
            last -= d - c;
        }
        return new TRPartitionResult(first, last);
    }

    private final void trIntroSort(int ISA, int ISAd, int first, int last, TRBudget budget) {
        int STACK_SIZE = 64;
        StackElement[] stack = new StackElement[64];
        int a = 0;
        int b = 0;
        int x = 0;
        int incr = ISAd - ISA;
        int trlink = -1;
        int ssize = 0;
        int limit = DivSufSort.trIlg(last - first);
        while (true) {
            int next;
            StackElement se;
            int c;
            int v;
            TRPartitionResult res;
            if (limit < 0) {
                StackElement se2;
                if (limit == -1) {
                    res = this.trPartition(ISAd - incr, first, first, last, a, b, last - 1);
                    a = res.a;
                    b = res.b;
                    if (a < last) {
                        v = a - 1;
                        for (c = first; c < a; ++c) {
                            this.SA[ISA + this.SA[c]] = v;
                        }
                    }
                    if (b < last) {
                        v = b - 1;
                        for (c = a; c < b; ++c) {
                            this.SA[ISA + this.SA[c]] = v;
                        }
                    }
                    if (1 < b - a) {
                        stack[ssize++] = new StackElement(0, a, b, 0, 0);
                        stack[ssize++] = new StackElement(ISAd - incr, first, last, -2, trlink);
                        trlink = ssize - 2;
                    }
                    if (a - first <= last - b) {
                        if (1 < a - first) {
                            stack[ssize++] = new StackElement(ISAd, b, last, DivSufSort.trIlg(last - b), trlink);
                            last = a;
                            limit = DivSufSort.trIlg(a - first);
                            continue;
                        }
                        if (1 < last - b) {
                            first = b;
                            limit = DivSufSort.trIlg(last - b);
                            continue;
                        }
                        if (ssize > 0) {
                            se = stack[--ssize];
                            ISAd = se.a;
                            first = se.b;
                            last = se.c;
                            limit = se.d;
                            trlink = se.e;
                            continue;
                        }
                        return;
                    }
                    if (1 < last - b) {
                        stack[ssize++] = new StackElement(ISAd, first, a, DivSufSort.trIlg(a - first), trlink);
                        first = b;
                        limit = DivSufSort.trIlg(last - b);
                        continue;
                    }
                    if (1 < a - first) {
                        last = a;
                        limit = DivSufSort.trIlg(a - first);
                        continue;
                    }
                    if (ssize > 0) {
                        se = stack[--ssize];
                        ISAd = se.a;
                        first = se.b;
                        last = se.c;
                        limit = se.d;
                        trlink = se.e;
                        continue;
                    }
                    return;
                }
                if (limit == -2) {
                    se2 = stack[--ssize];
                    a = se2.b;
                    b = se2.c;
                    if (stack[ssize].d == 0) {
                        this.trCopy(ISA, first, a, b, last, ISAd - ISA);
                    } else {
                        if (0 <= trlink) {
                            stack[trlink].d = -1;
                        }
                        this.trPartialCopy(ISA, first, a, b, last, ISAd - ISA);
                    }
                    if (ssize > 0) {
                        se2 = stack[--ssize];
                        ISAd = se2.a;
                        first = se2.b;
                        last = se2.c;
                        limit = se2.d;
                        trlink = se2.e;
                        continue;
                    }
                    return;
                }
                if (0 <= this.SA[first]) {
                    a = first;
                    do {
                        this.SA[ISA + this.SA[a]] = a;
                    } while (++a < last && 0 <= this.SA[a]);
                    first = a;
                }
                if (first < last) {
                    a = first;
                    do {
                        this.SA[a] = ~this.SA[a];
                    } while (this.SA[++a] < 0);
                    int n = next = this.SA[ISA + this.SA[a]] != this.SA[ISAd + this.SA[a]] ? DivSufSort.trIlg(a - first + 1) : -1;
                    if (++a < last) {
                        v = a - 1;
                        for (b = first; b < a; ++b) {
                            this.SA[ISA + this.SA[b]] = v;
                        }
                    }
                    if (budget.check(a - first) != 0) {
                        if (a - first <= last - a) {
                            stack[ssize++] = new StackElement(ISAd, a, last, -3, trlink);
                            ISAd += incr;
                            last = a;
                            limit = next;
                            continue;
                        }
                        if (1 < last - a) {
                            stack[ssize++] = new StackElement(ISAd + incr, first, a, next, trlink);
                            first = a;
                            limit = -3;
                            continue;
                        }
                        ISAd += incr;
                        last = a;
                        limit = next;
                        continue;
                    }
                    if (0 <= trlink) {
                        stack[trlink].d = -1;
                    }
                    if (1 < last - a) {
                        first = a;
                        limit = -3;
                        continue;
                    }
                    if (ssize > 0) {
                        se2 = stack[--ssize];
                        ISAd = se2.a;
                        first = se2.b;
                        last = se2.c;
                        limit = se2.d;
                        trlink = se2.e;
                        continue;
                    }
                    return;
                }
                if (ssize > 0) {
                    se2 = stack[--ssize];
                    ISAd = se2.a;
                    first = se2.b;
                    last = se2.c;
                    limit = se2.d;
                    trlink = se2.e;
                    continue;
                }
                return;
            }
            if (last - first <= 8) {
                this.trInsertionSort(ISAd, first, last);
                limit = -3;
                continue;
            }
            if (limit-- == 0) {
                this.trHeapSort(ISAd, first, last - first);
                a = last - 1;
                while (first < a) {
                    x = this.SA[ISAd + this.SA[a]];
                    for (b = a - 1; first <= b && this.SA[ISAd + this.SA[b]] == x; --b) {
                        this.SA[b] = ~this.SA[b];
                    }
                    a = b;
                }
                limit = -3;
                continue;
            }
            a = this.trPivot(ISAd, first, last);
            this.swapInSA(first, a);
            v = this.SA[ISAd + this.SA[first]];
            res = this.trPartition(ISAd, first, first + 1, last, a, b, v);
            a = res.a;
            b = res.b;
            if (last - first != b - a) {
                next = this.SA[ISA + this.SA[a]] != v ? DivSufSort.trIlg(b - a) : -1;
                v = a - 1;
                for (c = first; c < a; ++c) {
                    this.SA[ISA + this.SA[c]] = v;
                }
                if (b < last) {
                    v = b - 1;
                    for (c = a; c < b; ++c) {
                        this.SA[ISA + this.SA[c]] = v;
                    }
                }
                if (1 < b - a && budget.check(b - a) != 0) {
                    if (a - first <= last - b) {
                        if (last - b <= b - a) {
                            if (1 < a - first) {
                                stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                                stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                                last = a;
                                continue;
                            }
                            if (1 < last - b) {
                                stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                                first = b;
                                continue;
                            }
                            ISAd += incr;
                            first = a;
                            last = b;
                            limit = next;
                            continue;
                        }
                        if (a - first <= b - a) {
                            if (1 < a - first) {
                                stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                                stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                                last = a;
                                continue;
                            }
                            stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                            ISAd += incr;
                            first = a;
                            last = b;
                            limit = next;
                            continue;
                        }
                        stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                        stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                        ISAd += incr;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    if (a - first <= b - a) {
                        if (1 < last - b) {
                            stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                            stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                            first = b;
                            continue;
                        }
                        if (1 < a - first) {
                            stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                            last = a;
                            continue;
                        }
                        ISAd += incr;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    if (last - b <= b - a) {
                        if (1 < last - b) {
                            stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                            stack[ssize++] = new StackElement(ISAd + incr, a, b, next, trlink);
                            first = b;
                            continue;
                        }
                        stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                        ISAd += incr;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                    stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                    ISAd += incr;
                    first = a;
                    last = b;
                    limit = next;
                    continue;
                }
                if (1 < b - a && 0 <= trlink) {
                    stack[trlink].d = -1;
                }
                if (a - first <= last - b) {
                    if (1 < a - first) {
                        stack[ssize++] = new StackElement(ISAd, b, last, limit, trlink);
                        last = a;
                        continue;
                    }
                    if (1 < last - b) {
                        first = b;
                        continue;
                    }
                    if (ssize > 0) {
                        se = stack[--ssize];
                        ISAd = se.a;
                        first = se.b;
                        last = se.c;
                        limit = se.d;
                        trlink = se.e;
                        continue;
                    }
                    return;
                }
                if (1 < last - b) {
                    stack[ssize++] = new StackElement(ISAd, first, a, limit, trlink);
                    first = b;
                    continue;
                }
                if (1 < a - first) {
                    last = a;
                    continue;
                }
                if (ssize > 0) {
                    se = stack[--ssize];
                    ISAd = se.a;
                    first = se.b;
                    last = se.c;
                    limit = se.d;
                    trlink = se.e;
                    continue;
                }
                return;
            }
            if (budget.check(last - first) != 0) {
                limit = DivSufSort.trIlg(last - first);
                ISAd += incr;
                continue;
            }
            if (0 <= trlink) {
                stack[trlink].d = -1;
            }
            if (ssize <= 0) break;
            se = stack[--ssize];
            ISAd = se.a;
            first = se.b;
            last = se.c;
            limit = se.d;
            trlink = se.e;
        }
    }

    private final int trPivot(int ISAd, int first, int last) {
        int t = last - first;
        int middle = first + t / 2;
        if (t <= 512) {
            if (t <= 32) {
                return this.trMedian3(ISAd, first, middle, last - 1);
            }
            return this.trMedian5(ISAd, first, first + (t >>= 2), middle, last - 1 - t, last - 1);
        }
        first = this.trMedian3(ISAd, first, first + (t >>= 3), first + (t << 1));
        middle = this.trMedian3(ISAd, middle - t, middle, middle + t);
        last = this.trMedian3(ISAd, last - 1 - (t << 1), last - 1 - t, last - 1);
        return this.trMedian3(ISAd, first, middle, last);
    }

    private final int trMedian5(int ISAd, int v1, int v2, int v3, int v4, int v5) {
        int t;
        if (this.SA[ISAd + this.SA[v2]] > this.SA[ISAd + this.SA[v3]]) {
            t = v2;
            v2 = v3;
            v3 = t;
        }
        if (this.SA[ISAd + this.SA[v4]] > this.SA[ISAd + this.SA[v5]]) {
            t = v4;
            v4 = v5;
            v5 = t;
        }
        if (this.SA[ISAd + this.SA[v2]] > this.SA[ISAd + this.SA[v4]]) {
            t = v2;
            v2 = v4;
            v4 = t;
            t = v3;
            v3 = v5;
            v5 = t;
        }
        if (this.SA[ISAd + this.SA[v1]] > this.SA[ISAd + this.SA[v3]]) {
            t = v1;
            v1 = v3;
            v3 = t;
        }
        if (this.SA[ISAd + this.SA[v1]] > this.SA[ISAd + this.SA[v4]]) {
            t = v1;
            v1 = v4;
            v4 = t;
            t = v3;
            v3 = v5;
            v5 = t;
        }
        if (this.SA[ISAd + this.SA[v3]] > this.SA[ISAd + this.SA[v4]]) {
            return v4;
        }
        return v3;
    }

    private final int trMedian3(int ISAd, int v1, int v2, int v3) {
        if (this.SA[ISAd + this.SA[v1]] > this.SA[ISAd + this.SA[v2]]) {
            int t = v1;
            v1 = v2;
            v2 = t;
        }
        if (this.SA[ISAd + this.SA[v2]] > this.SA[ISAd + this.SA[v3]]) {
            if (this.SA[ISAd + this.SA[v1]] > this.SA[ISAd + this.SA[v3]]) {
                return v1;
            }
            return v3;
        }
        return v2;
    }

    private final void trHeapSort(int ISAd, int sa, int size) {
        int i;
        int m = size;
        if (size % 2 == 0 && this.SA[ISAd + this.SA[sa + --m / 2]] < this.SA[ISAd + this.SA[sa + m]]) {
            this.swapInSA(sa + m, sa + m / 2);
        }
        for (i = m / 2 - 1; 0 <= i; --i) {
            this.trFixDown(ISAd, sa, i, m);
        }
        if (size % 2 == 0) {
            this.swapInSA(sa, sa + m);
            this.trFixDown(ISAd, sa, 0, m);
        }
        for (i = m - 1; 0 < i; --i) {
            int t = this.SA[sa];
            this.SA[sa] = this.SA[sa + i];
            this.trFixDown(ISAd, sa, 0, i);
            this.SA[sa + i] = t;
        }
    }

    private final void trFixDown(int ISAd, int sa, int i, int size) {
        int j;
        int v = this.SA[sa + i];
        int c = this.SA[ISAd + v];
        while ((j = 2 * i + 1) < size) {
            int e;
            int k;
            int d;
            if ((d = this.SA[ISAd + this.SA[sa + (k = j++)]]) < (e = this.SA[ISAd + this.SA[sa + j]])) {
                k = j;
                d = e;
            }
            if (d <= c) break;
            this.SA[sa + i] = this.SA[sa + k];
            i = k;
        }
        this.SA[sa + i] = v;
    }

    private final void trInsertionSort(int ISAd, int first, int last) {
        for (int a = first + 1; a < last; ++a) {
            int r;
            int t = this.SA[a];
            int b = a - 1;
            while (0 > (r = this.SA[ISAd + t] - this.SA[ISAd + this.SA[b]])) {
                do {
                    this.SA[b + 1] = this.SA[b];
                } while (first <= --b && this.SA[b] < 0);
                if (b >= first) continue;
            }
            if (r == 0) {
                this.SA[b] = ~this.SA[b];
            }
            this.SA[b + 1] = t;
        }
    }

    private final void trPartialCopy(int ISA, int first, int a, int b, int last, int depth) {
        int e;
        int rank;
        int s;
        int c;
        int newrank = -1;
        int v = b - 1;
        int lastrank = -1;
        int d = a - 1;
        for (c = first; c <= d; ++c) {
            s = this.SA[c] - depth;
            if (0 > s || this.SA[ISA + s] != v) continue;
            this.SA[++d] = s;
            rank = this.SA[ISA + s + depth];
            if (lastrank != rank) {
                lastrank = rank;
                newrank = d;
            }
            this.SA[ISA + s] = newrank;
        }
        lastrank = -1;
        for (e = d; first <= e; --e) {
            rank = this.SA[ISA + this.SA[e]];
            if (lastrank != rank) {
                lastrank = rank;
                newrank = e;
            }
            if (newrank == rank) continue;
            this.SA[ISA + this.SA[e]] = newrank;
        }
        lastrank = -1;
        c = last - 1;
        e = d + 1;
        d = b;
        while (e < d) {
            s = this.SA[c] - depth;
            if (0 <= s && this.SA[ISA + s] == v) {
                this.SA[--d] = s;
                rank = this.SA[ISA + s + depth];
                if (lastrank != rank) {
                    lastrank = rank;
                    newrank = d;
                }
                this.SA[ISA + s] = newrank;
            }
            --c;
        }
    }

    private final void trCopy(int ISA, int first, int a, int b, int last, int depth) {
        int s;
        int c;
        int v = b - 1;
        int d = a - 1;
        for (c = first; c <= d; ++c) {
            s = this.SA[c] - depth;
            if (0 > s || this.SA[ISA + s] != v) continue;
            this.SA[++d] = s;
            this.SA[ISA + s] = d;
        }
        c = last - 1;
        int e = d + 1;
        d = b;
        while (e < d) {
            s = this.SA[c] - depth;
            if (0 <= s && this.SA[ISA + s] == v) {
                this.SA[--d] = s;
                this.SA[ISA + s] = d;
            }
            --c;
        }
    }

    private static final int trIlg(int n) {
        return (n & 0xFFFF0000) != 0 ? ((n & 0xFF000000) != 0 ? 24 + lg_table[n >> 24 & 0xFF] : 16 + lg_table[n >> 16 & 0xFF]) : ((n & 0xFF00) != 0 ? 8 + lg_table[n >> 8 & 0xFF] : 0 + lg_table[n >> 0 & 0xFF]);
    }

    private static final class TRPartitionResult {
        final int a;
        final int b;

        public TRPartitionResult(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }

    private static final class TRBudget {
        int chance;
        int remain;
        int incval;
        int count;

        private TRBudget(int chance, int incval) {
            this.chance = chance;
            this.remain = incval;
            this.incval = incval;
        }

        private int check(int size) {
            if (size <= this.remain) {
                this.remain -= size;
                return 1;
            }
            if (this.chance == 0) {
                this.count += size;
                return 0;
            }
            this.remain += this.incval - size;
            --this.chance;
            return 1;
        }
    }

    private static final class StackElement {
        final int a;
        final int b;
        final int c;
        final int e;
        int d;

        StackElement(int a, int b, int c, int d, int e) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        StackElement(int a, int b, int c, int d) {
            this(a, b, c, d, 0);
        }
    }
}

