/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixarray;

import eu.interedition.collatex.suffixarray.ISuffixArrayBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

class GenericArrayAdapter<T> {
    private final ISuffixArrayBuilder delegate;
    int[] input;
    TreeMap<T, Integer> tokIDs;
    private final Comparator<? super T> comparator;

    public GenericArrayAdapter(ISuffixArrayBuilder builder) {
        this.delegate = builder;
        this.comparator = null;
    }

    public GenericArrayAdapter(ISuffixArrayBuilder builder, Comparator<? super T> comparator) {
        this.delegate = builder;
        this.comparator = comparator;
    }

    public int[] buildSuffixArray(T[] tokens) {
        int length = tokens.length;
        this.input = new int[length + 575];
        this.tokIDs = new TreeMap(this.comparator);
        for (int i = 0; i < length; ++i) {
            this.tokIDs.put(tokens[i], null);
        }
        int _id = 1;
        for (Map.Entry<T, Integer> entry : this.tokIDs.entrySet()) {
            entry.setValue(_id++);
        }
        for (int i = 0; i < length; ++i) {
            this.input[i] = this.tokIDs.get(tokens[i]);
        }
        return this.delegate.buildSuffixArray(this.input, 0, length);
    }
}

