/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixarray;

import eu.interedition.collatex.suffixarray.CharSequenceAdapter;
import eu.interedition.collatex.suffixarray.DensePositiveDecorator;
import eu.interedition.collatex.suffixarray.ExtraTrailingCellsDecorator;
import eu.interedition.collatex.suffixarray.GenericArrayAdapter;
import eu.interedition.collatex.suffixarray.ISuffixArrayBuilder;
import eu.interedition.collatex.suffixarray.QSufSort;
import eu.interedition.collatex.suffixarray.SuffixData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class SuffixArrays {
    static final int MAX_EXTRA_TRAILING_SPACE = 575;

    private SuffixArrays() {
    }

    public static int[] create(CharSequence s) {
        return SuffixArrays.create(s, SuffixArrays.defaultAlgorithm());
    }

    public static int[] create(CharSequence s, ISuffixArrayBuilder builder) {
        return new CharSequenceAdapter(builder).buildSuffixArray(s);
    }

    public static SuffixData createWithLCP(CharSequence s) {
        return SuffixArrays.createWithLCP(s, SuffixArrays.defaultAlgorithm());
    }

    public static SuffixData createWithLCP(CharSequence s, ISuffixArrayBuilder builder) {
        CharSequenceAdapter adapter = new CharSequenceAdapter(builder);
        int[] sa = adapter.buildSuffixArray(s);
        int[] lcp = SuffixArrays.computeLCP(adapter.input, 0, s.length(), sa);
        return new SuffixData(sa, lcp);
    }

    public static SuffixData createWithLCP(int[] input, int start, int length) {
        DensePositiveDecorator builder = new DensePositiveDecorator(new ExtraTrailingCellsDecorator(SuffixArrays.defaultAlgorithm(), 3));
        return SuffixArrays.createWithLCP(input, start, length, builder);
    }

    public static SuffixData createWithLCP(int[] input, int start, int length, ISuffixArrayBuilder builder) {
        int[] sa = builder.buildSuffixArray(input, start, length);
        int[] lcp = SuffixArrays.computeLCP(input, start, length, sa);
        return new SuffixData(sa, lcp);
    }

    public static <T> SuffixData createWithLCP(T[] input, ISuffixArrayBuilder builder, Comparator<? super T> comparator) {
        GenericArrayAdapter<T> adapter = new GenericArrayAdapter<T>(builder, comparator);
        int[] sa = adapter.buildSuffixArray(input);
        int[] lcp = SuffixArrays.computeLCP(adapter.input, 0, input.length, sa);
        return new SuffixData(sa, lcp);
    }

    public static int[] computeLCP(int[] input, int start, int length, int[] sa) {
        int[] rank = new int[length];
        for (int i = 0; i < length; ++i) {
            rank[sa[i]] = i;
        }
        int h = 0;
        int[] lcp = new int[length];
        for (int i = 0; i < length; ++i) {
            int k = rank[i];
            if (k == 0) {
                lcp[k] = -1;
            } else {
                int j = sa[k - 1];
                while (i + h < length && j + h < length && input[start + i + h] == input[start + j + h]) {
                    ++h;
                }
                lcp[k] = h;
            }
            if (h <= 0) continue;
            --h;
        }
        return lcp;
    }

    private static ISuffixArrayBuilder defaultAlgorithm() {
        return new QSufSort();
    }

    public static List<CharSequence> toString(CharSequence input, int[] suffixes) {
        String full = input.toString();
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (int i = 0; i < input.length(); ++i) {
            result.add(full.subSequence(suffixes[i], full.length()));
        }
        return result;
    }
}

