/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixtree;

import eu.interedition.collatex.suffixtree.ActivePoint;
import eu.interedition.collatex.suffixtree.Edge;
import eu.interedition.collatex.suffixtree.Sequence;
import eu.interedition.collatex.suffixtree.SequenceTerminal;
import eu.interedition.collatex.suffixtree.Suffix;
import eu.interedition.collatex.suffixtree.SuffixTree;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class Node<T, S extends Iterable<T>>
implements Iterable<Edge<T, S>> {
    private final Map<T, Edge<T, S>> edges = new HashMap<T, Edge<T, S>>();
    private final Edge<T, S> incomingEdge;
    private Set<SequenceTerminal<S>> sequenceTerminals = new HashSet<SequenceTerminal<S>>();
    private final Sequence<T, S> sequence;
    private final SuffixTree<T, S> tree;
    private Node<T, S> link = null;

    Node(Edge<T, S> incomingEdge, Sequence<T, S> sequence, SuffixTree<T, S> tree) {
        this.incomingEdge = incomingEdge;
        this.sequence = sequence;
        this.tree = tree;
    }

    void insert(Suffix<T, S> suffix, ActivePoint<T, S> activePoint) {
        Object item = suffix.getEndItem();
        if (this.edges.containsKey(item)) {
            if (this.tree.isNotFirstInsert() && activePoint.getNode() != this.tree.getRoot()) {
                this.tree.setSuffixLink(activePoint.getNode());
            }
            activePoint.setEdge(this.edges.get(item));
            activePoint.incrementLength();
        } else {
            this.saveSequenceTerminal(item);
            Edge<T, S> newEdge = new Edge<T, S>(suffix.getEndPosition() - 1, this, this.sequence, this.tree);
            this.edges.put(suffix.getEndItem(), newEdge);
            suffix.decrement();
            activePoint.updateAfterInsert(suffix);
            if (this.tree.isNotFirstInsert() && !this.equals(this.tree.getRoot())) {
                this.tree.getLastNodeInserted().setSuffixLink(this);
            }
            if (suffix.isEmpty()) {
                return;
            }
            this.tree.insert(suffix);
        }
    }

    private void saveSequenceTerminal(Object item) {
        if (item.getClass().equals(SequenceTerminal.class)) {
            SequenceTerminal terminal = (SequenceTerminal)item;
            this.sequenceTerminals.add(terminal);
        }
    }

    void insert(Edge<T, S> edge) {
        if (this.edges.containsKey(edge.getStartItem())) {
            throw new IllegalArgumentException("Item " + edge.getStartItem() + " already exists in node " + this.toString());
        }
        this.edges.put(edge.getStartItem(), edge);
    }

    Edge<T, S> getEdgeStarting(Object item) {
        return this.edges.get(item);
    }

    boolean hasSuffixLink() {
        return this.link != null;
    }

    int getEdgeCount() {
        return this.edges.size();
    }

    @Override
    public Iterator<Edge<T, S>> iterator() {
        return this.edges.values().iterator();
    }

    Node<T, S> getSuffixLink() {
        return this.link;
    }

    void setSuffixLink(Node<T, S> node) {
        this.link = node;
    }

    public String toString() {
        if (this.incomingEdge == null) {
            return "root";
        }
        return "end of edge [" + this.incomingEdge.toString() + "]";
    }

    public Collection<SequenceTerminal<S>> getSuffixTerminals() {
        return this.sequenceTerminals;
    }

    public Collection<Edge<T, S>> getEdges() {
        return this.edges.values();
    }
}

