/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixtree;

import eu.interedition.collatex.suffixtree.Edge;
import eu.interedition.collatex.suffixtree.Node;
import eu.interedition.collatex.suffixtree.SequenceTerminal;
import eu.interedition.collatex.suffixtree.SuffixTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Utils {
    static <I, S extends Iterable<I>> Object[] addTerminalToSequence(S sequence, SequenceTerminal<S> terminatingObject) {
        ArrayList<I> list = new ArrayList<I>();
        for (I item : sequence) {
            list.add(item);
        }
        Object[] newSequence = new Object[list.size() + 1];
        for (int i = 0; i < list.size(); ++i) {
            newSequence[i] = list.get(i);
        }
        newSequence[i] = terminatingObject;
        return newSequence;
    }

    static <T, S extends Iterable<T>> String printTreeForGraphViz(SuffixTree<T, S> tree) {
        return Utils.printTreeForGraphViz(tree, true);
    }

    static <T, S extends Iterable<T>> String printTreeForGraphViz(SuffixTree<T, S> tree, boolean printSuffixLinks) {
        LinkedList<Node<T, S>> stack = new LinkedList<Node<T, S>>();
        stack.add(tree.getRoot());
        HashMap nodeMap = new HashMap();
        nodeMap.put(tree.getRoot(), 0);
        int nodeId = 1;
        StringBuilder sb = new StringBuilder("\ndigraph suffixTree{\n node [shape=circle, label=\"\", fixedsize=true, width=0.1, height=0.1]\n");
        while (stack.size() > 0) {
            LinkedList childNodes = new LinkedList();
            for (Node node : stack) {
                for (Edge edge : node) {
                    int id = nodeId++;
                    if (edge.isTerminating()) {
                        childNodes.push(edge.getTerminal());
                        nodeMap.put(edge.getTerminal(), id);
                    }
                    sb.append(nodeMap.get(node)).append(" -> ").append(id).append(" [label=\"");
                    for (Object item : edge) {
                        sb.append(item.toString());
                    }
                    sb.append("\"];\n");
                }
            }
            stack = childNodes;
        }
        if (printSuffixLinks) {
            sb.append("edge [color=red]\n");
            for (Map.Entry entry : nodeMap.entrySet()) {
                Node node = (Node)entry.getKey();
                int id1 = (Integer)entry.getValue();
                if (!node.hasSuffixLink()) continue;
                Node n2 = node.getSuffixLink();
                Integer id2 = (Integer)nodeMap.get(n2);
                sb.append(id1).append(" -> ").append(id2).append(" ;\n");
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

