/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.tools;

import eu.interedition.collatex.CollationAlgorithm;
import eu.interedition.collatex.CollationAlgorithmFactory;
import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.matching.EqualityTokenComparator;
import eu.interedition.collatex.simple.SimpleCollation;
import eu.interedition.collatex.simple.SimplePatternTokenizer;
import eu.interedition.collatex.simple.SimpleToken;
import eu.interedition.collatex.simple.SimpleTokenNormalizers;
import eu.interedition.collatex.simple.SimpleVariantGraphSerializer;
import eu.interedition.collatex.simple.SimpleWitness;
import eu.interedition.collatex.tools.JsonProcessor;
import eu.interedition.collatex.tools.PluginScript;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class CollationPipe {
    public static void start(CommandLine commandLine) throws Exception {
        block76: {
            List<SimpleWitness> witnesses = null;
            Function<String, Stream<String>> tokenizer = SimplePatternTokenizer.BY_WS_OR_PUNCT;
            Function<String, String> normalizer = SimpleTokenNormalizers.LC_TRIM_WS;
            Comparator<Token> comparator = new EqualityTokenComparator();
            CollationAlgorithm collationAlgorithm = null;
            boolean joined = true;
            String[] witnessSpecs = commandLine.getArgs();
            URL[] inputResources = new URL[witnessSpecs.length];
            int wl = witnessSpecs.length;
            for (int wc = 0; wc < wl; ++wc) {
                try {
                    inputResources[wc] = CollationPipe.argumentToInput(witnessSpecs[wc]);
                    continue;
                }
                catch (MalformedURLException urlEx) {
                    throw new ParseException("Invalid resource: " + witnessSpecs[wc]);
                }
            }
            if (inputResources.length < 1) {
                throw new ParseException("No input resource(s) given");
            }
            if (inputResources.length < 2) {
                try (InputStream inputStream = inputResources[0].openStream();){
                    SimpleCollation collation = JsonProcessor.read(inputStream);
                    witnesses = collation.getWitnesses();
                    collationAlgorithm = collation.getAlgorithm();
                    joined = collation.isJoined();
                }
            }
            String script = commandLine.getOptionValue("s");
            try {
                PluginScript pluginScript = script == null ? PluginScript.read("<internal>", new StringReader("")) : PluginScript.read(CollationPipe.argumentToInput(script));
                tokenizer = Optional.ofNullable(pluginScript.tokenizer()).orElse(tokenizer);
                normalizer = Optional.ofNullable(pluginScript.normalizer()).orElse(normalizer);
                comparator = Optional.ofNullable(pluginScript.comparator()).orElse(comparator);
            }
            catch (IOException e) {
                throw new ParseException("Failed to read script '" + script + "' - " + e.getMessage());
            }
            switch (commandLine.getOptionValue("a", "").toLowerCase()) {
                case "needleman-wunsch": {
                    collationAlgorithm = CollationAlgorithmFactory.needlemanWunsch(comparator);
                    break;
                }
                case "medite": {
                    collationAlgorithm = CollationAlgorithmFactory.medite(comparator, SimpleToken.TOKEN_MATCH_EVALUATOR);
                    break;
                }
                case "gst": {
                    collationAlgorithm = CollationAlgorithmFactory.greedyStringTiling(comparator, 2);
                    break;
                }
                default: {
                    collationAlgorithm = Optional.ofNullable(collationAlgorithm).orElse(CollationAlgorithmFactory.dekker(comparator));
                }
            }
            if (witnesses == null) {
                Charset inputCharset = Charset.forName(commandLine.getOptionValue("ie", StandardCharsets.UTF_8.name()));
                boolean xmlMode = commandLine.hasOption("xml");
                XPathExpression tokenXPath = XPathFactory.newInstance().newXPath().compile(commandLine.getOptionValue("xp", "//text()"));
                witnesses = new ArrayList<SimpleWitness>(inputResources.length);
                int wl2 = inputResources.length;
                for (int wc = 0; wc < wl2; ++wc) {
                    try (InputStream stream = inputResources[wc].openStream();){
                        String sigil = "w" + (wc + 1);
                        if (!xmlMode) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, inputCharset));
                            StringWriter writer = new StringWriter();
                            char[] buf = new char[1024];
                            while (reader.read(buf) != -1) {
                                writer.write(buf);
                            }
                            witnesses.add(new SimpleWitness(sigil, writer.toString(), tokenizer, normalizer));
                            continue;
                        }
                        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document document = documentBuilder.parse(stream);
                        document.normalizeDocument();
                        SimpleWitness witness = new SimpleWitness(sigil);
                        NodeList tokenNodes = (NodeList)tokenXPath.evaluate(document, XPathConstants.NODESET);
                        ArrayList<Token> tokens = new ArrayList<Token>(tokenNodes.getLength());
                        for (int nc = 0; nc < tokenNodes.getLength(); ++nc) {
                            String tokenText = tokenNodes.item(nc).getTextContent();
                            tokens.add(new SimpleToken(witness, tokenText, normalizer.apply(tokenText)));
                        }
                        witness.setTokens(tokens);
                        witnesses.add(witness);
                        continue;
                    }
                }
            }
            VariantGraph variantGraph = new VariantGraph();
            for (SimpleWitness witness : witnesses) {
                collationAlgorithm.collate(variantGraph, (Iterable<Token>)witness);
            }
            if (joined && !commandLine.hasOption("t")) {
                VariantGraph.JOIN.apply(variantGraph);
            }
            String output = commandLine.getOptionValue("o", "-");
            Charset outputCharset = Charset.forName(commandLine.getOptionValue("oe", StandardCharsets.UTF_8.name()));
            String outputFormat = commandLine.getOptionValue("f", "json").toLowerCase();
            try (PrintWriter out = CollationPipe.argumentToOutput(output, outputCharset);){
                SimpleVariantGraphSerializer serializer = new SimpleVariantGraphSerializer(variantGraph);
                if ("csv".equals(outputFormat)) {
                    serializer.toCsv(out);
                    break block76;
                }
                if ("dot".equals(outputFormat)) {
                    serializer.toDot(out);
                    break block76;
                }
                if ("graphml".equals(outputFormat) || "tei".equals(outputFormat)) {
                    XMLStreamWriter xml = null;
                    try {
                        xml = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
                        xml.writeStartDocument(outputCharset.name(), "1.0");
                        if ("graphml".equals(outputFormat)) {
                            serializer.toGraphML(xml);
                        } else {
                            serializer.toTEI(xml);
                        }
                        xml.writeEndDocument();
                        break block76;
                    }
                    catch (XMLStreamException e) {
                        throw new IOException(e);
                    }
                    finally {
                        if (xml != null) {
                            try {
                                xml.close();
                            }
                            catch (XMLStreamException xMLStreamException) {}
                        }
                    }
                }
                JsonProcessor.write(variantGraph, out);
            }
        }
    }

    private static URL argumentToInput(String arg) throws MalformedURLException {
        File witnessFile = new File(arg);
        if (witnessFile.exists()) {
            return witnessFile.toURI().normalize().toURL();
        }
        return new URL(arg);
    }

    private static PrintWriter argumentToOutput(String arg, Charset outputCharset) throws ParseException, IOException {
        if ("-".equals(arg)) {
            return new PrintWriter(new OutputStreamWriter((OutputStream)System.out, outputCharset));
        }
        File outFile = new File(arg);
        try {
            return new PrintWriter(Files.newBufferedWriter(outFile.toPath(), outputCharset, new OpenOption[0]));
        }
        catch (FileNotFoundException e) {
            throw new ParseException("Output file '" + outFile + "' not found");
        }
    }
}

