/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.tools;

import eu.interedition.collatex.CollationAlgorithm;
import eu.interedition.collatex.CollationAlgorithmFactory;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.dekker.DekkerAlgorithm;
import eu.interedition.collatex.matching.EditDistanceTokenComparator;
import eu.interedition.collatex.matching.EqualityTokenComparator;
import eu.interedition.collatex.simple.SimpleCollation;
import eu.interedition.collatex.simple.SimplePatternTokenizer;
import eu.interedition.collatex.simple.SimpleToken;
import eu.interedition.collatex.simple.SimpleTokenNormalizers;
import eu.interedition.collatex.simple.SimpleWitness;
import eu.interedition.collatex.util.ParallelSegmentationApparatus;
import eu.interedition.collatex.util.VariantGraphRanking;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;

public class JsonProcessor {
    public static SimpleCollation read(InputStream inputStream) throws IOException {
        try (JsonReader reader = Json.createReader(inputStream);){
            JsonArray witnessesNode;
            JsonStructure collationNode = reader.read();
            if (collationNode.getValueType() != JsonValue.ValueType.OBJECT) {
                throw new IOException("Expecting JSON object");
            }
            JsonObject collationObject = (JsonObject)collationNode;
            try {
                witnessesNode = collationObject.getJsonArray("witnesses");
            }
            catch (ClassCastException e) {
                throw new IOException("Expecting 'witnesses' array");
            }
            ArrayList<SimpleWitness> witnesses = new ArrayList<SimpleWitness>(witnessesNode.size());
            for (JsonValue witnessNode : witnessesNode) {
                String witnessId;
                if (witnessNode.getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IOException("Expecting witness object");
                }
                JsonObject witnessObject = (JsonObject)witnessNode;
                try {
                    witnessId = witnessObject.getString("id").trim();
                }
                catch (ClassCastException e) {
                    throw new IOException("Expected textual witness 'id'");
                }
                if (witnessId.length() == 0) {
                    throw new IOException("Empty witness 'id' encountered");
                }
                SimpleWitness witness = new SimpleWitness(witnessId);
                if (witnesses.contains(witness)) {
                    throw new IOException(String.format("Duplicate sigil for witness '%s", witness));
                }
                JsonValue contentNode = (JsonValue)witnessObject.get("content");
                JsonValue tokensNode = (JsonValue)witnessObject.get("tokens");
                if (contentNode == null && tokensNode == null) {
                    throw new IOException(String.format("Expected either 'tokens' or 'content' field in witness \"%s\"", witness));
                }
                if (tokensNode != null) {
                    if (tokensNode.getValueType() != JsonValue.ValueType.ARRAY) {
                        throw new IOException(String.format("Expected 'tokens' array in witness \"%s\"", witness));
                    }
                    JsonArray tokensArray = (JsonArray)tokensNode;
                    ArrayList<eu.interedition.collatex.Token> tokens = new ArrayList<eu.interedition.collatex.Token>(tokensArray.size());
                    for (JsonValue tokenNode : tokensArray) {
                        String normalizedTokenContent;
                        String tokenContent;
                        if (tokenNode.getValueType() != JsonValue.ValueType.OBJECT) {
                            throw new IOException(String.format("Expected token object in 'tokens' field in witness \"%s\"", witness));
                        }
                        JsonObject tokenObject = (JsonObject)tokenNode;
                        try {
                            tokenContent = tokenObject.getString("t");
                        }
                        catch (ClassCastException | NullPointerException e) {
                            throw new IOException(String.format("Expected textual token content field 't' in witness \"%s\"", witness));
                        }
                        if (tokenObject.containsKey("n")) {
                            try {
                                normalizedTokenContent = tokenObject.getString("n");
                            }
                            catch (ClassCastException e) {
                                throw new IOException(String.format("Expected textual normalized token content in witness \"%s\"", witness));
                            }
                        } else {
                            normalizedTokenContent = SimpleWitness.TOKEN_NORMALIZER.apply(tokenContent);
                        }
                        if (normalizedTokenContent == null || normalizedTokenContent.length() == 0) {
                            throw new IOException(String.format("Empty token encountered in witness \"%s\"", witness));
                        }
                        tokens.add(new Token(witness, tokenContent, normalizedTokenContent, tokenObject));
                    }
                    witness.setTokens(tokens);
                } else {
                    if (contentNode.getValueType() != JsonValue.ValueType.STRING) {
                        throw new IOException(String.format("Expected 'content' text field in witness \"%s\"", witness));
                    }
                    witness.setTokenContents(SimplePatternTokenizer.BY_WS_OR_PUNCT.apply(((JsonString)contentNode).getString()), SimpleTokenNormalizers.LC_TRIM_WS);
                }
                witnesses.add(witness);
            }
            if (witnesses.isEmpty()) {
                throw new IOException("No witnesses in collation");
            }
            Comparator<eu.interedition.collatex.Token> tokenComparator = null;
            JsonValue tokenComparatorNode = (JsonValue)collationObject.get("tokenComparator");
            if (tokenComparatorNode != null && tokenComparatorNode.getValueType() == JsonValue.ValueType.OBJECT) {
                JsonObject tokenComparatorObject = (JsonObject)tokenComparatorNode;
                try {
                    if ("levenshtein".equals(tokenComparatorObject.getString("type"))) {
                        int configuredDistance = tokenComparatorObject.getInt("distance", 0);
                        tokenComparator = new EditDistanceTokenComparator(configuredDistance == 0 ? 1 : configuredDistance);
                    }
                }
                catch (ClassCastException configuredDistance) {
                    // empty catch block
                }
            }
            if (tokenComparator == null) {
                tokenComparator = new EqualityTokenComparator();
            }
            CollationAlgorithm collationAlgorithm = null;
            JsonValue collationAlgorithmNode = (JsonValue)collationObject.get("algorithm");
            if (collationAlgorithmNode != null && collationAlgorithmNode.getValueType() == JsonValue.ValueType.STRING) {
                String collationAlgorithmValue = ((JsonString)collationAlgorithmNode).getString();
                if ("needleman-wunsch".equalsIgnoreCase(collationAlgorithmValue)) {
                    collationAlgorithm = CollationAlgorithmFactory.needlemanWunsch(tokenComparator);
                } else if ("gst".equalsIgnoreCase(collationAlgorithmValue)) {
                    collationAlgorithm = CollationAlgorithmFactory.greedyStringTiling(tokenComparator, 2);
                } else if ("medite".equalsIgnoreCase(collationAlgorithmValue)) {
                    collationAlgorithm = CollationAlgorithmFactory.medite(tokenComparator, SimpleToken.TOKEN_MATCH_EVALUATOR);
                }
            }
            if (collationAlgorithm == null) {
                collationAlgorithm = CollationAlgorithmFactory.dekker(tokenComparator);
            }
            boolean joined = true;
            try {
                joined = collationObject.getBoolean("joined", true);
            }
            catch (ClassCastException contentNode) {
                // empty catch block
            }
            if (collationAlgorithm instanceof DekkerAlgorithm) {
                boolean mergeTranspositions = true;
                try {
                    mergeTranspositions = collationObject.getBoolean("transpositions", true);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                ((DekkerAlgorithm)collationAlgorithm).setMergeTranspositions(mergeTranspositions);
            }
            SimpleCollation simpleCollation = new SimpleCollation(witnesses, collationAlgorithm, joined);
            return simpleCollation;
        }
    }

    public static void write(VariantGraph graph, OutputStream outputStream) throws IOException {
        try (JsonGenerator jgen = Json.createGenerator(outputStream);){
            JsonProcessor.write(jgen, graph);
        }
    }

    public static void write(VariantGraph graph, PrintWriter writer) throws IOException {
        try (JsonGenerator jgen = Json.createGenerator(writer);){
            JsonProcessor.write(jgen, graph);
        }
    }

    protected static void write(final JsonGenerator jgen, final VariantGraph graph) {
        ParallelSegmentationApparatus.generate(VariantGraphRanking.of(graph), new ParallelSegmentationApparatus.GeneratorCallback(){

            @Override
            public void start() {
                jgen.writeStartObject();
                jgen.writeStartArray("witnesses");
                graph.witnesses().stream().sorted(Witness.SIGIL_COMPARATOR).map(Witness::getSigil).forEach(jgen::write);
                jgen.writeEnd();
                jgen.writeStartArray("table");
            }

            @Override
            public void segment(SortedMap<Witness, Iterable<eu.interedition.collatex.Token>> contents) {
                jgen.writeStartArray();
                contents.values().stream().forEach(tokens -> {
                    jgen.writeStartArray();
                    StreamSupport.stream(Spliterators.spliteratorUnknownSize(tokens.iterator(), 1280), false).filter(t -> t instanceof SimpleToken).map(t -> (SimpleToken)t).sorted().forEach(t -> {
                        if (t instanceof Token) {
                            jgen.write(((Token)t).getJsonNode());
                        } else {
                            jgen.write(t.getContent());
                        }
                    });
                    jgen.writeEnd();
                });
                jgen.writeEnd();
            }

            @Override
            public void end() {
                jgen.writeEnd();
                jgen.writeEnd();
            }
        });
    }

    private JsonProcessor() {
    }

    public static class Token
    extends SimpleToken {
        private final JsonObject jsonNode;

        public Token(SimpleWitness witness, String content, String normalized, JsonObject jsonNode) {
            super(witness, content, normalized);
            this.jsonNode = jsonNode;
        }

        public JsonObject getJsonNode() {
            return this.jsonNode;
        }
    }
}

