/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.tools;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.simple.SimpleToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class PluginScript {
    static final Charset SCRIPT_CHARSET = Charset.forName("UTF-8");
    static final String TOKENIZER_FUNCTION = "tokenize";
    static final String NORMALIZER_FUNCTION = "normalize";
    static final String COMPARATOR_FUNCTION = "compare";
    final Invocable script;
    final boolean tokenizer;
    final boolean normalizer;
    final boolean comparator;

    public static PluginScript read(URL source) throws ScriptException, IOException {
        try (BufferedReader sourceReader = new BufferedReader(new InputStreamReader(source.openStream(), SCRIPT_CHARSET));){
            PluginScript pluginScript = PluginScript.read(source.toString(), sourceReader);
            return pluginScript;
        }
    }

    public static PluginScript read(String filename, Reader source) throws ScriptException, IOException {
        ScriptEngine scriptEngine = Objects.requireNonNull(new ScriptEngineManager().getEngineByExtension("js"));
        scriptEngine.put("javax.script.filename", filename);
        CompiledScript script = ((Compilable)((Object)scriptEngine)).compile(source);
        script.eval();
        return new PluginScript((Invocable)((Object)script.getEngine()));
    }

    PluginScript(Invocable script) throws ScriptException {
        this.script = script;
        this.tokenizer = this.hasFunction(TOKENIZER_FUNCTION, "");
        this.normalizer = this.hasFunction(NORMALIZER_FUNCTION, "");
        this.comparator = this.hasFunction(COMPARATOR_FUNCTION, "", "");
    }

    Function<String, Stream<String>> tokenizer() {
        return this.tokenizer ? new Function<String, Stream<String>>(){

            @Override
            public Stream<String> apply(String input) {
                Object result = PluginScript.this.invoke(PluginScript.TOKENIZER_FUNCTION, input);
                if (!(result instanceof Iterable)) {
                    throw new PluginScriptExecutionException("Wrong result type of tokenize(); expected an iterable type, found " + result.getClass());
                }
                LinkedList<String> tokens = new LinkedList<String>();
                for (Object token : (Iterable)result) {
                    if (token == null) {
                        throw new PluginScriptExecutionException("tokenize() returned null token");
                    }
                    if (!(token instanceof String)) {
                        throw new PluginScriptExecutionException("Wrong result type of tokenize(); expected tokens of type string, found " + token.getClass());
                    }
                    tokens.add((String)token);
                }
                return tokens.stream();
            }
        } : null;
    }

    Function<String, String> normalizer() {
        return this.normalizer ? new Function<String, String>(){

            @Override
            public String apply(String input) {
                Object result = PluginScript.this.invoke(PluginScript.NORMALIZER_FUNCTION, input);
                if (!(result instanceof String)) {
                    throw new PluginScriptExecutionException("Wrong result type of normalize(); expected a string, found " + result.getClass());
                }
                return (String)result;
            }
        } : null;
    }

    Comparator<Token> comparator() {
        return this.comparator ? new Comparator<Token>(){

            @Override
            public int compare(Token o1, Token o2) {
                if (!(o1 instanceof SimpleToken)) {
                    throw new PluginScriptExecutionException("compare() called with wrong token type '" + o1.getClass());
                }
                if (!(o2 instanceof SimpleToken)) {
                    throw new PluginScriptExecutionException("compare() called with wrong token type '" + o2.getClass());
                }
                Object result = PluginScript.this.invoke(PluginScript.COMPARATOR_FUNCTION, ((SimpleToken)o1).getNormalized(), ((SimpleToken)o2).getNormalized());
                if (result instanceof Number) {
                    return ((Number)result).intValue();
                }
                if (result instanceof Boolean) {
                    return (Boolean)result != false ? 0 : 1;
                }
                throw new PluginScriptExecutionException("Wrong result type of compare(); expected a number or boolean type, found " + result.getClass());
            }
        } : null;
    }

    boolean hasFunction(String name, Object ... testArgs) throws ScriptException {
        try {
            this.script.invokeFunction(name, testArgs);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    Object invoke(String function, Object ... args) throws PluginScriptExecutionException {
        try {
            Object result = this.script.invokeFunction(function, args);
            if (result == null) {
                throw new PluginScriptExecutionException(function + "() returned null");
            }
            return result;
        }
        catch (ScriptException e) {
            throw new PluginScriptExecutionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    static class PluginScriptExecutionException
    extends RuntimeException {
        PluginScriptExecutionException(String message) {
            super(message);
        }

        PluginScriptExecutionException(ScriptException scriptException) {
            super(scriptException);
        }
    }
}

