/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.util;

import eu.interedition.collatex.CollationAlgorithm;
import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.util.VariantGraphRanking;
import eu.interedition.collatex.util.VertexMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.StreamSupport;

public class GreedyStringTilingAlgorithm
extends CollationAlgorithm.Base {
    private final Comparator<Token> comparator;
    private final int minimumTileLength;
    private final Equality<VariantGraph.Vertex[], Token> equality = new Equality<VariantGraph.Vertex[], Token>(){

        @Override
        public boolean isEqual(VariantGraph.Vertex[] a, Token b) {
            for (VariantGraph.Vertex vertex : a) {
                Set<Token> tokens = vertex.tokens();
                if (tokens.isEmpty() || GreedyStringTilingAlgorithm.this.comparator.compare(tokens.stream().findFirst().get(), b) != 0) continue;
                return true;
            }
            return false;
        }
    };

    public GreedyStringTilingAlgorithm(Comparator<Token> comparator, int minimumTileLength) {
        this.comparator = comparator;
        this.minimumTileLength = minimumTileLength;
    }

    @Override
    public void collate(VariantGraph graph, Iterable<Token> witness) {
        VariantGraph.Vertex[][] vertices = VariantGraphRanking.of(graph).asArray();
        Token[] tokens = (Token[])StreamSupport.stream(witness.spliterator(), false).toArray(Token[]::new);
        TreeSet<SortedSet<VertexMatch.WithTokenIndex>> matches = new TreeSet<SortedSet<VertexMatch.WithTokenIndex>>(VertexMatch.setComparator());
        for (Match match : GreedyStringTilingAlgorithm.match(vertices, tokens, this.equality, this.minimumTileLength)) {
            TreeSet<VertexMatch.WithTokenIndex> phrase = new TreeSet<VertexMatch.WithTokenIndex>();
            int ml = match.length;
            for (int mc = 0; mc < ml; ++mc) {
                int rank = match.left + mc;
                phrase.add(new VertexMatch.WithTokenIndex(vertices[rank][0], rank, match.right + mc));
            }
            matches.add(phrase);
        }
        this.merge(graph, vertices, tokens, matches);
    }

    public static <A, B> SortedSet<Match> match(A[] left, B[] right, Equality<A, B> equality, int minimumTileLength) {
        int maxMatchLength;
        boolean[] markedLeft = new boolean[left.length];
        boolean[] markedRight = new boolean[right.length];
        Arrays.fill(markedLeft, false);
        Arrays.fill(markedRight, false);
        TreeSet<Match> matches = new TreeSet<Match>();
        HashMap<Integer, List<Match>> matchesByLength = new HashMap<Integer, List<Match>>();
        do {
            int tc;
            maxMatchLength = minimumTileLength;
            for (int rc = 0; rc < right.length; ++rc) {
                for (int lc = 0; lc < left.length; ++lc) {
                    int matchLength = 0;
                    tc = 0;
                    while (tc + lc < left.length && tc + rc < right.length && !markedLeft[lc + tc] && !markedRight[rc + tc] && equality.isEqual(left[lc + tc], right[rc + tc])) {
                        ++matchLength;
                        ++tc;
                    }
                    if (matchLength >= maxMatchLength) {
                        ArrayList<Match> theMatches = (ArrayList<Match>)matchesByLength.get(matchLength);
                        if (theMatches == null) {
                            theMatches = new ArrayList<Match>();
                            matchesByLength.put(matchLength, theMatches);
                        }
                        theMatches.add(new Match(lc, rc));
                    }
                    if (matchLength <= maxMatchLength) continue;
                    maxMatchLength = matchLength;
                }
            }
            for (Match match : matchesByLength.getOrDefault(maxMatchLength, Collections.emptyList())) {
                boolean occluded = false;
                for (tc = 0; tc < maxMatchLength; ++tc) {
                    if (!markedLeft[match.left + tc] && !markedRight[match.right + tc]) continue;
                    occluded = true;
                    break;
                }
                if (occluded) continue;
                for (tc = 0; tc < maxMatchLength; ++tc) {
                    markedLeft[match.left + tc] = true;
                    markedRight[match.right + tc] = true;
                }
                matches.add(new Match(match.left, match.right, maxMatchLength));
            }
        } while (maxMatchLength > minimumTileLength);
        return matches;
    }

    public static class Match
    implements Comparable<Match> {
        public final int left;
        public final int right;
        public final int length;

        public Match(int left, int right, int length) {
            this.left = left;
            this.right = right;
            this.length = length;
        }

        public Match(int left, int right) {
            this(left, right, 0);
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof Match) {
                return this.left == ((Match)obj).left;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.left;
        }

        @Override
        public int compareTo(Match o) {
            return this.left - o.left;
        }
    }

    public static interface Equality<A, B> {
        public boolean isEqual(A var1, B var2);
    }
}

