/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.util;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.Witness;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class VariantGraphRanking
implements Iterable<Set<VariantGraph.Vertex>>,
Function<VariantGraph.Vertex, Integer> {
    private final Map<VariantGraph.Vertex, Integer> byVertex = new HashMap<VariantGraph.Vertex, Integer>();
    private final SortedMap<Integer, Set<VariantGraph.Vertex>> byRank = new TreeMap<Integer, Set<VariantGraph.Vertex>>();
    private final VariantGraph graph;

    VariantGraphRanking(VariantGraph graph) {
        this.graph = graph;
    }

    public static VariantGraphRanking of(VariantGraph graph) {
        VariantGraphRanking ranking = new VariantGraphRanking(graph);
        for (VariantGraph.Vertex v : graph.vertices()) {
            int rank = -1;
            for (VariantGraph.Vertex incoming : v.incoming().keySet()) {
                rank = Math.max(rank, ranking.byVertex.get(incoming));
            }
            ranking.byVertex.put(v, ++rank);
            ranking.byRank.computeIfAbsent(rank, r -> new HashSet()).add(v);
        }
        return ranking;
    }

    public static VariantGraphRanking ofOnlyCertainVertices(VariantGraph graph, Set<VariantGraph.Vertex> vertices) {
        VariantGraphRanking ranking = new VariantGraphRanking(graph);
        for (VariantGraph.Vertex v : graph.vertices()) {
            int rank = -1;
            for (VariantGraph.Vertex incoming : v.incoming().keySet()) {
                rank = Math.max(rank, ranking.byVertex.get(incoming));
            }
            if (vertices.contains(v)) {
                ++rank;
            }
            ranking.byVertex.put(v, rank);
            ranking.byRank.computeIfAbsent(rank, r -> new HashSet()).add(v);
        }
        return ranking;
    }

    public Set<Witness> witnesses() {
        return this.graph.witnesses();
    }

    public Map<VariantGraph.Vertex, Integer> getByVertex() {
        return Collections.unmodifiableMap(this.byVertex);
    }

    public Map<Integer, Set<VariantGraph.Vertex>> getByRank() {
        return Collections.unmodifiableMap(this.byRank);
    }

    public int size() {
        return this.byRank.keySet().size();
    }

    @Override
    public Iterator<Set<VariantGraph.Vertex>> iterator() {
        return this.byRank.values().iterator();
    }

    public List<SortedMap<Witness, Set<Token>>> asTable() {
        return this.byRank.values().stream().filter(rank -> rank.stream().anyMatch(v -> !v.tokens().isEmpty())).map(vertices -> {
            TreeMap row = new TreeMap(Witness.SIGIL_COMPARATOR);
            vertices.stream().flatMap(v -> v.tokens().stream()).forEach(token -> row.computeIfAbsent(token.getWitness(), w -> new HashSet()).add(token));
            return row;
        }).collect(Collectors.toList());
    }

    public VariantGraph.Vertex[][] asArray() {
        VariantGraph.Vertex[][] arr = new VariantGraph.Vertex[this.byRank.size()][];
        this.byRank.forEach((? super K rank, ? super V vertices) -> {
            vertexArray[rank.intValue()] = vertices.toArray(new VariantGraph.Vertex[vertices.size()]);
        });
        return arr;
    }

    @Override
    public Integer apply(VariantGraph.Vertex vertex) {
        return this.byVertex.get(vertex);
    }

    public Comparator<VariantGraph.Vertex> comparator() {
        return Comparator.comparingInt(this.byVertex::get);
    }
}

