/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.util;

import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.Witness;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;

public class VariantGraphTraversal
implements Iterable<VariantGraph.Vertex> {
    private final VariantGraph graph;
    private final Set<Witness> witnesses;

    private VariantGraphTraversal(VariantGraph graph, Set<Witness> witnesses) {
        this.graph = graph;
        this.witnesses = witnesses;
    }

    public static VariantGraphTraversal of(VariantGraph graph, Set<Witness> witnesses) {
        return new VariantGraphTraversal(graph, witnesses);
    }

    public static VariantGraphTraversal of(VariantGraph graph) {
        return new VariantGraphTraversal(graph, null);
    }

    @Override
    public Iterator<VariantGraph.Vertex> iterator() {
        return new Iterator<VariantGraph.Vertex>(){
            private final Map<VariantGraph.Vertex, Long> encountered = new HashMap<VariantGraph.Vertex, Long>();
            private final Queue<VariantGraph.Vertex> queue = new ArrayDeque<VariantGraph.Vertex>();
            private Optional<VariantGraph.Vertex> next = Optional.of(VariantGraphTraversal.access$000(VariantGraphTraversal.this).getStart());

            @Override
            public boolean hasNext() {
                return this.next.isPresent();
            }

            @Override
            public VariantGraph.Vertex next() {
                VariantGraph.Vertex next = this.next.get();
                for (Map.Entry<VariantGraph.Vertex, Set<Witness>> edge : next.outgoing().entrySet()) {
                    if (VariantGraphTraversal.this.witnesses != null) {
                        if (!edge.getValue().stream().anyMatch(VariantGraphTraversal.this.witnesses::contains)) continue;
                    }
                    VariantGraph.Vertex end = edge.getKey();
                    long endEncountered = Optional.ofNullable(this.encountered.get(end)).orElse(0L);
                    long endIncoming = end.incoming().entrySet().stream().filter(e -> {
                        if (VariantGraphTraversal.this.witnesses == null) return true;
                        if (!((Set)e.getValue()).stream().anyMatch(VariantGraphTraversal.this.witnesses::contains)) return false;
                        return true;
                    }).count();
                    if (endIncoming == endEncountered) {
                        throw new IllegalStateException(String.format("Encountered cycle traversing %s to %s", edge, end));
                    }
                    if (endIncoming - endEncountered == 1L) {
                        this.queue.add(end);
                    }
                    this.encountered.put(end, endEncountered + 1L);
                }
                this.next = Optional.ofNullable(this.queue.poll());
                return next;
            }
        };
    }

    static /* synthetic */ VariantGraph access$000(VariantGraphTraversal x0) {
        return x0.graph;
    }
}

