/*
 * Decompiled with CFR 0.152.
 */
package eu.kratochvil.util;

import eu.kratochvil.util.Decorator;
import eu.kratochvil.util.SoapUtils;
import eu.kratochvil.util.decorator.GuidDecorator;
import eu.kratochvil.util.decorator.TimeDecorator;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUtils {
    private static final Logger logger = LoggerFactory.getLogger(CsvUtils.class);
    private static Map<String, List<String>> cachedFiles = new HashMap<String, List<String>>();
    private static Map<String, Decorator> decorators = new HashMap<String, Decorator>();

    protected static String[] readHeader(String filename) throws IOException {
        URL url = SoapUtils.class.getResource(filename);
        if (url == null) {
            throw new FileNotFoundException(filename);
        }
        if (cachedFiles.get(url.getFile()) == null) {
            InputStream is = SoapUtils.class.getResourceAsStream(filename);
            CsvUtils.loadFile(url.getFile(), is);
        }
        String header = cachedFiles.get(url.getFile()).get(0);
        return header.split(",");
    }

    public static Map<String, String> read(String filename, int row) throws IOException {
        URL url = CsvUtils.class.getResource(filename);
        if (url == null) {
            throw new FileNotFoundException(filename);
        }
        if (cachedFiles.get(CsvUtils.class.getResource(filename).getFile()) == null) {
            InputStream is = CsvUtils.class.getResourceAsStream(filename);
            CsvUtils.loadFile(url.getFile(), is);
        }
        String[] header = CsvUtils.readHeader(filename);
        String[] data = cachedFiles.get(url.getFile()).get(row).split(",");
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < header.length; ++i) {
            if (decorators.get(data[i].trim()) != null) {
                result.put(header[i], decorators.get(data[i].trim()).getValue());
                continue;
            }
            result.put(header[i], data[i].trim());
        }
        return result;
    }

    public static void registerDecorator(Decorator decorator) {
        decorators.put("#" + decorator.supportedKey() + "#", decorator);
    }

    private static void loadFile(String filename, InputStream is) throws IOException {
        logger.trace("Loading file: " + is);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String strLine = null;
        ArrayList<String> file = new ArrayList<String>();
        while ((strLine = br.readLine()) != null) {
            file.add(strLine);
        }
        cachedFiles.put(filename, file);
    }

    static {
        CsvUtils.registerDecorator(new GuidDecorator());
        CsvUtils.registerDecorator(new TimeDecorator());
    }
}

