/*
 * Decompiled with CFR 0.152.
 */
package eu.kratochvil.util;

import eu.kratochvil.util.CsvUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class SoapUtils {
    private static Map<String, String> fileCache = new HashMap<String, String>();

    public static String getSoapFromFile(String filenameXml, String filenameData, int row) throws IOException {
        return SoapUtils.parsePlaceholders(filenameXml, CsvUtils.read(filenameData, row));
    }

    protected static String parsePlaceholders(String filename, Map<String, String> params) throws IOException {
        String request;
        URL url = SoapUtils.class.getResource(filename);
        if (url == null) {
            throw new FileNotFoundException(filename);
        }
        if (fileCache.get(url.getFile()) != null) {
            request = fileCache.get(url.getFile());
        } else {
            request = SoapUtils.readFileAsString(SoapUtils.class.getResourceAsStream(filename));
            fileCache.put(url.getFile(), request);
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            request = request.replaceAll(SoapUtils.placeholder(entry.getKey()), entry.getValue().trim());
        }
        return request;
    }

    private static String placeholder(String placeholder) {
        return new StringBuffer().append("\\$\\{").append(placeholder).append("\\}").toString();
    }

    private static String readFileAsString(InputStream is) throws IOException {
        int read;
        char[] buffer = new char[4096];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        return out.toString();
    }
}

