/*
 * Decompiled with CFR 0.152.
 */
package eu.kratochvil.util;

import eu.kratochvil.util.ObjectUtils;
import eu.kratochvil.util.helpers.MessageFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    private static final String IS_XML_PATTERN_STR = "<(\\S+?)(.*?)>(.*?)</\\1>";
    private static final Pattern isXmlPattern = Pattern.compile("<(\\S+?)(.*?)>(.*?)</\\1>", 42);
    private static final String PATH_TRANSFORMATION_PATTERN = "[^a-z^A-Z^0-9^.]";
    private static final String PATH_TRANSFORMATION_FOLDER_SEPARATOR_PATTERN = "[/\\\\]";
    private static final String PATH_TRANSFORMATION_PACKAGE_SEPARATOR = ".";
    private static final String PATH_TRANSFORMATION_UNIVERSAL_CHAR = "_";

    public static String transformToPackageName(String path) {
        String result = path.replaceAll(PATH_TRANSFORMATION_FOLDER_SEPARATOR_PATTERN, PATH_TRANSFORMATION_PACKAGE_SEPARATOR).replaceAll(PATH_TRANSFORMATION_PATTERN, PATH_TRANSFORMATION_UNIVERSAL_CHAR);
        if (result.startsWith(PATH_TRANSFORMATION_PACKAGE_SEPARATOR)) {
            return result.substring(1);
        }
        return result;
    }

    public static boolean isXmlLike(String xmlString) {
        if (xmlString != null && xmlString.trim().length() > 0) {
            if (xmlString.startsWith("<?")) {
                if (xmlString.indexOf("?>") < 0) {
                    return false;
                }
                xmlString = xmlString.substring(xmlString.indexOf("?>") + 2);
            }
            if (xmlString.trim().startsWith("<")) {
                Matcher matcher = isXmlPattern.matcher(xmlString);
                return matcher.matches();
            }
        }
        return false;
    }

    public static String notBlankValue(String value, String replaceWith) {
        if (StringUtils.isBlank((String)value)) {
            return replaceWith;
        }
        return value;
    }

    public static String nullValue(String value, String replaceWith) {
        return (String)ObjectUtils.defaultIfNull((Object)value, (Object)replaceWith);
    }

    public static String withArgs(String value, Object[] argArray) {
        return MessageFormatter.arrayFormat(value, argArray);
    }

    public static String withArgs(String value, Object arg1, Object arg2) {
        return StringUtils.withArgs(value, new Object[]{arg1, arg2});
    }

    public static final String withArgs(String value, Object arg) {
        return StringUtils.withArgs(value, new Object[]{arg});
    }
}

