/*
 * Decompiled with CFR 0.152.
 */
package de.dailyfratze.text;

import java.util.Optional;

public final class Strings {
    private Strings() {
    }

    public static String truncate(String in, int length) {
        return Strings.truncate(in, length, Optional.of("\u2026"));
    }

    public static String truncate(String in, int length, Optional<String> ellipsis) {
        String _ellipsis = ellipsis.orElse("");
        int maxLength = length - _ellipsis.codePointCount(0, _ellipsis.length());
        if (maxLength < 0) {
            throw new IllegalArgumentException("Cannot truncate string to length < 0");
        }
        String rv = in;
        if (in.codePointCount(0, in.length()) > length) {
            rv = new String(in.codePoints().limit(maxLength).toArray(), 0, maxLength) + _ellipsis;
        }
        return rv;
    }
}

