/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimweb;

import eu.miltema.cpscan.ClassScanner;
import eu.miltema.cpscan.FileContentSupplier;
import eu.miltema.slimweb.ApplicationInitializer;
import eu.miltema.slimweb.annot.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ComponentsReader {
    private static Collection<Class<?>> cachedComponents;
    private Consumer<String> logger;
    private ApplicationInitializer initializer;

    public ComponentsReader(Consumer<String> logger) {
        this.logger = logger;
    }

    public Stream<Class<?>> getComponentsAsStream() throws Exception {
        if (cachedComponents != null) {
            return cachedComponents.stream();
        }
        try {
            this.logger.accept("Looking for SlimwebInitializer");
            new ClassScanner(this.logger){

                protected Class<?> entryFound(String relativePath, FileContentSupplier fileContentSupplier) {
                    if (!relativePath.endsWith("SlimwebInitializer.class")) {
                        return null;
                    }
                    Class initializerClass = super.entryFound(relativePath, fileContentSupplier);
                    try {
                        ComponentsReader.this.initializer = (ApplicationInitializer)initializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        throw new InitializerFoundException();
                    }
                    catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException("Unable to instantiate initializer class " + initializerClass.getName() + ", which must implement interface ApplicationInitializer", e);
                    }
                }
            }.scan(new String[0]);
            throw new Exception("Could not find class SlimwebInitializer; unable to initialize Slimweb");
        }
        catch (InitializerFoundException initializerFoundException) {
            cachedComponents = new ArrayList();
            this.logger.accept("Looking for @Component classes");
            return new ClassScanner(this.logger).scan(this.initializer.getComponentPackages()).filter(c -> c.isAnnotationPresent(Component.class)).peek(c -> cachedComponents.add((Class<?>)c));
        }
    }

    public ApplicationInitializer getInitializer() {
        return this.initializer;
    }

    private class InitializerFoundException
    extends RuntimeException {
        private InitializerFoundException() {
        }
    }
}

