/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimweb.common;

import eu.miltema.slimweb.HttpException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpAccessor {
    private static final String SESSION_OBJECT = "__SESSION_OBJECT";
    private static final String SESSION_LANGUAGE = "__SESSION_LANGUAGE";
    private static final Logger log = LoggerFactory.getLogger(HttpAccessor.class);
    public HttpServletRequest request;
    public HttpServletResponse response;
    private String pi;
    private String[] pathInfo;
    private String httpMethod;

    public HttpAccessor init(HttpServletRequest request) {
        this.request = request;
        return this;
    }

    public HttpAccessor init(HttpServletRequest request, HttpServletResponse response, String httpMethod) {
        this.request = request;
        this.response = response;
        this.httpMethod = httpMethod;
        this.pi = request.getPathInfo();
        return this;
    }

    public String getComponentName() {
        if (this.pathInfo == null) {
            if (this.pi == null) {
                throw new HttpException(404, "Missing component name in URL", new String[0]);
            }
            this.pathInfo = this.request.getPathInfo().split("/");
        }
        return this.pathInfo[1];
    }

    public String getActionName() {
        return this.pathInfo.length > 2 ? this.pathInfo[2] : null;
    }

    public String getUrl() {
        String q = this.request.getQueryString();
        return this.request.getServletPath() + (this.pi == null ? "" : this.pi) + (String)(q == null ? "" : "?" + q);
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public void setSessionObject(Object sessionObject) {
        HttpSession session = this.request.getSession();
        session.setAttribute(SESSION_OBJECT, sessionObject);
    }

    public Object getSessionObject() {
        HttpSession session = this.request.getSession(false);
        return session == null ? null : session.getAttribute(SESSION_OBJECT);
    }

    public void terminateSession() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public String getLanguage() {
        HttpSession session = this.request.getSession(false);
        String language = session == null ? this.request.getLocale().getLanguage() : (String)session.getAttribute(SESSION_LANGUAGE);
        return language == null ? "en" : language;
    }

    public void setLanguage(String language) throws IllegalStateException {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("Missing session");
        }
        session.setAttribute(SESSION_LANGUAGE, (Object)language);
    }

    public HttpAccessor detectCsrf(String[] validOriginPrefixes) throws ServletException {
        if (this.request.getSession(false) == null || validOriginPrefixes == null) {
            return this;
        }
        String origin = this.request.getHeader("Origin");
        String referer = this.request.getHeader("Referer");
        boolean accepted = false;
        for (String mandatoryOriginPrefix : validOriginPrefixes) {
            if (referer != null && origin != null) {
                accepted = mandatoryOriginPrefix.equals(origin) && referer.startsWith(mandatoryOriginPrefix);
            } else if (origin != null) {
                accepted = mandatoryOriginPrefix.equals(origin);
            } else if (referer != null) {
                accepted = referer.startsWith(mandatoryOriginPrefix);
            }
            if (!accepted) continue;
            return this;
        }
        log.warn("CSRF detected, details: origin=" + origin + ", referer=" + referer + ", remoteIp=" + this.request.getRemoteAddr());
        throw new ServletException("CSRF attack detected");
    }

    public abstract String getParametersAsJson();

    public abstract String getParameter(String var1);
}

