/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimweb.controller;

import eu.miltema.slimweb.annot.Component;
import eu.miltema.slimweb.annot.SessionNotRequired;
import eu.miltema.slimweb.common.SlimwebUtil;
import eu.miltema.slimweb.controller.MethodDef;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class ComponentDef {
    Class<?> clazz;
    boolean requiresSession;
    String url;
    Map<String, MethodDef> methods = new HashMap<String, MethodDef>();

    ComponentDef(Class<?> clazz) {
        this.clazz = clazz;
        this.requiresSession = !clazz.isAnnotationPresent(SessionNotRequired.class);
        this.url = clazz.getAnnotation(Component.class).urlName();
        if (this.url.isEmpty()) {
            this.url = SlimwebUtil.hyphenate(clazz.getSimpleName());
        }
        for (Method method : clazz.getMethods()) {
            MethodDef mdef = new MethodDef(method);
            Object name = method.getName();
            if (((String)name).startsWith("get")) {
                name = "get:" + SlimwebUtil.hyphenate(((String)name).substring(3));
            } else if (((String)name).startsWith("delete")) {
                name = "delete:" + SlimwebUtil.hyphenate(((String)name).substring(6));
            } else if (((String)name).startsWith("post")) {
                name = "post:" + SlimwebUtil.hyphenate(((String)name).substring(4));
            } else {
                if (!((String)name).startsWith("put")) continue;
                name = "put:" + SlimwebUtil.hyphenate(((String)name).substring(3));
            }
            this.methods.put((String)name, mdef);
        }
    }
}

