/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimweb.controller;

import com.google.gson.Gson;
import eu.miltema.slimweb.ApplicationInitializer;
import eu.miltema.slimweb.ArgumentInjector;
import eu.miltema.slimweb.ComponentsReader;
import eu.miltema.slimweb.HttpException;
import eu.miltema.slimweb.common.HttpAccessor;
import eu.miltema.slimweb.controller.ComponentDef;
import eu.miltema.slimweb.controller.HttpGetAccessor;
import eu.miltema.slimweb.controller.HttpPostAccessor;
import eu.miltema.slimweb.controller.MethodDef;
import eu.miltema.slimweb.controller.Redirect;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/controller/*"})
public class ControllerServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ControllerServlet.class);
    private Map<String, ComponentDef> mapComponents;
    private Map<Class<?>, ComponentDef> mapComponentClasses = new HashMap();
    private Map<Class<?>, ArgumentInjector> mapInjectors = new HashMap();
    private ApplicationInitializer initializer;
    private String[] validOrigins;

    public void init(ServletConfig config) throws ServletException {
        try {
            ComponentsReader cr = new ComponentsReader(s -> log.debug(s));
            this.mapComponents = cr.getComponentsAsStream().map(c -> new ComponentDef((Class<?>)c)).peek(c -> this.mapComponentClasses.put(c.clazz, (ComponentDef)c)).collect(Collectors.toMap(c -> c.url, c -> c));
            if (this.mapComponents.isEmpty()) {
                log.warn("No component definitions were found");
            }
            this.mapInjectors.put(HttpAccessor.class, a -> a);
            this.mapInjectors.put(HttpServletRequest.class, a -> a.request);
            this.mapInjectors.put(HttpServletResponse.class, a -> a.response);
            this.mapInjectors.put(HttpSession.class, a -> a.request.getSession(false));
            this.initializer = cr.getInitializer();
            this.initializer.registerInjectors(this.mapInjectors);
            this.validOrigins = this.initializer.getValidOrigins();
            this.mapComponents.values().forEach(cdef -> cdef.methods.values().forEach(mdef -> mdef.init(this.mapInjectors)));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.serviceRequest(new HttpGetAccessor().init(req, resp, "get"));
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.serviceRequest(new HttpGetAccessor().init(req, resp, "delete").detectCsrf(this.validOrigins));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.serviceRequest(new HttpPostAccessor().init(req, resp, "post").detectCsrf(this.validOrigins));
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.serviceRequest(new HttpPostAccessor().init(req, resp, "put").detectCsrf(this.validOrigins));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRequest(HttpAccessor htAccessor) throws IOException {
        String requestName = htAccessor.getUrl();
        log.info("Request " + requestName);
        try {
            try {
                Object returnValue;
                String componentName = htAccessor.getComponentName();
                String actionName = htAccessor.getActionName();
                ComponentDef cdef = this.mapComponents.get(componentName);
                if (cdef == null) {
                    throw new HttpException(404, "Cannot map /{0} to component", componentName);
                }
                MethodDef mdef = cdef.methods.get(htAccessor.getMethod() + ":" + (actionName == null ? "" : actionName));
                if (mdef == null) {
                    throw new HttpException(404, "Cannot map /{0} to action", actionName);
                }
                if (htAccessor.request.getSession(false) == null && cdef.requiresSession && mdef.requiresSession) {
                    throw new Redirect(this.initializer.getLoginView());
                }
                Gson gson = new Gson();
                String json = htAccessor.getParametersAsJson();
                Object component = gson.fromJson(json, cdef.clazz);
                if (component == null) {
                    component = cdef.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if ((returnValue = mdef.invoke(component, htAccessor)) != null) {
                    htAccessor.response.getWriter().write(gson.toJson(returnValue));
                }
            }
            catch (Redirect redirect) {
                this.redirect(htAccessor, redirect);
            }
            catch (HttpException he) {
                throw he;
            }
            catch (Throwable t) {
                log.error("", t);
                throw new HttpException(500, "Service internal error", new String[0]);
            }
            log.debug("Finished " + requestName);
        }
        catch (HttpException he) {
            htAccessor.response.sendError(he.getHttpCode(), he.getMessage());
            log.debug("Error " + he.getHttpCode() + "[" + he.getMessage() + "] in " + requestName);
        }
        finally {
            htAccessor.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
            long tm = System.currentTimeMillis();
            htAccessor.response.setDateHeader("Expires", tm);
            htAccessor.response.setDateHeader("Last-Modified", tm);
            htAccessor.response.flushBuffer();
        }
    }

    private void redirect(HttpAccessor htAccessor, Redirect redirect) throws IOException {
        Object targetPath = redirect.pathToView;
        if (targetPath == null) {
            ComponentDef cdef = this.mapComponentClasses.get(redirect.targetComponent);
            if (cdef == null) {
                throw new HttpException(500, "Redirecting to non-@Component " + redirect.targetComponent.getName() + " is not allowed", new String[0]);
            }
            targetPath = "/view/" + cdef.url;
        } else if (redirect.pathToView.indexOf(47) < 0) {
            targetPath = (htAccessor.getActionName() == null ? "" : "../") + "../view/" + ((String)targetPath).replaceAll("(.+)\\.(html|htm|js)", "$1");
        }
        htAccessor.response.getWriter().write("s");
        htAccessor.response.setHeader("Location", (String)targetPath);
        boolean acceptsJson = "application/json".equals(htAccessor.request.getContentType());
        htAccessor.response.setStatus(acceptsJson ? 250 : 303);
    }
}

