/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimweb.push;

import com.google.gson.Gson;
import eu.miltema.slimweb.push.PushHandle;
import eu.miltema.slimweb.push.ServerPush;
import java.io.IOException;
import javax.servlet.http.HttpSession;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushHandleImpl
implements PushHandle {
    private static final Logger log = LoggerFactory.getLogger(PushHandleImpl.class);
    private Session websocketSession;
    private Gson gson = new Gson();
    private HttpSession httpSession;
    Class<? extends ServerPush> componentClass;
    String componentName;

    public PushHandleImpl(HttpSession httpSession, Session websocketSession) {
        this.httpSession = httpSession;
        this.websocketSession = websocketSession;
    }

    @Override
    public void terminatePush() {
        try {
            this.websocketSession.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void pushObject(Object object) {
        try {
            this.websocketSession.getBasicRemote().sendText(this.gson.toJson(object));
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public boolean isPushOpen() {
        return this.websocketSession.isOpen();
    }

    @Override
    public HttpSession getSession() {
        return this.httpSession;
    }
}

